/*
 * Decompiled with CFR 0.152.
 */
package org.h2.message;

import java.text.MessageFormat;
import java.util.ArrayList;
import org.h2.engine.SysProperties;
import org.h2.expression.ParameterInterface;
import org.h2.message.TraceWriter;
import org.h2.util.StatementBuilder;
import org.h2.util.StringUtils;
import org.h2.value.Value;

public class Trace {
    public static final int COMMAND = 0;
    public static final int CONSTRAINT = 1;
    public static final int DATABASE = 2;
    public static final int FUNCTION = 3;
    public static final int FILE_LOCK = 4;
    public static final int INDEX = 5;
    public static final int JDBC = 6;
    public static final int LOCK = 7;
    public static final int SCHEMA = 8;
    public static final int SEQUENCE = 9;
    public static final int SETTING = 10;
    public static final int TABLE = 11;
    public static final int TRIGGER = 12;
    public static final int USER = 13;
    public static final int PAGE_STORE = 14;
    public static final int JDBCX = 15;
    public static final String[] MODULE_NAMES = new String[]{"command", "constraint", "database", "function", "fileLock", "index", "jdbc", "lock", "schema", "sequence", "setting", "table", "trigger", "user", "pageStore", "JDBCX"};
    private final TraceWriter traceWriter;
    private final String module;
    private final String lineSeparator;
    private int traceLevel = -1;

    Trace(TraceWriter traceWriter, int moduleId) {
        this(traceWriter, MODULE_NAMES[moduleId]);
    }

    Trace(TraceWriter traceWriter, String module) {
        this.traceWriter = traceWriter;
        this.module = module;
        this.lineSeparator = SysProperties.LINE_SEPARATOR;
    }

    public void setLevel(int level) {
        this.traceLevel = level;
    }

    private boolean isEnabled(int level) {
        if (this.traceLevel == -1) {
            return this.traceWriter.isEnabled(level);
        }
        return level <= this.traceLevel;
    }

    public boolean isInfoEnabled() {
        return this.isEnabled(2);
    }

    public boolean isDebugEnabled() {
        return this.isEnabled(3);
    }

    public void error(Throwable t, String s) {
        if (this.isEnabled(1)) {
            this.traceWriter.write(1, this.module, s, t);
        }
    }

    public void error(Throwable t, String s, Object ... params) {
        if (this.isEnabled(1)) {
            s = MessageFormat.format(s, params);
            this.traceWriter.write(1, this.module, s, t);
        }
    }

    public void info(String s) {
        if (this.isEnabled(2)) {
            this.traceWriter.write(2, this.module, s, null);
        }
    }

    public void info(String s, Object ... params) {
        if (this.isEnabled(2)) {
            s = MessageFormat.format(s, params);
            this.traceWriter.write(2, this.module, s, null);
        }
    }

    void info(Throwable t, String s) {
        if (this.isEnabled(2)) {
            this.traceWriter.write(2, this.module, s, t);
        }
    }

    public static String formatParams(ArrayList<? extends ParameterInterface> parameters) {
        if (parameters.size() == 0) {
            return "";
        }
        StatementBuilder buff = new StatementBuilder();
        int i = 0;
        boolean params = false;
        for (ParameterInterface parameterInterface : parameters) {
            if (!parameterInterface.isValueSet()) continue;
            if (!params) {
                buff.append(" {");
                params = true;
            }
            buff.appendExceptFirst(", ");
            Value v = parameterInterface.getParamValue();
            buff.append(++i).append(": ").append(v.getTraceSQL());
        }
        if (params) {
            buff.append('}');
        }
        return buff.toString();
    }

    public void infoSQL(String sql, String params, int count, long time) {
        if (!this.isEnabled(2)) {
            return;
        }
        StringBuilder buff = new StringBuilder(sql.length() + params.length() + 20);
        buff.append(this.lineSeparator).append("/*SQL");
        boolean space = false;
        if (params.length() > 0) {
            space = true;
            buff.append(" l:").append(sql.length());
        }
        if (count > 0) {
            space = true;
            buff.append(" #:").append(count);
        }
        if (time > 0L) {
            space = true;
            buff.append(" t:").append(time);
        }
        if (!space) {
            buff.append(' ');
        }
        buff.append("*/").append(StringUtils.javaEncode(sql)).append(StringUtils.javaEncode(params)).append(';');
        sql = buff.toString();
        this.traceWriter.write(2, this.module, sql, null);
    }

    public void debug(String s, Object ... params) {
        if (this.isEnabled(3)) {
            s = MessageFormat.format(s, params);
            this.traceWriter.write(3, this.module, s, null);
        }
    }

    public void debug(String s) {
        if (this.isEnabled(3)) {
            this.traceWriter.write(3, this.module, s, null);
        }
    }

    public void debug(Throwable t, String s) {
        if (this.isEnabled(3)) {
            this.traceWriter.write(3, this.module, s, t);
        }
    }

    public void infoCode(String java) {
        if (this.isEnabled(2)) {
            this.traceWriter.write(2, this.module, this.lineSeparator + "/**/" + java, null);
        }
    }

    void debugCode(String java) {
        if (this.isEnabled(3)) {
            this.traceWriter.write(3, this.module, this.lineSeparator + "/**/" + java, null);
        }
    }
}

