/*
 * Decompiled with CFR 0.152.
 */
package org.h2.mvstore.type;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.UUID;
import org.h2.mvstore.DataUtils;
import org.h2.mvstore.WriteBuffer;
import org.h2.mvstore.type.DataType;
import org.h2.mvstore.type.StringDataType;
import org.h2.util.New;

public class ObjectDataType
implements DataType {
    static final int TYPE_NULL = 0;
    static final int TYPE_BOOLEAN = 1;
    static final int TYPE_BYTE = 2;
    static final int TYPE_SHORT = 3;
    static final int TYPE_INT = 4;
    static final int TYPE_LONG = 5;
    static final int TYPE_BIG_INTEGER = 6;
    static final int TYPE_FLOAT = 7;
    static final int TYPE_DOUBLE = 8;
    static final int TYPE_BIG_DECIMAL = 9;
    static final int TYPE_CHAR = 10;
    static final int TYPE_STRING = 11;
    static final int TYPE_UUID = 12;
    static final int TYPE_DATE = 13;
    static final int TYPE_ARRAY = 14;
    static final int TYPE_SERIALIZED_OBJECT = 19;
    static final int TAG_BOOLEAN_TRUE = 32;
    static final int TAG_INTEGER_NEGATIVE = 33;
    static final int TAG_INTEGER_FIXED = 34;
    static final int TAG_LONG_NEGATIVE = 35;
    static final int TAG_LONG_FIXED = 36;
    static final int TAG_BIG_INTEGER_0 = 37;
    static final int TAG_BIG_INTEGER_1 = 38;
    static final int TAG_BIG_INTEGER_SMALL = 39;
    static final int TAG_FLOAT_0 = 40;
    static final int TAG_FLOAT_1 = 41;
    static final int TAG_FLOAT_FIXED = 42;
    static final int TAG_DOUBLE_0 = 43;
    static final int TAG_DOUBLE_1 = 44;
    static final int TAG_DOUBLE_FIXED = 45;
    static final int TAG_BIG_DECIMAL_0 = 46;
    static final int TAG_BIG_DECIMAL_1 = 47;
    static final int TAG_BIG_DECIMAL_SMALL = 48;
    static final int TAG_BIG_DECIMAL_SMALL_SCALED = 49;
    static final int TAG_INTEGER_0_15 = 64;
    static final int TAG_LONG_0_7 = 80;
    static final int TAG_STRING_0_15 = 88;
    static final int TAG_BYTE_ARRAY_0_15 = 104;
    static final int FLOAT_ZERO_BITS = Float.floatToIntBits(0.0f);
    static final int FLOAT_ONE_BITS = Float.floatToIntBits(1.0f);
    static final long DOUBLE_ZERO_BITS = Double.doubleToLongBits(0.0);
    static final long DOUBLE_ONE_BITS = Double.doubleToLongBits(1.0);
    static final Class<?>[] COMMON_CLASSES = new Class[]{Boolean.TYPE, Byte.TYPE, Short.TYPE, Character.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE, Object.class, Boolean.class, Byte.class, Short.class, Character.class, Integer.class, Long.class, BigInteger.class, Float.class, Double.class, BigDecimal.class, String.class, UUID.class, Date.class};
    private static final HashMap<Class<?>, Integer> COMMON_CLASSES_MAP = New.hashMap();
    private AutoDetectDataType last = new StringType(this);

    @Override
    public int compare(Object a, Object b) {
        return this.last.compare(a, b);
    }

    @Override
    public int getMemory(Object obj) {
        return this.last.getMemory(obj);
    }

    @Override
    public void read(ByteBuffer buff, Object[] obj, int len, boolean key) {
        for (int i = 0; i < len; ++i) {
            obj[i] = this.read(buff);
        }
    }

    @Override
    public void write(WriteBuffer buff, Object[] obj, int len, boolean key) {
        for (int i = 0; i < len; ++i) {
            this.write(buff, obj[i]);
        }
    }

    @Override
    public void write(WriteBuffer buff, Object obj) {
        this.last.write(buff, obj);
    }

    private AutoDetectDataType newType(int typeId) {
        switch (typeId) {
            case 0: {
                return new NullType(this);
            }
            case 1: {
                return new BooleanType(this);
            }
            case 2: {
                return new ByteType(this);
            }
            case 3: {
                return new ShortType(this);
            }
            case 10: {
                return new CharacterType(this);
            }
            case 4: {
                return new IntegerType(this);
            }
            case 5: {
                return new LongType(this);
            }
            case 7: {
                return new FloatType(this);
            }
            case 8: {
                return new DoubleType(this);
            }
            case 6: {
                return new BigIntegerType(this);
            }
            case 9: {
                return new BigDecimalType(this);
            }
            case 11: {
                return new StringType(this);
            }
            case 12: {
                return new UUIDType(this);
            }
            case 13: {
                return new DateType(this);
            }
            case 14: {
                return new ObjectArrayType(this);
            }
            case 19: {
                return new SerializedObjectType(this);
            }
        }
        throw DataUtils.newIllegalStateException(3, "Unsupported type {0}", typeId);
    }

    @Override
    public Object read(ByteBuffer buff) {
        int typeId;
        int tag = buff.get();
        if (tag <= 19) {
            typeId = tag;
        } else {
            switch (tag) {
                case 32: {
                    typeId = 1;
                    break;
                }
                case 33: 
                case 34: {
                    typeId = 4;
                    break;
                }
                case 35: 
                case 36: {
                    typeId = 5;
                    break;
                }
                case 37: 
                case 38: 
                case 39: {
                    typeId = 6;
                    break;
                }
                case 40: 
                case 41: 
                case 42: {
                    typeId = 7;
                    break;
                }
                case 43: 
                case 44: 
                case 45: {
                    typeId = 8;
                    break;
                }
                case 46: 
                case 47: 
                case 48: 
                case 49: {
                    typeId = 9;
                    break;
                }
                default: {
                    if (tag >= 64 && tag <= 79) {
                        typeId = 4;
                        break;
                    }
                    if (tag >= 88 && tag <= 103) {
                        typeId = 11;
                        break;
                    }
                    if (tag >= 80 && tag <= 87) {
                        typeId = 5;
                        break;
                    }
                    if (tag >= 104 && tag <= 119) {
                        typeId = 14;
                        break;
                    }
                    throw DataUtils.newIllegalStateException(6, "Unknown tag {0}", tag);
                }
            }
        }
        AutoDetectDataType t = this.last;
        if (typeId != t.typeId) {
            this.last = t = this.newType(typeId);
        }
        return t.read(buff, tag);
    }

    private static int getTypeId(Object obj) {
        if (obj instanceof Integer) {
            return 4;
        }
        if (obj instanceof String) {
            return 11;
        }
        if (obj instanceof Long) {
            return 5;
        }
        if (obj instanceof Double) {
            return 8;
        }
        if (obj instanceof Float) {
            return 7;
        }
        if (obj instanceof Boolean) {
            return 1;
        }
        if (obj instanceof UUID) {
            return 12;
        }
        if (obj instanceof Byte) {
            return 2;
        }
        if (obj instanceof Short) {
            return 3;
        }
        if (obj instanceof Character) {
            return 10;
        }
        if (obj == null) {
            return 0;
        }
        if (ObjectDataType.isDate(obj)) {
            return 13;
        }
        if (ObjectDataType.isBigInteger(obj)) {
            return 6;
        }
        if (ObjectDataType.isBigDecimal(obj)) {
            return 9;
        }
        if (obj.getClass().isArray()) {
            return 14;
        }
        return 19;
    }

    AutoDetectDataType switchType(Object obj) {
        int typeId = ObjectDataType.getTypeId(obj);
        AutoDetectDataType l = this.last;
        if (typeId != l.typeId) {
            this.last = l = this.newType(typeId);
        }
        return l;
    }

    static boolean isBigInteger(Object obj) {
        return obj instanceof BigInteger && obj.getClass() == BigInteger.class;
    }

    static boolean isBigDecimal(Object obj) {
        return obj instanceof BigDecimal && obj.getClass() == BigDecimal.class;
    }

    static boolean isDate(Object obj) {
        return obj instanceof Date && obj.getClass() == Date.class;
    }

    static boolean isArray(Object obj) {
        return obj != null && obj.getClass().isArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Integer getCommonClassId(Class<?> clazz) {
        HashMap<Class<?>, Integer> map = COMMON_CLASSES_MAP;
        if (map.size() == 0) {
            HashMap<Class<?>, Integer> hashMap = map;
            synchronized (hashMap) {
                if (map.size() == 0) {
                    int size = COMMON_CLASSES.length;
                    for (int i = 0; i < size; ++i) {
                        map.put(COMMON_CLASSES[i], i);
                    }
                }
            }
        }
        return map.get(clazz);
    }

    public static byte[] serialize(Object obj) {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            ObjectOutputStream os = new ObjectOutputStream(out);
            os.writeObject(obj);
            return out.toByteArray();
        }
        catch (Throwable e) {
            throw DataUtils.newIllegalArgumentException("Could not serialize {0}", obj, e);
        }
    }

    public static Object deserialize(byte[] data) {
        try {
            ByteArrayInputStream in = new ByteArrayInputStream(data);
            ObjectInputStream is = new ObjectInputStream(in);
            return is.readObject();
        }
        catch (Throwable e) {
            throw DataUtils.newIllegalArgumentException("Could not deserialize {0}", Arrays.toString(data), e);
        }
    }

    public static int compareNotNull(byte[] data1, byte[] data2) {
        if (data1 == data2) {
            return 0;
        }
        int len = Math.min(data1.length, data2.length);
        for (int i = 0; i < len; ++i) {
            int b = data1[i] & 0xFF;
            int b2 = data2[i] & 0xFF;
            if (b == b2) continue;
            return b > b2 ? 1 : -1;
        }
        return Integer.signum(data1.length - data2.length);
    }

    static class SerializedObjectType
    extends AutoDetectDataType {
        private int averageSize = 10000;

        SerializedObjectType(ObjectDataType base) {
            super(base, 19);
        }

        @Override
        public int compare(Object aObj, Object bObj) {
            if (aObj == bObj) {
                return 0;
            }
            AutoDetectDataType ta = this.getType(aObj);
            AutoDetectDataType tb = this.getType(bObj);
            if (ta != this || tb != this) {
                if (ta == tb) {
                    return ta.compare(aObj, bObj);
                }
                return super.compare(aObj, bObj);
            }
            if (aObj instanceof Comparable && aObj.getClass().isAssignableFrom(bObj.getClass())) {
                return ((Comparable)aObj).compareTo(bObj);
            }
            if (bObj instanceof Comparable && bObj.getClass().isAssignableFrom(aObj.getClass())) {
                return -((Comparable)bObj).compareTo(aObj);
            }
            byte[] a = ObjectDataType.serialize(aObj);
            byte[] b = ObjectDataType.serialize(bObj);
            return ObjectDataType.compareNotNull(a, b);
        }

        @Override
        public int getMemory(Object obj) {
            AutoDetectDataType t = this.getType(obj);
            if (t == this) {
                return this.averageSize;
            }
            return t.getMemory(obj);
        }

        @Override
        public void write(WriteBuffer buff, Object obj) {
            AutoDetectDataType t = this.getType(obj);
            if (t != this) {
                t.write(buff, obj);
                return;
            }
            byte[] data = ObjectDataType.serialize(obj);
            int size = data.length * 2;
            this.averageSize = (size + 15 * this.averageSize) / 16;
            buff.put((byte)19).putVarInt(data.length).put(data);
        }

        @Override
        public Object read(ByteBuffer buff, int tag) {
            int len = DataUtils.readVarInt(buff);
            byte[] data = DataUtils.newBytes(len);
            buff.get(data);
            return ObjectDataType.deserialize(data);
        }
    }

    static class ObjectArrayType
    extends AutoDetectDataType {
        private final ObjectDataType elementType = new ObjectDataType();

        ObjectArrayType(ObjectDataType base) {
            super(base, 14);
        }

        @Override
        public int getMemory(Object obj) {
            int size;
            block4: {
                block2: {
                    int len;
                    Class<?> type;
                    block10: {
                        block9: {
                            block8: {
                                block7: {
                                    block6: {
                                        block5: {
                                            block3: {
                                                if (!ObjectDataType.isArray(obj)) {
                                                    return super.getMemory(obj);
                                                }
                                                size = 64;
                                                type = obj.getClass().getComponentType();
                                                if (!type.isPrimitive()) break block2;
                                                len = Array.getLength(obj);
                                                if (type != Boolean.TYPE) break block3;
                                                size += len;
                                                break block4;
                                            }
                                            if (type != Byte.TYPE) break block5;
                                            size += len;
                                            break block4;
                                        }
                                        if (type != Character.TYPE) break block6;
                                        size += len * 2;
                                        break block4;
                                    }
                                    if (type != Short.TYPE) break block7;
                                    size += len * 2;
                                    break block4;
                                }
                                if (type != Integer.TYPE) break block8;
                                size += len * 4;
                                break block4;
                            }
                            if (type != Float.TYPE) break block9;
                            size += len * 4;
                            break block4;
                        }
                        if (type != Double.TYPE) break block10;
                        size += len * 8;
                        break block4;
                    }
                    if (type != Long.TYPE) break block4;
                    size += len * 8;
                    break block4;
                }
                for (Object x : (Object[])obj) {
                    if (x == null) continue;
                    size += this.elementType.getMemory(x);
                }
            }
            return size * 2;
        }

        @Override
        public int compare(Object aObj, Object bObj) {
            Class<?> bType;
            if (!ObjectDataType.isArray(aObj) || !ObjectDataType.isArray(bObj)) {
                return super.compare(aObj, bObj);
            }
            if (aObj == bObj) {
                return 0;
            }
            Class<?> type = aObj.getClass().getComponentType();
            if (type != (bType = bObj.getClass().getComponentType())) {
                Integer classA = ObjectDataType.getCommonClassId(type);
                Integer classB = ObjectDataType.getCommonClassId(bType);
                if (classA != null) {
                    if (classB != null) {
                        return classA.compareTo(classB);
                    }
                    return -1;
                }
                if (classB != null) {
                    return 1;
                }
                return type.getName().compareTo(bType.getName());
            }
            int aLen = Array.getLength(aObj);
            int bLen = Array.getLength(bObj);
            int len = Math.min(aLen, bLen);
            if (type.isPrimitive()) {
                if (type == Byte.TYPE) {
                    byte[] a = (byte[])aObj;
                    byte[] b = (byte[])bObj;
                    return ObjectDataType.compareNotNull(a, b);
                }
                for (int i = 0; i < len; ++i) {
                    int x;
                    if (type == Boolean.TYPE) {
                        x = Integer.signum((((boolean[])aObj)[i] ? 1 : 0) - (((boolean[])bObj)[i] ? 1 : 0));
                    } else if (type == Character.TYPE) {
                        x = Integer.signum(((char[])aObj)[i] - ((char[])bObj)[i]);
                    } else if (type == Short.TYPE) {
                        x = Integer.signum(((short[])aObj)[i] - ((short[])bObj)[i]);
                    } else if (type == Integer.TYPE) {
                        int a = ((int[])aObj)[i];
                        int b = ((int[])bObj)[i];
                        x = a == b ? 0 : (a < b ? -1 : 1);
                    } else if (type == Float.TYPE) {
                        x = Float.compare(((float[])aObj)[i], ((float[])bObj)[i]);
                    } else if (type == Double.TYPE) {
                        x = Double.compare(((double[])aObj)[i], ((double[])bObj)[i]);
                    } else {
                        long a = ((long[])aObj)[i];
                        long b = ((long[])bObj)[i];
                        int n = a == b ? 0 : (x = a < b ? -1 : 1);
                    }
                    if (x == 0) continue;
                    return x;
                }
            } else {
                Object[] a = (Object[])aObj;
                Object[] b = (Object[])bObj;
                for (int i = 0; i < len; ++i) {
                    int comp = this.elementType.compare(a[i], b[i]);
                    if (comp == 0) continue;
                    return comp;
                }
            }
            return aLen == bLen ? 0 : (aLen < bLen ? -1 : 1);
        }

        @Override
        public void write(WriteBuffer buff, Object obj) {
            if (!ObjectDataType.isArray(obj)) {
                super.write(buff, obj);
                return;
            }
            Class<?> type = obj.getClass().getComponentType();
            Integer classId = ObjectDataType.getCommonClassId(type);
            if (classId != null) {
                if (type.isPrimitive()) {
                    if (type == Byte.TYPE) {
                        byte[] data = (byte[])obj;
                        int len = data.length;
                        if (len <= 15) {
                            buff.put((byte)(104 + len));
                        } else {
                            buff.put((byte)14).put((byte)classId.intValue()).putVarInt(len);
                        }
                        buff.put(data);
                        return;
                    }
                    int len = Array.getLength(obj);
                    buff.put((byte)14).put((byte)classId.intValue()).putVarInt(len);
                    for (int i = 0; i < len; ++i) {
                        if (type == Boolean.TYPE) {
                            buff.put((byte)(((boolean[])obj)[i] ? 1 : 0));
                            continue;
                        }
                        if (type == Character.TYPE) {
                            buff.putChar(((char[])obj)[i]);
                            continue;
                        }
                        if (type == Short.TYPE) {
                            buff.putShort(((short[])obj)[i]);
                            continue;
                        }
                        if (type == Integer.TYPE) {
                            buff.putInt(((int[])obj)[i]);
                            continue;
                        }
                        if (type == Float.TYPE) {
                            buff.putFloat(((float[])obj)[i]);
                            continue;
                        }
                        if (type == Double.TYPE) {
                            buff.putDouble(((double[])obj)[i]);
                            continue;
                        }
                        buff.putLong(((long[])obj)[i]);
                    }
                    return;
                }
                buff.put((byte)14).put((byte)classId.intValue());
            } else {
                buff.put((byte)14).put((byte)-1);
                String c = type.getName();
                StringDataType.INSTANCE.write(buff, c);
            }
            Object[] array = (Object[])obj;
            int len = array.length;
            buff.putVarInt(len);
            for (Object x : array) {
                this.elementType.write(buff, x);
            }
        }

        @Override
        public Object read(ByteBuffer buff, int tag) {
            Object obj;
            Class<?> clazz;
            if (tag != 14) {
                int len = tag - 104;
                byte[] data = DataUtils.newBytes(len);
                buff.get(data);
                return data;
            }
            byte ct = buff.get();
            if (ct == -1) {
                String componentType = StringDataType.INSTANCE.read(buff);
                try {
                    clazz = Class.forName(componentType);
                }
                catch (Exception e) {
                    throw DataUtils.newIllegalStateException(8, "Could not get class {0}", componentType, e);
                }
            } else {
                clazz = COMMON_CLASSES[ct];
            }
            int len = DataUtils.readVarInt(buff);
            try {
                obj = Array.newInstance(clazz, len);
            }
            catch (Exception e) {
                throw DataUtils.newIllegalStateException(8, "Could not create array of type {0} length {1}", clazz, len, e);
            }
            if (clazz.isPrimitive()) {
                for (int i = 0; i < len; ++i) {
                    if (clazz == Boolean.TYPE) {
                        ((boolean[])obj)[i] = buff.get() == 1;
                        continue;
                    }
                    if (clazz == Byte.TYPE) {
                        ((byte[])obj)[i] = buff.get();
                        continue;
                    }
                    if (clazz == Character.TYPE) {
                        ((char[])obj)[i] = buff.getChar();
                        continue;
                    }
                    if (clazz == Short.TYPE) {
                        ((short[])obj)[i] = buff.getShort();
                        continue;
                    }
                    if (clazz == Integer.TYPE) {
                        ((int[])obj)[i] = buff.getInt();
                        continue;
                    }
                    if (clazz == Float.TYPE) {
                        ((float[])obj)[i] = buff.getFloat();
                        continue;
                    }
                    if (clazz == Double.TYPE) {
                        ((double[])obj)[i] = buff.getDouble();
                        continue;
                    }
                    ((long[])obj)[i] = buff.getLong();
                }
            } else {
                Object[] array = (Object[])obj;
                for (int i = 0; i < len; ++i) {
                    array[i] = this.elementType.read(buff);
                }
            }
            return obj;
        }
    }

    static class DateType
    extends AutoDetectDataType {
        DateType(ObjectDataType base) {
            super(base, 13);
        }

        @Override
        public int getMemory(Object obj) {
            return ObjectDataType.isDate(obj) ? 40 : super.getMemory(obj);
        }

        @Override
        public int compare(Object aObj, Object bObj) {
            if (ObjectDataType.isDate(aObj) && ObjectDataType.isDate(bObj)) {
                Date a = (Date)aObj;
                Date b = (Date)bObj;
                return a.compareTo(b);
            }
            return super.compare(aObj, bObj);
        }

        @Override
        public void write(WriteBuffer buff, Object obj) {
            if (!ObjectDataType.isDate(obj)) {
                super.write(buff, obj);
                return;
            }
            buff.put((byte)13);
            Date a = (Date)obj;
            buff.putLong(a.getTime());
        }

        @Override
        public Object read(ByteBuffer buff, int tag) {
            long a = buff.getLong();
            return new Date(a);
        }
    }

    static class UUIDType
    extends AutoDetectDataType {
        UUIDType(ObjectDataType base) {
            super(base, 12);
        }

        @Override
        public int getMemory(Object obj) {
            return obj instanceof UUID ? 40 : super.getMemory(obj);
        }

        @Override
        public int compare(Object aObj, Object bObj) {
            if (aObj instanceof UUID && bObj instanceof UUID) {
                UUID a = (UUID)aObj;
                UUID b = (UUID)bObj;
                return a.compareTo(b);
            }
            return super.compare(aObj, bObj);
        }

        @Override
        public void write(WriteBuffer buff, Object obj) {
            if (!(obj instanceof UUID)) {
                super.write(buff, obj);
                return;
            }
            buff.put((byte)12);
            UUID a = (UUID)obj;
            buff.putLong(a.getMostSignificantBits());
            buff.putLong(a.getLeastSignificantBits());
        }

        @Override
        public Object read(ByteBuffer buff, int tag) {
            long a = buff.getLong();
            long b = buff.getLong();
            return new UUID(a, b);
        }
    }

    static class StringType
    extends AutoDetectDataType {
        StringType(ObjectDataType base) {
            super(base, 11);
        }

        @Override
        public int getMemory(Object obj) {
            if (!(obj instanceof String)) {
                return super.getMemory(obj);
            }
            return 24 + 2 * obj.toString().length();
        }

        @Override
        public int compare(Object aObj, Object bObj) {
            if (aObj instanceof String && bObj instanceof String) {
                return aObj.toString().compareTo(bObj.toString());
            }
            return super.compare(aObj, bObj);
        }

        @Override
        public void write(WriteBuffer buff, Object obj) {
            if (!(obj instanceof String)) {
                super.write(buff, obj);
                return;
            }
            String s = (String)obj;
            int len = s.length();
            if (len <= 15) {
                buff.put((byte)(88 + len));
            } else {
                buff.put((byte)11).putVarInt(len);
            }
            buff.putStringData(s, len);
        }

        @Override
        public Object read(ByteBuffer buff, int tag) {
            int len = tag == 11 ? DataUtils.readVarInt(buff) : tag - 88;
            return DataUtils.readString(buff, len);
        }
    }

    static class BigDecimalType
    extends AutoDetectDataType {
        BigDecimalType(ObjectDataType base) {
            super(base, 9);
        }

        @Override
        public int compare(Object aObj, Object bObj) {
            if (ObjectDataType.isBigDecimal(aObj) && ObjectDataType.isBigDecimal(bObj)) {
                BigDecimal a = (BigDecimal)aObj;
                BigDecimal b = (BigDecimal)bObj;
                return a.compareTo(b);
            }
            return super.compare(aObj, bObj);
        }

        @Override
        public int getMemory(Object obj) {
            return ObjectDataType.isBigDecimal(obj) ? 150 : super.getMemory(obj);
        }

        @Override
        public void write(WriteBuffer buff, Object obj) {
            if (!ObjectDataType.isBigDecimal(obj)) {
                super.write(buff, obj);
                return;
            }
            BigDecimal x = (BigDecimal)obj;
            if (BigDecimal.ZERO.equals(x)) {
                buff.put((byte)46);
            } else if (BigDecimal.ONE.equals(x)) {
                buff.put((byte)47);
            } else {
                int scale = x.scale();
                BigInteger b = x.unscaledValue();
                int bits = b.bitLength();
                if (bits < 64) {
                    if (scale == 0) {
                        buff.put((byte)48);
                    } else {
                        buff.put((byte)49).putVarInt(scale);
                    }
                    buff.putVarLong(b.longValue());
                } else {
                    byte[] bytes = b.toByteArray();
                    buff.put((byte)9).putVarInt(scale).putVarInt(bytes.length).put(bytes);
                }
            }
        }

        @Override
        public Object read(ByteBuffer buff, int tag) {
            switch (tag) {
                case 46: {
                    return BigDecimal.ZERO;
                }
                case 47: {
                    return BigDecimal.ONE;
                }
                case 48: {
                    return BigDecimal.valueOf(DataUtils.readVarLong(buff));
                }
                case 49: {
                    int scale = DataUtils.readVarInt(buff);
                    return BigDecimal.valueOf(DataUtils.readVarLong(buff), scale);
                }
            }
            int scale = DataUtils.readVarInt(buff);
            int len = DataUtils.readVarInt(buff);
            byte[] bytes = DataUtils.newBytes(len);
            buff.get(bytes);
            BigInteger b = new BigInteger(bytes);
            return new BigDecimal(b, scale);
        }
    }

    static class BigIntegerType
    extends AutoDetectDataType {
        BigIntegerType(ObjectDataType base) {
            super(base, 6);
        }

        @Override
        public int compare(Object aObj, Object bObj) {
            if (ObjectDataType.isBigInteger(aObj) && ObjectDataType.isBigInteger(bObj)) {
                BigInteger a = (BigInteger)aObj;
                BigInteger b = (BigInteger)bObj;
                return a.compareTo(b);
            }
            return super.compare(aObj, bObj);
        }

        @Override
        public int getMemory(Object obj) {
            return ObjectDataType.isBigInteger(obj) ? 100 : super.getMemory(obj);
        }

        @Override
        public void write(WriteBuffer buff, Object obj) {
            if (!ObjectDataType.isBigInteger(obj)) {
                super.write(buff, obj);
                return;
            }
            BigInteger x = (BigInteger)obj;
            if (BigInteger.ZERO.equals(x)) {
                buff.put((byte)37);
            } else if (BigInteger.ONE.equals(x)) {
                buff.put((byte)38);
            } else {
                int bits = x.bitLength();
                if (bits <= 63) {
                    buff.put((byte)39).putVarLong(x.longValue());
                } else {
                    byte[] bytes = x.toByteArray();
                    buff.put((byte)6).putVarInt(bytes.length).put(bytes);
                }
            }
        }

        @Override
        public Object read(ByteBuffer buff, int tag) {
            switch (tag) {
                case 37: {
                    return BigInteger.ZERO;
                }
                case 38: {
                    return BigInteger.ONE;
                }
                case 39: {
                    return BigInteger.valueOf(DataUtils.readVarLong(buff));
                }
            }
            int len = DataUtils.readVarInt(buff);
            byte[] bytes = DataUtils.newBytes(len);
            buff.get(bytes);
            return new BigInteger(bytes);
        }
    }

    static class DoubleType
    extends AutoDetectDataType {
        DoubleType(ObjectDataType base) {
            super(base, 8);
        }

        @Override
        public int compare(Object aObj, Object bObj) {
            if (aObj instanceof Double && bObj instanceof Double) {
                Double a = (Double)aObj;
                Double b = (Double)bObj;
                return a.compareTo(b);
            }
            return super.compare(aObj, bObj);
        }

        @Override
        public int getMemory(Object obj) {
            return obj instanceof Double ? 30 : super.getMemory(obj);
        }

        @Override
        public void write(WriteBuffer buff, Object obj) {
            if (!(obj instanceof Double)) {
                super.write(buff, obj);
                return;
            }
            double x = (Double)obj;
            long d = Double.doubleToLongBits(x);
            if (d == DOUBLE_ZERO_BITS) {
                buff.put((byte)43);
            } else if (d == DOUBLE_ONE_BITS) {
                buff.put((byte)44);
            } else {
                long value = Long.reverse(d);
                if (value >= 0L && value <= 0x1FFFFFFFFFFFFL) {
                    buff.put((byte)8);
                    buff.putVarLong(value);
                } else {
                    buff.put((byte)45);
                    buff.putDouble(x);
                }
            }
        }

        @Override
        public Object read(ByteBuffer buff, int tag) {
            switch (tag) {
                case 43: {
                    return 0.0;
                }
                case 44: {
                    return 1.0;
                }
                case 45: {
                    return buff.getDouble();
                }
            }
            return Double.longBitsToDouble(Long.reverse(DataUtils.readVarLong(buff)));
        }
    }

    static class FloatType
    extends AutoDetectDataType {
        FloatType(ObjectDataType base) {
            super(base, 7);
        }

        @Override
        public int compare(Object aObj, Object bObj) {
            if (aObj instanceof Float && bObj instanceof Float) {
                Float a = (Float)aObj;
                Float b = (Float)bObj;
                return a.compareTo(b);
            }
            return super.compare(aObj, bObj);
        }

        @Override
        public int getMemory(Object obj) {
            return obj instanceof Float ? 24 : super.getMemory(obj);
        }

        @Override
        public void write(WriteBuffer buff, Object obj) {
            if (!(obj instanceof Float)) {
                super.write(buff, obj);
                return;
            }
            float x = ((Float)obj).floatValue();
            int f = Float.floatToIntBits(x);
            if (f == FLOAT_ZERO_BITS) {
                buff.put((byte)40);
            } else if (f == FLOAT_ONE_BITS) {
                buff.put((byte)41);
            } else {
                int value = Integer.reverse(f);
                if (value >= 0 && value <= 0x1FFFFF) {
                    buff.put((byte)7).putVarInt(value);
                } else {
                    buff.put((byte)42).putFloat(x);
                }
            }
        }

        @Override
        public Object read(ByteBuffer buff, int tag) {
            switch (tag) {
                case 40: {
                    return Float.valueOf(0.0f);
                }
                case 41: {
                    return Float.valueOf(1.0f);
                }
                case 42: {
                    return Float.valueOf(buff.getFloat());
                }
            }
            return Float.valueOf(Float.intBitsToFloat(Integer.reverse(DataUtils.readVarInt(buff))));
        }
    }

    static class LongType
    extends AutoDetectDataType {
        LongType(ObjectDataType base) {
            super(base, 5);
        }

        @Override
        public int compare(Object aObj, Object bObj) {
            if (aObj instanceof Long && bObj instanceof Long) {
                Long a = (Long)aObj;
                Long b = (Long)bObj;
                return a.compareTo(b);
            }
            return super.compare(aObj, bObj);
        }

        @Override
        public int getMemory(Object obj) {
            return obj instanceof Long ? 30 : super.getMemory(obj);
        }

        @Override
        public void write(WriteBuffer buff, Object obj) {
            if (!(obj instanceof Long)) {
                super.write(buff, obj);
                return;
            }
            long x = (Long)obj;
            if (x < 0L) {
                if (-x < 0L || -x > 0x1FFFFFFFFFFFFL) {
                    buff.put((byte)36);
                    buff.putLong(x);
                } else {
                    buff.put((byte)35);
                    buff.putVarLong(-x);
                }
            } else if (x <= 7L) {
                buff.put((byte)(80L + x));
            } else if (x <= 0x1FFFFFFFFFFFFL) {
                buff.put((byte)5);
                buff.putVarLong(x);
            } else {
                buff.put((byte)36);
                buff.putLong(x);
            }
        }

        @Override
        public Object read(ByteBuffer buff, int tag) {
            switch (tag) {
                case 5: {
                    return DataUtils.readVarLong(buff);
                }
                case 35: {
                    return -DataUtils.readVarLong(buff);
                }
                case 36: {
                    return buff.getLong();
                }
            }
            return (long)(tag - 80);
        }
    }

    static class IntegerType
    extends AutoDetectDataType {
        IntegerType(ObjectDataType base) {
            super(base, 4);
        }

        @Override
        public int compare(Object aObj, Object bObj) {
            if (aObj instanceof Integer && bObj instanceof Integer) {
                Integer a = (Integer)aObj;
                Integer b = (Integer)bObj;
                return a.compareTo(b);
            }
            return super.compare(aObj, bObj);
        }

        @Override
        public int getMemory(Object obj) {
            return obj instanceof Integer ? 24 : super.getMemory(obj);
        }

        @Override
        public void write(WriteBuffer buff, Object obj) {
            if (!(obj instanceof Integer)) {
                super.write(buff, obj);
                return;
            }
            int x = (Integer)obj;
            if (x < 0) {
                if (-x < 0 || -x > 0x1FFFFF) {
                    buff.put((byte)34).putInt(x);
                } else {
                    buff.put((byte)33).putVarInt(-x);
                }
            } else if (x <= 15) {
                buff.put((byte)(64 + x));
            } else if (x <= 0x1FFFFF) {
                buff.put((byte)4).putVarInt(x);
            } else {
                buff.put((byte)34).putInt(x);
            }
        }

        @Override
        public Object read(ByteBuffer buff, int tag) {
            switch (tag) {
                case 4: {
                    return DataUtils.readVarInt(buff);
                }
                case 33: {
                    return -DataUtils.readVarInt(buff);
                }
                case 34: {
                    return buff.getInt();
                }
            }
            return tag - 64;
        }
    }

    static class ShortType
    extends AutoDetectDataType {
        ShortType(ObjectDataType base) {
            super(base, 3);
        }

        @Override
        public int compare(Object aObj, Object bObj) {
            if (aObj instanceof Short && bObj instanceof Short) {
                Short a = (Short)aObj;
                Short b = (Short)bObj;
                return a.compareTo(b);
            }
            return super.compare(aObj, bObj);
        }

        @Override
        public int getMemory(Object obj) {
            return obj instanceof Short ? 24 : super.getMemory(obj);
        }

        @Override
        public void write(WriteBuffer buff, Object obj) {
            if (!(obj instanceof Short)) {
                super.write(buff, obj);
                return;
            }
            buff.put((byte)3);
            buff.putShort((Short)obj);
        }

        @Override
        public Object read(ByteBuffer buff, int tag) {
            return buff.getShort();
        }
    }

    static class CharacterType
    extends AutoDetectDataType {
        CharacterType(ObjectDataType base) {
            super(base, 10);
        }

        @Override
        public int compare(Object aObj, Object bObj) {
            if (aObj instanceof Character && bObj instanceof Character) {
                Character a = (Character)aObj;
                Character b = (Character)bObj;
                return a.compareTo(b);
            }
            return super.compare(aObj, bObj);
        }

        @Override
        public int getMemory(Object obj) {
            return obj instanceof Character ? 24 : super.getMemory(obj);
        }

        @Override
        public void write(WriteBuffer buff, Object obj) {
            if (!(obj instanceof Character)) {
                super.write(buff, obj);
                return;
            }
            buff.put((byte)10);
            buff.putChar(((Character)obj).charValue());
        }

        @Override
        public Object read(ByteBuffer buff, int tag) {
            return Character.valueOf(buff.getChar());
        }
    }

    static class ByteType
    extends AutoDetectDataType {
        ByteType(ObjectDataType base) {
            super(base, 2);
        }

        @Override
        public int compare(Object aObj, Object bObj) {
            if (aObj instanceof Byte && bObj instanceof Byte) {
                Byte a = (Byte)aObj;
                Byte b = (Byte)bObj;
                return a.compareTo(b);
            }
            return super.compare(aObj, bObj);
        }

        @Override
        public int getMemory(Object obj) {
            return obj instanceof Byte ? 0 : super.getMemory(obj);
        }

        @Override
        public void write(WriteBuffer buff, Object obj) {
            if (!(obj instanceof Byte)) {
                super.write(buff, obj);
                return;
            }
            buff.put((byte)2);
            buff.put((Byte)obj);
        }

        @Override
        public Object read(ByteBuffer buff, int tag) {
            return buff.get();
        }
    }

    static class BooleanType
    extends AutoDetectDataType {
        BooleanType(ObjectDataType base) {
            super(base, 1);
        }

        @Override
        public int compare(Object aObj, Object bObj) {
            if (aObj instanceof Boolean && bObj instanceof Boolean) {
                Boolean a = (Boolean)aObj;
                Boolean b = (Boolean)bObj;
                return a.compareTo(b);
            }
            return super.compare(aObj, bObj);
        }

        @Override
        public int getMemory(Object obj) {
            return obj instanceof Boolean ? 0 : super.getMemory(obj);
        }

        @Override
        public void write(WriteBuffer buff, Object obj) {
            if (!(obj instanceof Boolean)) {
                super.write(buff, obj);
                return;
            }
            int tag = (Boolean)obj != false ? 32 : 1;
            buff.put((byte)tag);
        }

        @Override
        public Object read(ByteBuffer buff, int tag) {
            return tag == 1 ? Boolean.FALSE : Boolean.TRUE;
        }
    }

    static class NullType
    extends AutoDetectDataType {
        NullType(ObjectDataType base) {
            super(base, 0);
        }

        @Override
        public int compare(Object aObj, Object bObj) {
            if (aObj == null && bObj == null) {
                return 0;
            }
            if (aObj == null) {
                return -1;
            }
            if (bObj == null) {
                return 1;
            }
            return super.compare(aObj, bObj);
        }

        @Override
        public int getMemory(Object obj) {
            return obj == null ? 0 : super.getMemory(obj);
        }

        @Override
        public void write(WriteBuffer buff, Object obj) {
            if (obj != null) {
                super.write(buff, obj);
                return;
            }
            buff.put((byte)0);
        }

        @Override
        public Object read(ByteBuffer buff, int tag) {
            return null;
        }
    }

    static abstract class AutoDetectDataType
    implements DataType {
        protected final ObjectDataType base;
        protected final int typeId;

        AutoDetectDataType(ObjectDataType base, int typeId) {
            this.base = base;
            this.typeId = typeId;
        }

        @Override
        public int getMemory(Object o) {
            return this.getType(o).getMemory(o);
        }

        @Override
        public int compare(Object aObj, Object bObj) {
            AutoDetectDataType aType = this.getType(aObj);
            AutoDetectDataType bType = this.getType(bObj);
            int typeDiff = aType.typeId - bType.typeId;
            if (typeDiff == 0) {
                return aType.compare(aObj, bObj);
            }
            return Integer.signum(typeDiff);
        }

        @Override
        public void write(WriteBuffer buff, Object[] obj, int len, boolean key) {
            for (int i = 0; i < len; ++i) {
                this.write(buff, obj[i]);
            }
        }

        @Override
        public void write(WriteBuffer buff, Object o) {
            this.getType(o).write(buff, o);
        }

        @Override
        public void read(ByteBuffer buff, Object[] obj, int len, boolean key) {
            for (int i = 0; i < len; ++i) {
                obj[i] = this.read(buff);
            }
        }

        @Override
        public final Object read(ByteBuffer buff) {
            throw DataUtils.newIllegalStateException(3, "Internal error", new Object[0]);
        }

        AutoDetectDataType getType(Object o) {
            return this.base.switchType(o);
        }

        abstract Object read(ByteBuffer var1, int var2);
    }
}

