/*
 * Decompiled with CFR 0.152.
 */
package org.h2.schema;

import java.math.BigInteger;
import org.h2.engine.Session;
import org.h2.message.DbException;
import org.h2.schema.Schema;
import org.h2.schema.SchemaObjectBase;
import org.h2.table.Table;

public class Sequence
extends SchemaObjectBase {
    public static final int DEFAULT_CACHE_SIZE = 32;
    private long value;
    private long valueWithMargin;
    private long increment;
    private long cacheSize;
    private long minValue;
    private long maxValue;
    private boolean cycle;
    private boolean belongsToTable;
    private Object flushSync = new Object();
    private boolean writeWithMargin;

    public Sequence(Schema schema, int id, String name, long startValue, long increment) {
        this(schema, id, name, startValue, increment, null, null, null, false, true);
    }

    public Sequence(Schema schema, int id, String name, Long startValue, Long increment, Long cacheSize, Long minValue, Long maxValue, boolean cycle, boolean belongsToTable) {
        this.initSchemaObjectBase(schema, id, name, 9);
        this.increment = increment != null ? increment : 1L;
        this.minValue = minValue != null ? minValue : Sequence.getDefaultMinValue(startValue, this.increment);
        this.maxValue = maxValue != null ? maxValue : Sequence.getDefaultMaxValue(startValue, this.increment);
        this.valueWithMargin = this.value = startValue != null ? startValue.longValue() : this.getDefaultStartValue(this.increment);
        this.cacheSize = cacheSize != null ? Math.max(1L, cacheSize) : 32L;
        this.cycle = cycle;
        this.belongsToTable = belongsToTable;
        if (!Sequence.isValid(this.value, this.minValue, this.maxValue, this.increment)) {
            throw DbException.get(90009, name, String.valueOf(this.value), String.valueOf(this.minValue), String.valueOf(this.maxValue), String.valueOf(this.increment));
        }
    }

    public synchronized void modify(Long startValue, Long minValue, Long maxValue, Long increment) {
        if (startValue == null) {
            startValue = this.value;
        }
        if (minValue == null) {
            minValue = this.minValue;
        }
        if (maxValue == null) {
            maxValue = this.maxValue;
        }
        if (increment == null) {
            increment = this.increment;
        }
        if (!Sequence.isValid(startValue, minValue, maxValue, increment)) {
            throw DbException.get(90009, this.getName(), String.valueOf(startValue), String.valueOf(minValue), String.valueOf(maxValue), String.valueOf(increment));
        }
        this.value = startValue;
        this.valueWithMargin = startValue;
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.increment = increment;
    }

    private static boolean isValid(long value, long minValue, long maxValue, long increment) {
        return minValue <= value && maxValue >= value && maxValue > minValue && increment != 0L && BigInteger.valueOf(increment).abs().compareTo(BigInteger.valueOf(maxValue).subtract(BigInteger.valueOf(minValue))) < 0;
    }

    private static long getDefaultMinValue(Long startValue, long increment) {
        long v;
        long l = v = increment >= 0L ? 1L : Long.MIN_VALUE;
        if (startValue != null && increment >= 0L && startValue < v) {
            v = startValue;
        }
        return v;
    }

    private static long getDefaultMaxValue(Long startValue, long increment) {
        long v;
        long l = v = increment >= 0L ? Long.MAX_VALUE : -1L;
        if (startValue != null && increment < 0L && startValue > v) {
            v = startValue;
        }
        return v;
    }

    private long getDefaultStartValue(long increment) {
        return increment >= 0L ? this.minValue : this.maxValue;
    }

    public boolean getBelongsToTable() {
        return this.belongsToTable;
    }

    public long getIncrement() {
        return this.increment;
    }

    public long getMinValue() {
        return this.minValue;
    }

    public long getMaxValue() {
        return this.maxValue;
    }

    public boolean getCycle() {
        return this.cycle;
    }

    public void setCycle(boolean cycle) {
        this.cycle = cycle;
    }

    @Override
    public String getDropSQL() {
        if (this.getBelongsToTable()) {
            return null;
        }
        return "DROP SEQUENCE IF EXISTS " + this.getSQL();
    }

    @Override
    public String getCreateSQLForCopy(Table table, String quotedName) {
        throw DbException.throwInternalError();
    }

    @Override
    public synchronized String getCreateSQL() {
        long v = this.writeWithMargin ? this.valueWithMargin : this.value;
        StringBuilder buff = new StringBuilder("CREATE SEQUENCE ");
        buff.append(this.getSQL()).append(" START WITH ").append(v);
        if (this.increment != 1L) {
            buff.append(" INCREMENT BY ").append(this.increment);
        }
        if (this.minValue != Sequence.getDefaultMinValue(v, this.increment)) {
            buff.append(" MINVALUE ").append(this.minValue);
        }
        if (this.maxValue != Sequence.getDefaultMaxValue(v, this.increment)) {
            buff.append(" MAXVALUE ").append(this.maxValue);
        }
        if (this.cycle) {
            buff.append(" CYCLE");
        }
        if (this.cacheSize != 32L) {
            buff.append(" CACHE ").append(this.cacheSize);
        }
        if (this.belongsToTable) {
            buff.append(" BELONGS_TO_TABLE");
        }
        return buff.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getNext(Session session) {
        long result;
        boolean needsFlush = false;
        Sequence sequence = this;
        synchronized (sequence) {
            if (this.increment > 0L && this.value >= this.valueWithMargin || this.increment < 0L && this.value <= this.valueWithMargin) {
                this.valueWithMargin += this.increment * this.cacheSize;
                needsFlush = true;
            }
            if (this.increment > 0L && this.value > this.maxValue || this.increment < 0L && this.value < this.minValue) {
                if (this.cycle) {
                    this.value = this.increment > 0L ? this.minValue : this.maxValue;
                    this.valueWithMargin = this.value + this.increment * this.cacheSize;
                    needsFlush = true;
                } else {
                    throw DbException.get(90006, this.getName());
                }
            }
            result = this.value;
            this.value += this.increment;
        }
        if (needsFlush) {
            this.flush(session);
        }
        return result;
    }

    public void flushWithoutMargin() {
        if (this.valueWithMargin != this.value) {
            this.valueWithMargin = this.value;
            this.flush(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush(Session session) {
        if (this.isTemporary()) {
            return;
        }
        if (session == null || !this.database.isSysTableLockedBy(session)) {
            Session sysSession;
            Session session2 = sysSession = this.database.getSystemSession();
            synchronized (session2) {
                Object object = this.flushSync;
                synchronized (object) {
                    this.flushInternal(sysSession);
                }
                sysSession.commit(false);
            }
        }
        Session session3 = session;
        synchronized (session3) {
            Object object = this.flushSync;
            synchronized (object) {
                this.flushInternal(session);
            }
        }
    }

    private void flushInternal(Session session) {
        boolean metaWasLocked = this.database.lockMeta(session);
        try {
            this.writeWithMargin = true;
            this.database.updateMeta(session, this);
        }
        finally {
            this.writeWithMargin = false;
        }
        if (!metaWasLocked) {
            this.database.unlockMeta(session);
        }
    }

    public void close() {
        this.flushWithoutMargin();
    }

    @Override
    public int getType() {
        return 3;
    }

    @Override
    public void removeChildrenAndResources(Session session) {
        this.database.removeMeta(session, this.getId());
        this.invalidate();
    }

    @Override
    public void checkRename() {
    }

    public synchronized long getCurrentValue() {
        return this.value - this.increment;
    }

    public void setBelongsToTable(boolean b) {
        this.belongsToTable = b;
    }

    public void setCacheSize(long cacheSize) {
        this.cacheSize = Math.max(1L, cacheSize);
    }

    public long getCacheSize() {
        return this.cacheSize;
    }
}

