/*
 * Decompiled with CFR 0.152.
 */
package org.h2.server.web;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import org.h2.bnf.Bnf;
import org.h2.bnf.context.DbColumn;
import org.h2.bnf.context.DbContents;
import org.h2.bnf.context.DbSchema;
import org.h2.bnf.context.DbTableOrView;
import org.h2.engine.Constants;
import org.h2.engine.SysProperties;
import org.h2.jdbc.JdbcSQLException;
import org.h2.message.DbException;
import org.h2.security.SHA256;
import org.h2.server.web.ConnectionInfo;
import org.h2.server.web.PageParser;
import org.h2.server.web.WebServer;
import org.h2.server.web.WebSession;
import org.h2.tools.Backup;
import org.h2.tools.ChangeFileEncryption;
import org.h2.tools.ConvertTraceFile;
import org.h2.tools.CreateCluster;
import org.h2.tools.DeleteDbFiles;
import org.h2.tools.Recover;
import org.h2.tools.Restore;
import org.h2.tools.RunScript;
import org.h2.tools.Script;
import org.h2.tools.SimpleResultSet;
import org.h2.util.JdbcUtils;
import org.h2.util.New;
import org.h2.util.Profiler;
import org.h2.util.ScriptReader;
import org.h2.util.SortedProperties;
import org.h2.util.StatementBuilder;
import org.h2.util.StringUtils;
import org.h2.util.Tool;
import org.h2.util.Utils;

public class WebApp {
    protected final WebServer server;
    protected WebSession session;
    protected Properties attributes;
    protected String mimeType;
    protected boolean cache;
    protected boolean stop;
    protected String headerLanguage;
    private Profiler profiler;

    WebApp(WebServer server) {
        this.server = server;
    }

    void setSession(WebSession session, Properties attributes) {
        this.session = session;
        this.attributes = attributes;
    }

    String processRequest(String file, String hostAddr) {
        int index = file.lastIndexOf(46);
        String suffix = index >= 0 ? file.substring(index + 1) : "";
        if ("ico".equals(suffix)) {
            this.mimeType = "image/x-icon";
            this.cache = true;
        } else if ("gif".equals(suffix)) {
            this.mimeType = "image/gif";
            this.cache = true;
        } else if ("css".equals(suffix)) {
            this.cache = true;
            this.mimeType = "text/css";
        } else if ("html".equals(suffix) || "do".equals(suffix) || "jsp".equals(suffix)) {
            this.cache = false;
            this.mimeType = "text/html";
            if (this.session == null) {
                this.session = this.server.createNewSession(hostAddr);
                if (!"notAllowed.jsp".equals(file)) {
                    file = "index.do";
                }
            }
        } else if ("js".equals(suffix)) {
            this.cache = true;
            this.mimeType = "text/javascript";
        } else {
            this.cache = true;
            this.mimeType = "application/octet-stream";
        }
        this.trace("mimeType=" + this.mimeType);
        this.trace(file);
        if (file.endsWith(".do")) {
            file = this.process(file);
        }
        return file;
    }

    private static String getComboBox(String[] elements, String selected) {
        StringBuilder buff = new StringBuilder();
        for (String value : elements) {
            buff.append("<option value=\"").append(PageParser.escapeHtmlData(value)).append('\"');
            if (value.equals(selected)) {
                buff.append(" selected");
            }
            buff.append('>').append(PageParser.escapeHtml(value)).append("</option>");
        }
        return buff.toString();
    }

    private static String getComboBox(String[][] elements, String selected) {
        StringBuilder buff = new StringBuilder();
        for (String[] n : elements) {
            buff.append("<option value=\"").append(PageParser.escapeHtmlData(n[0])).append('\"');
            if (n[0].equals(selected)) {
                buff.append(" selected");
            }
            buff.append('>').append(PageParser.escapeHtml(n[1])).append("</option>");
        }
        return buff.toString();
    }

    private String process(String file) {
        this.trace("process " + file);
        while (file.endsWith(".do")) {
            if ("login.do".equals(file)) {
                file = this.login();
                continue;
            }
            if ("index.do".equals(file)) {
                file = this.index();
                continue;
            }
            if ("logout.do".equals(file)) {
                file = this.logout();
                continue;
            }
            if ("settingRemove.do".equals(file)) {
                file = this.settingRemove();
                continue;
            }
            if ("settingSave.do".equals(file)) {
                file = this.settingSave();
                continue;
            }
            if ("test.do".equals(file)) {
                file = this.test();
                continue;
            }
            if ("query.do".equals(file)) {
                file = this.query();
                continue;
            }
            if ("tables.do".equals(file)) {
                file = this.tables();
                continue;
            }
            if ("editResult.do".equals(file)) {
                file = this.editResult();
                continue;
            }
            if ("getHistory.do".equals(file)) {
                file = this.getHistory();
                continue;
            }
            if ("admin.do".equals(file)) {
                file = this.admin();
                continue;
            }
            if ("adminSave.do".equals(file)) {
                file = this.adminSave();
                continue;
            }
            if ("adminStartTranslate.do".equals(file)) {
                file = this.adminStartTranslate();
                continue;
            }
            if ("adminShutdown.do".equals(file)) {
                file = this.adminShutdown();
                continue;
            }
            if ("autoCompleteList.do".equals(file)) {
                file = this.autoCompleteList();
                continue;
            }
            if ("tools.do".equals(file)) {
                file = this.tools();
                continue;
            }
            file = "error.jsp";
        }
        this.trace("return " + file);
        return file;
    }

    private String autoCompleteList() {
        String query = (String)this.attributes.get("query");
        boolean lowercase = false;
        if (query.trim().length() > 0 && Character.isLowerCase(query.trim().charAt(0))) {
            lowercase = true;
        }
        try {
            String n;
            String sql = query;
            if (sql.endsWith(";")) {
                sql = sql + " ";
            }
            ScriptReader reader = new ScriptReader(new StringReader(sql));
            reader.setSkipRemarks(true);
            String lastSql = "";
            while ((n = reader.readStatement()) != null) {
                lastSql = n;
            }
            String result = "";
            if (reader.isInsideRemark()) {
                result = reader.isBlockRemark() ? "1#(End Remark)# */\n" + result : "1#(Newline)#\n" + result;
            } else {
                char last;
                Bnf bnf;
                sql = lastSql;
                while (sql.length() > 0 && sql.charAt(0) <= ' ') {
                    sql = sql.substring(1);
                }
                if (sql.trim().length() > 0 && Character.isLowerCase(sql.trim().charAt(0))) {
                    lowercase = true;
                }
                if ((bnf = this.session.getBnf()) == null) {
                    return "autoCompleteList.jsp";
                }
                HashMap<String, String> map = bnf.getNextTokenList(sql);
                String space = "";
                if (sql.length() > 0 && !Character.isWhitespace(last = sql.charAt(sql.length() - 1)) && last != '.' && last >= ' ' && last != '\'' && last != '\"') {
                    space = " ";
                }
                ArrayList<String> list = New.arrayList(map.size());
                for (Map.Entry<String, String> entry : map.entrySet()) {
                    String key = entry.getKey();
                    String value = entry.getValue();
                    String type = "" + key.charAt(0);
                    if (Integer.parseInt(type) > 2) continue;
                    if (Character.isLetter((key = key.substring(2)).charAt(0)) && lowercase) {
                        key = StringUtils.toLowerEnglish(key);
                        value = StringUtils.toLowerEnglish(value);
                    }
                    if (key.equals(value) && !".".equals(value)) {
                        value = space + value;
                    }
                    key = StringUtils.urlEncode(key);
                    key = StringUtils.replaceAll(key, "+", " ");
                    value = StringUtils.urlEncode(value);
                    value = StringUtils.replaceAll(value, "+", " ");
                    list.add(type + "#" + key + "#" + value);
                }
                Collections.sort(list);
                if (query.endsWith("\n") || query.trim().endsWith(";")) {
                    list.add(0, "1#(Newline)#\n");
                }
                StatementBuilder buff = new StatementBuilder();
                for (String s : list) {
                    buff.appendExceptFirst("|");
                    buff.append(s);
                }
                result = buff.toString();
            }
            this.session.put("autoCompleteList", result);
        }
        catch (Throwable e) {
            this.server.traceError(e);
        }
        return "autoCompleteList.jsp";
    }

    private String admin() {
        this.session.put("port", "" + this.server.getPort());
        this.session.put("allowOthers", "" + this.server.getAllowOthers());
        this.session.put("ssl", String.valueOf(this.server.getSSL()));
        this.session.put("sessions", this.server.getSessions());
        return "admin.jsp";
    }

    private String adminSave() {
        try {
            SortedProperties prop = new SortedProperties();
            int port = Integer.decode((String)this.attributes.get("port"));
            prop.setProperty("webPort", String.valueOf(port));
            this.server.setPort(port);
            boolean allowOthers = Boolean.parseBoolean((String)this.attributes.get("allowOthers"));
            prop.setProperty("webAllowOthers", String.valueOf(allowOthers));
            this.server.setAllowOthers(allowOthers);
            boolean ssl = Boolean.parseBoolean((String)this.attributes.get("ssl"));
            prop.setProperty("webSSL", String.valueOf(ssl));
            this.server.setSSL(ssl);
            this.server.saveProperties(prop);
        }
        catch (Exception e) {
            this.trace(e.toString());
        }
        return this.admin();
    }

    private String tools() {
        try {
            String toolName = (String)this.attributes.get("tool");
            this.session.put("tool", toolName);
            String args = (String)this.attributes.get("args");
            String[] argList = StringUtils.arraySplit(args, ',', false);
            Tool tool = null;
            if ("Backup".equals(toolName)) {
                tool = new Backup();
            } else if ("Restore".equals(toolName)) {
                tool = new Restore();
            } else if ("Recover".equals(toolName)) {
                tool = new Recover();
            } else if ("DeleteDbFiles".equals(toolName)) {
                tool = new DeleteDbFiles();
            } else if ("ChangeFileEncryption".equals(toolName)) {
                tool = new ChangeFileEncryption();
            } else if ("Script".equals(toolName)) {
                tool = new Script();
            } else if ("RunScript".equals(toolName)) {
                tool = new RunScript();
            } else if ("ConvertTraceFile".equals(toolName)) {
                tool = new ConvertTraceFile();
            } else if ("CreateCluster".equals(toolName)) {
                tool = new CreateCluster();
            } else {
                throw DbException.throwInternalError(toolName);
            }
            ByteArrayOutputStream outBuff = new ByteArrayOutputStream();
            PrintStream out = new PrintStream((OutputStream)outBuff, false, "UTF-8");
            tool.setOut(out);
            try {
                tool.runTool(argList);
                out.flush();
                String o = new String(outBuff.toByteArray(), Constants.UTF8);
                String result = PageParser.escapeHtml(o);
                this.session.put("toolResult", result);
            }
            catch (Exception e) {
                this.session.put("toolResult", this.getStackTrace(0, e, true));
            }
        }
        catch (Exception e) {
            this.server.traceError(e);
        }
        return "tools.jsp";
    }

    private String adminStartTranslate() {
        Map p;
        Map p2 = p = (Map)Map.class.cast(this.session.map.get("text"));
        String file = this.server.startTranslate(p2);
        this.session.put("translationFile", file);
        return "helpTranslate.jsp";
    }

    protected String adminShutdown() {
        this.server.shutdown();
        return "admin.jsp";
    }

    private String index() {
        String[][] languageArray = WebServer.LANGUAGES;
        String language = (String)this.attributes.get("language");
        Locale locale = this.session.locale;
        if (language != null) {
            if (locale == null || !StringUtils.toLowerEnglish(locale.getLanguage()).equals(language)) {
                locale = new Locale(language, "");
                this.server.readTranslations(this.session, locale.getLanguage());
                this.session.put("language", language);
                this.session.locale = locale;
            }
        } else {
            language = (String)this.session.get("language");
        }
        if (language == null) {
            language = this.headerLanguage;
        }
        this.session.put("languageCombo", WebApp.getComboBox(languageArray, language));
        String[] settingNames = this.server.getSettingNames();
        String setting = this.attributes.getProperty("setting");
        if (setting == null && settingNames.length > 0) {
            setting = settingNames[0];
        }
        String combobox = WebApp.getComboBox(settingNames, setting);
        this.session.put("settingsList", combobox);
        ConnectionInfo info = this.server.getSetting(setting);
        if (info == null) {
            info = new ConnectionInfo();
        }
        this.session.put("setting", PageParser.escapeHtmlData(setting));
        this.session.put("name", PageParser.escapeHtmlData(setting));
        this.session.put("driver", PageParser.escapeHtmlData(info.driver));
        this.session.put("url", PageParser.escapeHtmlData(info.url));
        this.session.put("user", PageParser.escapeHtmlData(info.user));
        return "index.jsp";
    }

    private String getHistory() {
        int id = Integer.parseInt(this.attributes.getProperty("id"));
        String sql = this.session.getCommand(id);
        this.session.put("query", PageParser.escapeHtmlData(sql));
        return "query.jsp";
    }

    private static int addColumns(boolean mainSchema, DbTableOrView table, StringBuilder buff, int treeIndex, boolean showColumnTypes, StringBuilder columnsBuffer) {
        DbColumn[] columns = table.getColumns();
        for (int i = 0; columns != null && i < columns.length; ++i) {
            DbColumn column = columns[i];
            if (columnsBuffer.length() > 0) {
                columnsBuffer.append(' ');
            }
            columnsBuffer.append(column.getName());
            String col = WebApp.escapeIdentifier(column.getName());
            String level = mainSchema ? ", 1, 1" : ", 2, 2";
            buff.append("setNode(" + treeIndex + level + ", 'column', '" + PageParser.escapeJavaScript(column.getName()) + "', 'javascript:ins(\\'" + col + "\\')');\n");
            ++treeIndex;
            if (!mainSchema || !showColumnTypes) continue;
            buff.append("setNode(" + treeIndex + ", 2, 2, 'type', '" + PageParser.escapeJavaScript(column.getDataType()) + "', null);\n");
            ++treeIndex;
        }
        return treeIndex;
    }

    private static String escapeIdentifier(String name) {
        return StringUtils.urlEncode(PageParser.escapeJavaScript(name)).replace('+', ' ');
    }

    private static int addIndexes(boolean mainSchema, DatabaseMetaData meta, String table, String schema, StringBuilder buff, int treeIndex) throws SQLException {
        ResultSet rs;
        try {
            rs = meta.getIndexInfo(null, schema, table, false, true);
        }
        catch (SQLException e) {
            return treeIndex;
        }
        HashMap<String, IndexInfo> indexMap = New.hashMap();
        while (rs.next()) {
            String name = rs.getString("INDEX_NAME");
            IndexInfo info = (IndexInfo)indexMap.get(name);
            if (info == null) {
                int t = rs.getInt("TYPE");
                String type = t == 1 ? "" : (t == 2 ? " (${text.tree.hashed})" : (t == 3 ? "" : null));
                if (name == null || type == null) continue;
                info = new IndexInfo();
                info.name = name;
                info.type = type = (rs.getBoolean("NON_UNIQUE") ? "${text.tree.nonUnique}" : "${text.tree.unique}") + type;
                info.columns = rs.getString("COLUMN_NAME");
                indexMap.put(name, info);
                continue;
            }
            info.columns = info.columns + ", " + rs.getString("COLUMN_NAME");
        }
        rs.close();
        if (indexMap.size() > 0) {
            String level = mainSchema ? ", 1, 1" : ", 2, 1";
            String levelIndex = mainSchema ? ", 2, 1" : ", 3, 1";
            String levelColumnType = mainSchema ? ", 3, 2" : ", 4, 2";
            buff.append("setNode(" + treeIndex + level + ", 'index_az', '${text.tree.indexes}', null);\n");
            ++treeIndex;
            for (IndexInfo info : indexMap.values()) {
                buff.append("setNode(" + treeIndex + levelIndex + ", 'index', '" + PageParser.escapeJavaScript(info.name) + "', null);\n");
                buff.append("setNode(" + ++treeIndex + levelColumnType + ", 'type', '" + info.type + "', null);\n");
                buff.append("setNode(" + ++treeIndex + levelColumnType + ", 'type', '" + PageParser.escapeJavaScript(info.columns) + "', null);\n");
                ++treeIndex;
            }
        }
        return treeIndex;
    }

    private int addTablesAndViews(DbSchema schema, boolean mainSchema, StringBuilder buff, int treeIndex) throws SQLException {
        StringBuilder columnsBuffer;
        String tab;
        int tableId;
        if (schema == null) {
            return treeIndex;
        }
        Connection conn = this.session.getConnection();
        DatabaseMetaData meta = this.session.getMetaData();
        int level = mainSchema ? 0 : 1;
        boolean showColumns = mainSchema || !schema.isSystem;
        String indentation = ", " + level + ", " + (showColumns ? "1" : "2") + ", ";
        String indentNode = ", " + (level + 1) + ", 2, ";
        DbTableOrView[] tables = schema.getTables();
        if (tables == null) {
            return treeIndex;
        }
        boolean isOracle = schema.getContents().isOracle();
        boolean notManyTables = tables.length < SysProperties.CONSOLE_MAX_TABLES_LIST_INDEXES;
        for (DbTableOrView table : tables) {
            if (table.isView()) continue;
            tableId = treeIndex;
            tab = table.getQuotedName();
            if (!mainSchema) {
                tab = schema.quotedName + "." + tab;
            }
            tab = WebApp.escapeIdentifier(tab);
            buff.append("setNode(" + treeIndex + indentation + " 'table', '" + PageParser.escapeJavaScript(table.getName()) + "', 'javascript:ins(\\'" + tab + "\\',true)');\n");
            ++treeIndex;
            if (!mainSchema && !showColumns) continue;
            columnsBuffer = new StringBuilder();
            treeIndex = WebApp.addColumns(mainSchema, table, buff, treeIndex, notManyTables, columnsBuffer);
            if (!isOracle && notManyTables) {
                treeIndex = WebApp.addIndexes(mainSchema, meta, table.getName(), schema.name, buff, treeIndex);
            }
            buff.append("addTable('" + PageParser.escapeJavaScript(table.getName()) + "', '" + PageParser.escapeJavaScript(columnsBuffer.toString()) + "', " + tableId + ");\n");
        }
        for (DbTableOrView view : tables = schema.getTables()) {
            if (!view.isView()) continue;
            tableId = treeIndex;
            tab = view.getQuotedName();
            if (!mainSchema) {
                tab = view.getSchema().quotedName + "." + tab;
            }
            tab = WebApp.escapeIdentifier(tab);
            buff.append("setNode(" + treeIndex + indentation + " 'view', '" + PageParser.escapeJavaScript(view.getName()) + "', 'javascript:ins(\\'" + tab + "\\',true)');\n");
            ++treeIndex;
            if (!mainSchema) continue;
            columnsBuffer = new StringBuilder();
            treeIndex = WebApp.addColumns(mainSchema, view, buff, treeIndex, notManyTables, columnsBuffer);
            if (schema.getContents().isH2()) {
                try (PreparedStatement prep = conn.prepareStatement("SELECT * FROM INFORMATION_SCHEMA.TABLES WHERE TABLE_NAME=?");){
                    prep.setString(1, view.getName());
                    ResultSet rs = prep.executeQuery();
                    if (rs.next()) {
                        String sql = rs.getString("SQL");
                        buff.append("setNode(" + treeIndex + indentNode + " 'type', '" + PageParser.escapeJavaScript(sql) + "', null);\n");
                        ++treeIndex;
                    }
                    rs.close();
                }
            }
            buff.append("addTable('" + PageParser.escapeJavaScript(view.getName()) + "', '" + PageParser.escapeJavaScript(columnsBuffer.toString()) + "', " + tableId + ");\n");
        }
        return treeIndex;
    }

    private String tables() {
        DbContents contents = this.session.getContents();
        boolean isH2 = false;
        try {
            DbSchema[] schemas;
            String url = (String)this.session.get("url");
            Connection conn = this.session.getConnection();
            contents.readContents(url, conn);
            this.session.loadBnf();
            isH2 = contents.isH2();
            StringBuilder buff = new StringBuilder();
            buff.append("setNode(0, 0, 0, 'database', '" + PageParser.escapeJavaScript(url) + "', null);\n");
            int treeIndex = 1;
            DbSchema defaultSchema = contents.getDefaultSchema();
            treeIndex = this.addTablesAndViews(defaultSchema, true, buff, treeIndex);
            for (DbSchema schema : schemas = contents.getSchemas()) {
                if (schema == defaultSchema || schema == null) continue;
                buff.append("setNode(" + treeIndex + ", 0, 1, 'folder', '" + PageParser.escapeJavaScript(schema.name) + "', null);\n");
                ++treeIndex;
                treeIndex = this.addTablesAndViews(schema, false, buff, treeIndex);
            }
            if (isH2) {
                try (Statement stat = conn.createStatement();){
                    String name;
                    ResultSet rs = stat.executeQuery("SELECT * FROM INFORMATION_SCHEMA.SEQUENCES ORDER BY SEQUENCE_NAME");
                    int i = 0;
                    while (rs.next()) {
                        if (i == 0) {
                            buff.append("setNode(" + treeIndex + ", 0, 1, 'sequences', '${text.tree.sequences}', null);\n");
                            ++treeIndex;
                        }
                        name = rs.getString("SEQUENCE_NAME");
                        String current = rs.getString("CURRENT_VALUE");
                        String increment = rs.getString("INCREMENT");
                        buff.append("setNode(" + treeIndex + ", 1, 1, 'sequence', '" + PageParser.escapeJavaScript(name) + "', null);\n");
                        buff.append("setNode(" + ++treeIndex + ", 2, 2, 'type', '${text.tree.current}: " + PageParser.escapeJavaScript(current) + "', null);\n");
                        ++treeIndex;
                        if (!"1".equals(increment)) {
                            buff.append("setNode(" + treeIndex + ", 2, 2, 'type', '${text.tree.increment}: " + PageParser.escapeJavaScript(increment) + "', null);\n");
                            ++treeIndex;
                        }
                        ++i;
                    }
                    rs.close();
                    rs = stat.executeQuery("SELECT * FROM INFORMATION_SCHEMA.USERS ORDER BY NAME");
                    i = 0;
                    while (rs.next()) {
                        if (i == 0) {
                            buff.append("setNode(" + treeIndex + ", 0, 1, 'users', '${text.tree.users}', null);\n");
                            ++treeIndex;
                        }
                        name = rs.getString("NAME");
                        String admin = rs.getString("ADMIN");
                        buff.append("setNode(" + treeIndex + ", 1, 1, 'user', '" + PageParser.escapeJavaScript(name) + "', null);\n");
                        ++treeIndex;
                        if (admin.equalsIgnoreCase("TRUE")) {
                            buff.append("setNode(" + treeIndex + ", 2, 2, 'type', '${text.tree.admin}', null);\n");
                            ++treeIndex;
                        }
                        ++i;
                    }
                    rs.close();
                }
            }
            DatabaseMetaData meta = this.session.getMetaData();
            String version = meta.getDatabaseProductName() + " " + meta.getDatabaseProductVersion();
            buff.append("setNode(" + treeIndex + ", 0, 0, 'info', '" + PageParser.escapeJavaScript(version) + "', null);\n");
            buff.append("refreshQueryTables();");
            this.session.put("tree", buff.toString());
        }
        catch (Exception e) {
            this.session.put("tree", "");
            this.session.put("error", this.getStackTrace(0, e, isH2));
        }
        return "tables.jsp";
    }

    private String getStackTrace(int id, Throwable e, boolean isH2) {
        try {
            StringWriter writer = new StringWriter();
            e.printStackTrace(new PrintWriter(writer));
            String stackTrace = writer.toString();
            stackTrace = PageParser.escapeHtml(stackTrace);
            if (isH2) {
                stackTrace = WebApp.linkToSource(stackTrace);
            }
            stackTrace = StringUtils.replaceAll(stackTrace, "\t", "&nbsp;&nbsp;&nbsp;&nbsp;");
            String message = PageParser.escapeHtml(e.getMessage());
            String error = "<a class=\"error\" href=\"#\" onclick=\"var x=document.getElementById('st" + id + "').style;x.display=x.display==''?'none':'';\">" + message + "</a>";
            if (e instanceof SQLException) {
                SQLException se = (SQLException)e;
                error = error + " " + se.getSQLState() + "/" + se.getErrorCode();
                if (isH2) {
                    int code = se.getErrorCode();
                    error = error + " <a href=\"http://h2database.com/javadoc/org/h2/api/ErrorCode.html#c" + code + "\">(${text.a.help})</a>";
                }
            }
            error = error + "<span style=\"display: none;\" id=\"st" + id + "\"><br />" + stackTrace + "</span>";
            error = WebApp.formatAsError(error);
            return error;
        }
        catch (OutOfMemoryError e2) {
            this.server.traceError(e);
            return e.toString();
        }
    }

    private static String linkToSource(String s) {
        try {
            StringBuilder result = new StringBuilder(s.length());
            int idx = s.indexOf("<br />");
            result.append(s.substring(0, idx));
            while (true) {
                int start;
                if ((start = s.indexOf("org.h2.", idx)) < 0) {
                    result.append(s.substring(idx));
                    break;
                }
                result.append(s.substring(idx, start));
                int end = s.indexOf(41, start);
                if (end < 0) {
                    result.append(s.substring(idx));
                    break;
                }
                String element = s.substring(start, end);
                int open = element.lastIndexOf(40);
                int dotMethod = element.lastIndexOf(46, open - 1);
                int dotClass = element.lastIndexOf(46, dotMethod - 1);
                String packageName = element.substring(0, dotClass);
                int colon = element.lastIndexOf(58);
                String file = element.substring(open + 1, colon);
                String lineNumber = element.substring(colon + 1, element.length());
                String fullFileName = packageName.replace('.', '/') + "/" + file;
                result.append("<a href=\"http://h2database.com/html/source.html?file=");
                result.append(fullFileName);
                result.append("&line=");
                result.append(lineNumber);
                result.append("&build=");
                result.append(193);
                result.append("\">");
                result.append(element);
                result.append("</a>");
                idx = end;
            }
            return result.toString();
        }
        catch (Throwable t) {
            return s;
        }
    }

    private static String formatAsError(String s) {
        return "<div class=\"error\">" + s + "</div>";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String test() {
        String driver = this.attributes.getProperty("driver", "");
        String url = this.attributes.getProperty("url", "");
        String user = this.attributes.getProperty("user", "");
        String password = this.attributes.getProperty("password", "");
        this.session.put("driver", driver);
        this.session.put("url", url);
        this.session.put("user", user);
        boolean isH2 = url.startsWith("jdbc:h2:");
        try {
            Connection conn;
            long start = System.currentTimeMillis();
            String profOpen = "";
            String profClose = "";
            Profiler prof = new Profiler();
            prof.startCollecting();
            try {
                conn = this.server.getConnection(driver, url, user, password);
            }
            finally {
                prof.stopCollecting();
                profOpen = prof.getTop(3);
            }
            prof = new Profiler();
            prof.startCollecting();
            try {
                JdbcUtils.closeSilently(conn);
            }
            finally {
                prof.stopCollecting();
                profClose = prof.getTop(3);
            }
            long time = System.currentTimeMillis() - start;
            String success = time > 1000L ? "<a class=\"error\" href=\"#\" onclick=\"var x=document.getElementById('prof').style;x.display=x.display==''?'none':'';\">${text.login.testSuccessful}</a><span style=\"display: none;\" id=\"prof\"><br />" + PageParser.escapeHtml(profOpen) + "<br />" + PageParser.escapeHtml(profClose) + "</span>" : "${text.login.testSuccessful}";
            this.session.put("error", success);
            return "login.jsp";
        }
        catch (Exception e) {
            this.session.put("error", this.getLoginError(e, isH2));
            return "login.jsp";
        }
    }

    private String getLoginError(Exception e, boolean isH2) {
        if (e instanceof JdbcSQLException && ((JdbcSQLException)e).getErrorCode() == 90086) {
            return "${text.login.driverNotFound}<br />" + this.getStackTrace(0, e, isH2);
        }
        return this.getStackTrace(0, e, isH2);
    }

    private String login() {
        String driver = this.attributes.getProperty("driver", "");
        String url = this.attributes.getProperty("url", "");
        String user = this.attributes.getProperty("user", "");
        String password = this.attributes.getProperty("password", "");
        this.session.put("autoCommit", "checked");
        this.session.put("autoComplete", "1");
        this.session.put("maxrows", "1000");
        boolean isH2 = url.startsWith("jdbc:h2:");
        try {
            Connection conn = this.server.getConnection(driver, url, user, password);
            this.session.setConnection(conn);
            this.session.put("url", url);
            this.session.put("user", user);
            this.session.remove("error");
            this.settingSave();
            return "frame.jsp";
        }
        catch (Exception e) {
            this.session.put("error", this.getLoginError(e, isH2));
            return "login.jsp";
        }
    }

    private String logout() {
        try {
            Connection conn = this.session.getConnection();
            this.session.setConnection(null);
            this.session.remove("conn");
            this.session.remove("result");
            this.session.remove("tables");
            this.session.remove("user");
            this.session.remove("tool");
            if (conn != null) {
                if (this.session.getShutdownServerOnDisconnect()) {
                    this.server.shutdown();
                } else {
                    conn.close();
                }
            }
        }
        catch (Exception e) {
            this.trace(e.toString());
        }
        return "index.do";
    }

    private String query() {
        String sql = this.attributes.getProperty("sql").trim();
        try {
            String s;
            ScriptReader r = new ScriptReader(new StringReader(sql));
            final ArrayList list = New.arrayList();
            while ((s = r.readStatement()) != null) {
                list.add(s);
            }
            final Connection conn = this.session.getConnection();
            if (SysProperties.CONSOLE_STREAM && this.server.getAllowChunked()) {
                String page = new String(this.server.getFile("result.jsp"), Constants.UTF8);
                int idx = page.indexOf("${result}");
                list.add(0, page.substring(0, idx));
                list.add(page.substring(idx + "${result}".length()));
                this.session.put("chunks", new Iterator<String>(){
                    private int i;

                    @Override
                    public boolean hasNext() {
                        return this.i < list.size();
                    }

                    @Override
                    public String next() {
                        String s = (String)list.get(this.i++);
                        if (this.i == 1 || this.i == list.size()) {
                            return s;
                        }
                        StringBuilder b = new StringBuilder();
                        WebApp.this.query(conn, s, this.i - 1, list.size() - 2, b);
                        return b.toString();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                });
                return "result.jsp";
            }
            StringBuilder buff = new StringBuilder();
            for (int i = 0; i < list.size(); ++i) {
                String s2 = (String)list.get(i);
                this.query(conn, s2, i, list.size(), buff);
            }
            String result = buff.toString();
            this.session.put("result", result);
        }
        catch (Throwable e) {
            this.session.put("result", this.getStackTrace(0, e, this.session.getContents().isH2()));
        }
        return "result.jsp";
    }

    void query(Connection conn, String s, int i, int size, StringBuilder buff) {
        if (!s.startsWith("@") || !s.endsWith(".")) {
            buff.append(PageParser.escapeHtml(s + ";")).append("<br />");
        }
        boolean forceEdit = s.startsWith("@edit");
        buff.append(this.getResult(conn, i + 1, s, size == 1, forceEdit)).append("<br />");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String editResult() {
        String error;
        String result;
        block11: {
            ResultSet rs = this.session.result;
            int row = Integer.parseInt(this.attributes.getProperty("row"));
            int op = Integer.parseInt(this.attributes.getProperty("op"));
            result = "";
            error = "";
            try {
                if (op == 1) {
                    boolean insert;
                    boolean bl = insert = row < 0;
                    if (insert) {
                        rs.moveToInsertRow();
                    } else {
                        rs.absolute(row);
                    }
                    for (int i = 0; i < rs.getMetaData().getColumnCount(); ++i) {
                        String x = this.attributes.getProperty("r" + row + "c" + (i + 1));
                        this.unescapeData(x, rs, i + 1);
                    }
                    if (insert) {
                        rs.insertRow();
                        break block11;
                    } else {
                        rs.updateRow();
                    }
                    break block11;
                }
                if (op == 2) {
                    rs.absolute(row);
                    rs.deleteRow();
                } else if (op != 3) {
                    // empty if block
                }
            }
            catch (Throwable e) {
                result = "<br />" + this.getStackTrace(0, e, this.session.getContents().isH2());
                error = WebApp.formatAsError(e.getMessage());
            }
        }
        String sql = "@edit " + (String)this.session.get("resultSetSQL");
        Connection conn = this.session.getConnection();
        result = error + this.getResult(conn, -1, sql, true, true) + result;
        this.session.put("result", result);
        return "result.jsp";
    }

    private ResultSet getMetaResultSet(Connection conn, String sql) throws SQLException {
        DatabaseMetaData meta = conn.getMetaData();
        if (WebApp.isBuiltIn(sql, "@best_row_identifier")) {
            String[] p = WebApp.split(sql);
            int scale = p[4] == null ? 0 : Integer.parseInt(p[4]);
            boolean nullable = p[5] == null ? false : Boolean.parseBoolean(p[5]);
            return meta.getBestRowIdentifier(p[1], p[2], p[3], scale, nullable);
        }
        if (WebApp.isBuiltIn(sql, "@catalogs")) {
            return meta.getCatalogs();
        }
        if (WebApp.isBuiltIn(sql, "@columns")) {
            String[] p = WebApp.split(sql);
            return meta.getColumns(p[1], p[2], p[3], p[4]);
        }
        if (WebApp.isBuiltIn(sql, "@column_privileges")) {
            String[] p = WebApp.split(sql);
            return meta.getColumnPrivileges(p[1], p[2], p[3], p[4]);
        }
        if (WebApp.isBuiltIn(sql, "@cross_references")) {
            String[] p = WebApp.split(sql);
            return meta.getCrossReference(p[1], p[2], p[3], p[4], p[5], p[6]);
        }
        if (WebApp.isBuiltIn(sql, "@exported_keys")) {
            String[] p = WebApp.split(sql);
            return meta.getExportedKeys(p[1], p[2], p[3]);
        }
        if (WebApp.isBuiltIn(sql, "@imported_keys")) {
            String[] p = WebApp.split(sql);
            return meta.getImportedKeys(p[1], p[2], p[3]);
        }
        if (WebApp.isBuiltIn(sql, "@index_info")) {
            String[] p = WebApp.split(sql);
            boolean unique = p[4] == null ? false : Boolean.parseBoolean(p[4]);
            boolean approx = p[5] == null ? false : Boolean.parseBoolean(p[5]);
            return meta.getIndexInfo(p[1], p[2], p[3], unique, approx);
        }
        if (WebApp.isBuiltIn(sql, "@primary_keys")) {
            String[] p = WebApp.split(sql);
            return meta.getPrimaryKeys(p[1], p[2], p[3]);
        }
        if (WebApp.isBuiltIn(sql, "@procedures")) {
            String[] p = WebApp.split(sql);
            return meta.getProcedures(p[1], p[2], p[3]);
        }
        if (WebApp.isBuiltIn(sql, "@procedure_columns")) {
            String[] p = WebApp.split(sql);
            return meta.getProcedureColumns(p[1], p[2], p[3], p[4]);
        }
        if (WebApp.isBuiltIn(sql, "@schemas")) {
            return meta.getSchemas();
        }
        if (WebApp.isBuiltIn(sql, "@tables")) {
            String[] p = WebApp.split(sql);
            String[] types = p[4] == null ? null : StringUtils.arraySplit(p[4], ',', false);
            return meta.getTables(p[1], p[2], p[3], types);
        }
        if (WebApp.isBuiltIn(sql, "@table_privileges")) {
            String[] p = WebApp.split(sql);
            return meta.getTablePrivileges(p[1], p[2], p[3]);
        }
        if (WebApp.isBuiltIn(sql, "@table_types")) {
            return meta.getTableTypes();
        }
        if (WebApp.isBuiltIn(sql, "@type_info")) {
            return meta.getTypeInfo();
        }
        if (WebApp.isBuiltIn(sql, "@udts")) {
            int[] types;
            String[] p = WebApp.split(sql);
            if (p[4] == null) {
                types = null;
            } else {
                String[] t = StringUtils.arraySplit(p[4], ',', false);
                types = new int[t.length];
                for (int i = 0; i < t.length; ++i) {
                    types[i] = Integer.parseInt(t[i]);
                }
            }
            return meta.getUDTs(p[1], p[2], p[3], types);
        }
        if (WebApp.isBuiltIn(sql, "@version_columns")) {
            String[] p = WebApp.split(sql);
            return meta.getVersionColumns(p[1], p[2], p[3]);
        }
        if (WebApp.isBuiltIn(sql, "@memory")) {
            SimpleResultSet rs = new SimpleResultSet();
            rs.addColumn("Type", 12, 0, 0);
            rs.addColumn("KB", 12, 0, 0);
            rs.addRow("Used Memory", "" + Utils.getMemoryUsed());
            rs.addRow("Free Memory", "" + Utils.getMemoryFree());
            return rs;
        }
        if (WebApp.isBuiltIn(sql, "@info")) {
            String map;
            SimpleResultSet rs = new SimpleResultSet();
            rs.addColumn("KEY", 12, 0, 0);
            rs.addColumn("VALUE", 12, 0, 0);
            rs.addRow("conn.getCatalog", conn.getCatalog());
            rs.addRow("conn.getAutoCommit", "" + conn.getAutoCommit());
            rs.addRow("conn.getTransactionIsolation", "" + conn.getTransactionIsolation());
            rs.addRow("conn.getWarnings", "" + conn.getWarnings());
            try {
                map = "" + conn.getTypeMap();
            }
            catch (SQLException e) {
                map = e.toString();
            }
            rs.addRow("conn.getTypeMap", "" + map);
            rs.addRow("conn.isReadOnly", "" + conn.isReadOnly());
            rs.addRow("conn.getHoldability", "" + conn.getHoldability());
            WebApp.addDatabaseMetaData(rs, meta);
            return rs;
        }
        if (WebApp.isBuiltIn(sql, "@attributes")) {
            String[] p = WebApp.split(sql);
            return meta.getAttributes(p[1], p[2], p[3], p[4]);
        }
        if (WebApp.isBuiltIn(sql, "@super_tables")) {
            String[] p = WebApp.split(sql);
            return meta.getSuperTables(p[1], p[2], p[3]);
        }
        if (WebApp.isBuiltIn(sql, "@super_types")) {
            String[] p = WebApp.split(sql);
            return meta.getSuperTypes(p[1], p[2], p[3]);
        }
        if (WebApp.isBuiltIn(sql, "@prof_stop") && this.profiler != null) {
            this.profiler.stopCollecting();
            SimpleResultSet rs = new SimpleResultSet();
            rs.addColumn("Top Stack Trace(s)", 12, 0, 0);
            rs.addRow(this.profiler.getTop(3));
            this.profiler = null;
            return rs;
        }
        return null;
    }

    private static void addDatabaseMetaData(SimpleResultSet rs, DatabaseMetaData meta) {
        Method[] methods = DatabaseMetaData.class.getDeclaredMethods();
        Arrays.sort(methods, new Comparator<Method>(){

            @Override
            public int compare(Method o1, Method o2) {
                return o1.toString().compareTo(o2.toString());
            }
        });
        for (Method m : methods) {
            if (m.getParameterTypes().length != 0) continue;
            try {
                Object o = m.invoke((Object)meta, new Object[0]);
                rs.addRow("meta." + m.getName(), "" + o);
            }
            catch (InvocationTargetException e) {
                rs.addRow("meta." + m.getName(), e.getTargetException().toString());
            }
            catch (Exception e) {
                rs.addRow("meta." + m.getName(), e.toString());
            }
        }
    }

    private static String[] split(String s) {
        String[] list = new String[10];
        String[] t = StringUtils.arraySplit(s, ' ', true);
        System.arraycopy(t, 0, list, 0, t.length);
        for (int i = 0; i < list.length; ++i) {
            if (!"null".equals(list[i])) continue;
            list[i] = null;
        }
        return list;
    }

    private int getMaxrows() {
        String r = (String)this.session.get("maxrows");
        int maxrows = r == null ? 0 : Integer.parseInt(r);
        return maxrows;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getResult(Connection conn, int id, String sql, boolean allowEdit, boolean forceEdit) {
        try {
            ResultSet rs;
            String s;
            sql = sql.trim();
            StringBuilder buff = new StringBuilder();
            String sqlUpper = StringUtils.toUpperEnglish(sql);
            if (sqlUpper.contains("CREATE") || sqlUpper.contains("DROP") || sqlUpper.contains("ALTER") || sqlUpper.contains("RUNSCRIPT")) {
                String sessionId = this.attributes.getProperty("jsessionid");
                buff.append("<script type=\"text/javascript\">parent['h2menu'].location='tables.do?jsessionid=" + sessionId + "';</script>");
            }
            DbContents contents = this.session.getContents();
            Statement stat = forceEdit || allowEdit && contents.isH2() ? conn.createStatement(1004, 1008) : conn.createStatement();
            long time = System.currentTimeMillis();
            boolean metadata = false;
            boolean generatedKeys = false;
            boolean edit = false;
            boolean list = false;
            if (WebApp.isBuiltIn(sql, "@autocommit_true")) {
                conn.setAutoCommit(true);
                String string = "${text.result.autoCommitOn}";
                return string;
            }
            if (WebApp.isBuiltIn(sql, "@autocommit_false")) {
                conn.setAutoCommit(false);
                String string = "${text.result.autoCommitOff}";
                return string;
            }
            if (WebApp.isBuiltIn(sql, "@cancel")) {
                stat = this.session.executingStatement;
                if (stat != null) {
                    stat.cancel();
                    buff.append("${text.result.statementWasCanceled}");
                } else {
                    buff.append("${text.result.noRunningStatement}");
                }
                String string = buff.toString();
                return string;
            }
            if (WebApp.isBuiltIn(sql, "@edit")) {
                edit = true;
                sql = sql.substring("@edit".length()).trim();
                this.session.put("resultSetSQL", sql);
            }
            if (WebApp.isBuiltIn(sql, "@list")) {
                list = true;
                sql = sql.substring("@list".length()).trim();
            }
            if (WebApp.isBuiltIn(sql, "@meta")) {
                metadata = true;
                sql = sql.substring("@meta".length()).trim();
            }
            if (WebApp.isBuiltIn(sql, "@generated")) {
                generatedKeys = true;
                sql = sql.substring("@generated".length()).trim();
            } else {
                if (WebApp.isBuiltIn(sql, "@history")) {
                    buff.append(this.getCommandHistoryString());
                    String string = buff.toString();
                    return string;
                }
                if (WebApp.isBuiltIn(sql, "@loop")) {
                    sql = sql.substring("@loop".length()).trim();
                    int idx = sql.indexOf(32);
                    int count = Integer.decode(sql.substring(0, idx));
                    sql = sql.substring(idx).trim();
                    String string = this.executeLoop(conn, count, sql);
                    return string;
                }
                if (WebApp.isBuiltIn(sql, "@maxrows")) {
                    int maxrows = (int)Double.parseDouble(sql.substring("@maxrows".length()).trim());
                    this.session.put("maxrows", "" + maxrows);
                    String count = "${text.result.maxrowsSet}";
                    return count;
                }
                if (WebApp.isBuiltIn(sql, "@parameter_meta")) {
                    sql = sql.substring("@parameter_meta".length()).trim();
                    PreparedStatement prep = conn.prepareStatement(sql);
                    buff.append(WebApp.getParameterResultSet(prep.getParameterMetaData()));
                    String count = buff.toString();
                    return count;
                }
                if (WebApp.isBuiltIn(sql, "@password_hash")) {
                    sql = sql.substring("@password_hash".length()).trim();
                    String[] p = WebApp.split(sql);
                    String count = StringUtils.convertBytesToHex(SHA256.getKeyPasswordHash(p[0], p[1].toCharArray()));
                    return count;
                }
                if (WebApp.isBuiltIn(sql, "@prof_start")) {
                    if (this.profiler != null) {
                        this.profiler.stopCollecting();
                    }
                    this.profiler = new Profiler();
                    this.profiler.startCollecting();
                    String p = "Ok";
                    return p;
                }
                if (WebApp.isBuiltIn(sql, "@sleep")) {
                    String s2 = sql.substring("@sleep".length()).trim();
                    int sleep = 1;
                    if (s2.length() > 0) {
                        sleep = Integer.parseInt(s2);
                    }
                    Thread.sleep(sleep * 1000);
                    String string = "Ok";
                    return string;
                }
                if (WebApp.isBuiltIn(sql, "@transaction_isolation")) {
                    s = sql.substring("@transaction_isolation".length()).trim();
                    if (s.length() > 0) {
                        int level = Integer.parseInt(s);
                        conn.setTransactionIsolation(level);
                    }
                    buff.append("Transaction Isolation: " + conn.getTransactionIsolation() + "<br />");
                    buff.append("1: read_uncommitted<br />");
                    buff.append("2: read_committed<br />");
                    buff.append("4: repeatable_read<br />");
                    buff.append("8: serializable");
                }
            }
            if (sql.startsWith("@")) {
                rs = this.getMetaResultSet(conn, sql);
                if (rs == null) {
                    buff.append("?: " + sql);
                    s = buff.toString();
                    return s;
                }
            } else {
                int maxrows = this.getMaxrows();
                stat.setMaxRows(maxrows);
                this.session.executingStatement = stat;
                boolean isResultSet = stat.execute(sql);
                this.session.addCommand(sql);
                if (generatedKeys) {
                    rs = null;
                    rs = stat.getGeneratedKeys();
                } else {
                    if (!isResultSet) {
                        buff.append("${text.result.updateCount}: " + stat.getUpdateCount());
                        time = System.currentTimeMillis() - time;
                        buff.append("<br />(").append(time).append(" ms)");
                        stat.close();
                        String string = buff.toString();
                        return string;
                    }
                    rs = stat.getResultSet();
                }
            }
            time = System.currentTimeMillis() - time;
            buff.append(this.getResultSet(sql, rs, metadata, list, edit, time, allowEdit));
            if (!edit) {
                stat.close();
            }
            String string = buff.toString();
            return string;
        }
        catch (Throwable e) {
            String string = this.getStackTrace(id, e, this.session.getContents().isH2());
            return string;
        }
        finally {
            this.session.executingStatement = null;
        }
    }

    private static boolean isBuiltIn(String sql, String builtIn) {
        return StringUtils.startsWithIgnoreCase(sql, builtIn);
    }

    private String executeLoop(Connection conn, int count, String sql) throws SQLException {
        int i;
        boolean prepared;
        ArrayList<Integer> params = New.arrayList();
        int idx = 0;
        while (!this.stop && (idx = sql.indexOf(63, idx)) >= 0) {
            if (WebApp.isBuiltIn(sql.substring(idx), "?/*rnd*/")) {
                params.add(1);
                sql = sql.substring(0, idx) + "?" + sql.substring(idx + "/*rnd*/".length() + 1);
            } else {
                params.add(0);
            }
            ++idx;
        }
        Random random = new Random(1L);
        long time = System.currentTimeMillis();
        if (WebApp.isBuiltIn(sql, "@statement")) {
            sql = sql.substring("@statement".length()).trim();
            prepared = false;
            Statement stat = conn.createStatement();
            for (i = 0; !this.stop && i < count; ++i) {
                String s = sql;
                for (Integer type : params) {
                    idx = s.indexOf(63);
                    if (type == 1) {
                        s = s.substring(0, idx) + random.nextInt(count) + s.substring(idx + 1);
                        continue;
                    }
                    s = s.substring(0, idx) + i + s.substring(idx + 1);
                }
                if (!stat.execute(s)) continue;
                ResultSet rs = stat.getResultSet();
                while (!this.stop && rs.next()) {
                }
                rs.close();
            }
        } else {
            prepared = true;
            PreparedStatement prep = conn.prepareStatement(sql);
            for (i = 0; !this.stop && i < count; ++i) {
                for (int j = 0; j < params.size(); ++j) {
                    Integer type = params.get(j);
                    if (type == 1) {
                        prep.setInt(j + 1, random.nextInt(count));
                        continue;
                    }
                    prep.setInt(j + 1, i);
                }
                if (this.session.getContents().isSQLite()) {
                    prep.executeUpdate();
                    continue;
                }
                if (!prep.execute()) continue;
                ResultSet rs = prep.getResultSet();
                while (!this.stop && rs.next()) {
                }
                rs.close();
            }
        }
        time = System.currentTimeMillis() - time;
        StatementBuilder buff = new StatementBuilder();
        buff.append(time).append(" ms: ").append(count).append(" * ");
        if (prepared) {
            buff.append("(Prepared) ");
        } else {
            buff.append("(Statement) ");
        }
        buff.append('(');
        for (int p : params) {
            buff.appendExceptFirst(", ");
            buff.append(p == 0 ? "i" : "rnd");
        }
        return buff.append(") ").append(sql).toString();
    }

    private String getCommandHistoryString() {
        StringBuilder buff = new StringBuilder();
        ArrayList<String> history = this.session.getCommandHistory();
        buff.append("<table cellspacing=0 cellpadding=0><tr><th></th><th>Command</th></tr>");
        for (int i = history.size() - 1; i >= 0; --i) {
            String sql = history.get(i);
            buff.append("<tr><td><a href=\"getHistory.do?id=").append(i).append("&jsessionid=${sessionId}\" target=\"h2query\" >").append("<img width=16 height=16 src=\"ico_write.gif\" onmouseover = \"this.className ='icon_hover'\" ").append("onmouseout = \"this.className ='icon'\" class=\"icon\" alt=\"${text.resultEdit.edit}\" ").append("title=\"${text.resultEdit.edit}\" border=\"1\"/></a>").append("</td><td>").append(PageParser.escapeHtml(sql)).append("</td></tr>");
        }
        buff.append("</table>");
        return buff.toString();
    }

    private static String getParameterResultSet(ParameterMetaData meta) throws SQLException {
        StringBuilder buff = new StringBuilder();
        if (meta == null) {
            return "No parameter meta data";
        }
        buff.append("<table cellspacing=0 cellpadding=0>").append("<tr><th>className</th><th>mode</th><th>type</th>").append("<th>typeName</th><th>precision</th><th>scale</th></tr>");
        for (int i = 0; i < meta.getParameterCount(); ++i) {
            buff.append("</tr><td>").append(meta.getParameterClassName(i + 1)).append("</td><td>").append(meta.getParameterMode(i + 1)).append("</td><td>").append(meta.getParameterType(i + 1)).append("</td><td>").append(meta.getParameterTypeName(i + 1)).append("</td><td>").append(meta.getPrecision(i + 1)).append("</td><td>").append(meta.getScale(i + 1)).append("</td></tr>");
        }
        buff.append("</table>");
        return buff.toString();
    }

    private String getResultSet(String sql, ResultSet rs, boolean metadata, boolean list, boolean edit, long time, boolean allowEdit) throws SQLException {
        int i;
        int maxrows = this.getMaxrows();
        time = System.currentTimeMillis() - time;
        StringBuilder buff = new StringBuilder();
        if (edit) {
            buff.append("<form id=\"editing\" name=\"editing\" method=\"post\" action=\"editResult.do?jsessionid=${sessionId}\" id=\"mainForm\" target=\"h2result\"><input type=\"hidden\" name=\"op\" value=\"1\" /><input type=\"hidden\" name=\"row\" value=\"\" /><table cellspacing=0 cellpadding=0 id=\"editTable\">");
        } else {
            buff.append("<table cellspacing=0 cellpadding=0>");
        }
        if (metadata) {
            SimpleResultSet r = new SimpleResultSet();
            r.addColumn("#", 4, 0, 0);
            r.addColumn("label", 12, 0, 0);
            r.addColumn("catalog", 12, 0, 0);
            r.addColumn("schema", 12, 0, 0);
            r.addColumn("table", 12, 0, 0);
            r.addColumn("column", 12, 0, 0);
            r.addColumn("type", 4, 0, 0);
            r.addColumn("typeName", 12, 0, 0);
            r.addColumn("class", 12, 0, 0);
            r.addColumn("precision", 4, 0, 0);
            r.addColumn("scale", 4, 0, 0);
            r.addColumn("displaySize", 4, 0, 0);
            r.addColumn("autoIncrement", 16, 0, 0);
            r.addColumn("caseSensitive", 16, 0, 0);
            r.addColumn("currency", 16, 0, 0);
            r.addColumn("nullable", 4, 0, 0);
            r.addColumn("readOnly", 16, 0, 0);
            r.addColumn("searchable", 16, 0, 0);
            r.addColumn("signed", 16, 0, 0);
            r.addColumn("writable", 16, 0, 0);
            r.addColumn("definitelyWritable", 16, 0, 0);
            ResultSetMetaData m = rs.getMetaData();
            for (int i2 = 1; i2 <= m.getColumnCount(); ++i2) {
                r.addRow(i2, m.getColumnLabel(i2), m.getCatalogName(i2), m.getSchemaName(i2), m.getTableName(i2), m.getColumnName(i2), m.getColumnType(i2), m.getColumnTypeName(i2), m.getColumnClassName(i2), m.getPrecision(i2), m.getScale(i2), m.getColumnDisplaySize(i2), m.isAutoIncrement(i2), m.isCaseSensitive(i2), m.isCurrency(i2), m.isNullable(i2), m.isReadOnly(i2), m.isSearchable(i2), m.isSigned(i2), m.isWritable(i2), m.isDefinitelyWritable(i2));
            }
            rs = r;
        }
        ResultSetMetaData meta = rs.getMetaData();
        int columns = meta.getColumnCount();
        int rows = 0;
        if (list) {
            buff.append("<tr><th>Column</th><th>Data</th></tr><tr>");
            while (rs.next() && (maxrows <= 0 || rows < maxrows)) {
                buff.append("<tr><td>Row #</td><td>").append(++rows).append("</tr>");
                for (i = 0; i < columns; ++i) {
                    buff.append("<tr><td>").append(PageParser.escapeHtml(meta.getColumnLabel(i + 1))).append("</td><td>").append(WebApp.escapeData(rs, i + 1)).append("</td></tr>");
                }
            }
        } else {
            buff.append("<tr>");
            if (edit) {
                buff.append("<th>${text.resultEdit.action}</th>");
            }
            for (i = 0; i < columns; ++i) {
                buff.append("<th>").append(PageParser.escapeHtml(meta.getColumnLabel(i + 1))).append("</th>");
            }
            buff.append("</tr>");
            while (rs.next() && (maxrows <= 0 || rows < maxrows)) {
                ++rows;
                buff.append("<tr>");
                if (edit) {
                    buff.append("<td>").append("<img onclick=\"javascript:editRow(").append(rs.getRow()).append(",'${sessionId}', '${text.resultEdit.save}', '${text.resultEdit.cancel}'").append(")\" width=16 height=16 src=\"ico_write.gif\" onmouseover = \"this.className ='icon_hover'\" onmouseout = \"this.className ='icon'\" class=\"icon\" alt=\"${text.resultEdit.edit}\" title=\"${text.resultEdit.edit}\" border=\"1\"/>").append("<a href=\"editResult.do?op=2&row=").append(rs.getRow()).append("&jsessionid=${sessionId}\" target=\"h2result\" ><img width=16 height=16 src=\"ico_remove.gif\" onmouseover = \"this.className ='icon_hover'\" onmouseout = \"this.className ='icon'\" class=\"icon\" alt=\"${text.resultEdit.delete}\" title=\"${text.resultEdit.delete}\" border=\"1\" /></a>").append("</td>");
                }
                for (i = 0; i < columns; ++i) {
                    buff.append("<td>").append(WebApp.escapeData(rs, i + 1)).append("</td>");
                }
                buff.append("</tr>");
            }
        }
        boolean isUpdatable = false;
        try {
            if (!this.session.getContents().isDB2()) {
                isUpdatable = rs.getConcurrency() == 1008 && rs.getType() != 1003;
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        if (edit) {
            ResultSet old = this.session.result;
            if (old != null) {
                old.close();
            }
            this.session.result = rs;
        } else {
            rs.close();
        }
        if (edit) {
            buff.append("<tr><td>").append("<img onclick=\"javascript:editRow(-1, '${sessionId}', '${text.resultEdit.save}', '${text.resultEdit.cancel}'").append(")\" width=16 height=16 src=\"ico_add.gif\" onmouseover = \"this.className ='icon_hover'\" onmouseout = \"this.className ='icon'\" class=\"icon\" alt=\"${text.resultEdit.add}\" title=\"${text.resultEdit.add}\" border=\"1\"/>").append("</td>");
            for (int i3 = 0; i3 < columns; ++i3) {
                buff.append("<td></td>");
            }
            buff.append("</tr>");
        }
        buff.append("</table>");
        if (edit) {
            buff.append("</form>");
        }
        if (rows == 0) {
            buff.append("(${text.result.noRows}");
        } else if (rows == 1) {
            buff.append("(${text.result.1row}");
        } else {
            buff.append('(').append(rows).append(" ${text.result.rows}");
        }
        buff.append(", ");
        time = System.currentTimeMillis() - time;
        buff.append(time).append(" ms)");
        if (!edit && isUpdatable && allowEdit) {
            buff.append("<br /><br /><form name=\"editResult\" method=\"post\" action=\"query.do?jsessionid=${sessionId}\" target=\"h2result\"><input type=\"submit\" class=\"button\" value=\"${text.resultEdit.editResult}\" /><input type=\"hidden\" name=\"sql\" value=\"@edit ").append(PageParser.escapeHtmlData(sql)).append("\" /></form>");
        }
        return buff.toString();
    }

    private String settingSave() {
        ConnectionInfo info = new ConnectionInfo();
        info.name = this.attributes.getProperty("name", "");
        info.driver = this.attributes.getProperty("driver", "");
        info.url = this.attributes.getProperty("url", "");
        info.user = this.attributes.getProperty("user", "");
        this.server.updateSetting(info);
        this.attributes.put("setting", info.name);
        this.server.saveProperties(null);
        return "index.do";
    }

    private static String escapeData(ResultSet rs, int columnIndex) throws SQLException {
        String d = rs.getString(columnIndex);
        if (d == null) {
            return "<i>null</i>";
        }
        if (d.length() > 100000) {
            String s = WebApp.isBinary(rs.getMetaData().getColumnType(columnIndex)) ? PageParser.escapeHtml(d.substring(0, 6)) + "... (" + d.length() / 2 + " ${text.result.bytes})" : PageParser.escapeHtml(d.substring(0, 100)) + "... (" + d.length() + " ${text.result.characters})";
            return "<div style='display: none'>=+</div>" + s;
        }
        if (d.equals("null") || d.startsWith("= ") || d.startsWith("=+")) {
            return "<div style='display: none'>= </div>" + PageParser.escapeHtml(d);
        }
        if (d.equals("")) {
            return "";
        }
        return PageParser.escapeHtml(d);
    }

    private static boolean isBinary(int sqlType) {
        switch (sqlType) {
            case -4: 
            case -3: 
            case -2: 
            case 1111: 
            case 2000: 
            case 2004: {
                return true;
            }
        }
        return false;
    }

    private void unescapeData(String x, ResultSet rs, int columnIndex) throws SQLException {
        if (x.equals("null")) {
            rs.updateNull(columnIndex);
            return;
        }
        if (x.startsWith("=+")) {
            return;
        }
        if (x.equals("=*")) {
            int type = rs.getMetaData().getColumnType(columnIndex);
            switch (type) {
                case 92: {
                    rs.updateString(columnIndex, "12:00:00");
                    break;
                }
                case 91: 
                case 93: {
                    rs.updateString(columnIndex, "2001-01-01");
                    break;
                }
                default: {
                    rs.updateString(columnIndex, "1");
                }
            }
            return;
        }
        if (x.startsWith("= ")) {
            x = x.substring(2);
        }
        ResultSetMetaData meta = rs.getMetaData();
        int type = meta.getColumnType(columnIndex);
        if (this.session.getContents().isH2()) {
            rs.updateString(columnIndex, x);
            return;
        }
        switch (type) {
            case -5: {
                rs.updateLong(columnIndex, (long)Long.decode(x));
                break;
            }
            case 3: {
                rs.updateBigDecimal(columnIndex, new BigDecimal(x));
                break;
            }
            case 6: 
            case 8: {
                rs.updateDouble(columnIndex, Double.parseDouble(x));
                break;
            }
            case 7: {
                rs.updateFloat(columnIndex, Float.parseFloat(x));
                break;
            }
            case 4: {
                rs.updateInt(columnIndex, (int)Integer.decode(x));
                break;
            }
            case -6: {
                rs.updateShort(columnIndex, (short)Short.decode(x));
                break;
            }
            default: {
                rs.updateString(columnIndex, x);
            }
        }
    }

    private String settingRemove() {
        String setting = this.attributes.getProperty("name", "");
        this.server.removeSetting(setting);
        ArrayList<ConnectionInfo> settings = this.server.getSettings();
        if (settings.size() > 0) {
            this.attributes.put("setting", settings.get(0));
        }
        this.server.saveProperties(null);
        return "index.do";
    }

    String getMimeType() {
        return this.mimeType;
    }

    boolean getCache() {
        return this.cache;
    }

    WebSession getSession() {
        return this.session;
    }

    private void trace(String s) {
        this.server.trace(s);
    }

    static class IndexInfo {
        String name;
        String type;
        String columns;

        IndexInfo() {
        }
    }
}

