/*
 * Decompiled with CFR 0.152.
 */
package org.h2.store;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Timestamp;
import org.h2.engine.SysProperties;
import org.h2.message.DbException;
import org.h2.mvstore.DataUtils;
import org.h2.store.DataHandler;
import org.h2.tools.SimpleResultSet;
import org.h2.util.DateTimeUtils;
import org.h2.util.MathUtils;
import org.h2.value.DataType;
import org.h2.value.Value;
import org.h2.value.ValueArray;
import org.h2.value.ValueBoolean;
import org.h2.value.ValueByte;
import org.h2.value.ValueBytes;
import org.h2.value.ValueDate;
import org.h2.value.ValueDecimal;
import org.h2.value.ValueDouble;
import org.h2.value.ValueFloat;
import org.h2.value.ValueGeometry;
import org.h2.value.ValueInt;
import org.h2.value.ValueJavaObject;
import org.h2.value.ValueLob;
import org.h2.value.ValueLobDb;
import org.h2.value.ValueLong;
import org.h2.value.ValueNull;
import org.h2.value.ValueResultSet;
import org.h2.value.ValueShort;
import org.h2.value.ValueString;
import org.h2.value.ValueStringFixed;
import org.h2.value.ValueStringIgnoreCase;
import org.h2.value.ValueTime;
import org.h2.value.ValueTimestamp;
import org.h2.value.ValueTimestampTimeZone;
import org.h2.value.ValueUuid;

public class Data {
    public static final int LENGTH_INT = 4;
    private static final int LENGTH_LONG = 8;
    private static final int INT_0_15 = 32;
    private static final int LONG_0_7 = 48;
    private static final int DECIMAL_0_1 = 56;
    private static final int DECIMAL_SMALL_0 = 58;
    private static final int DECIMAL_SMALL = 59;
    private static final int DOUBLE_0_1 = 60;
    private static final int FLOAT_0_1 = 62;
    private static final int BOOLEAN_FALSE = 64;
    private static final int BOOLEAN_TRUE = 65;
    private static final int INT_NEG = 66;
    private static final int LONG_NEG = 67;
    private static final int STRING_0_31 = 68;
    private static final int BYTES_0_31 = 100;
    private static final int LOCAL_TIME = 132;
    private static final int LOCAL_DATE = 133;
    private static final int LOCAL_TIMESTAMP = 134;
    private static final long MILLIS_PER_MINUTE = 60000L;
    private static final boolean STORE_LOCAL_TIME = false;
    private byte[] data;
    private int pos;
    private final DataHandler handler;

    private Data(DataHandler handler, byte[] data) {
        this.handler = handler;
        this.data = data;
    }

    public void setInt(int pos, int x) {
        byte[] buff = this.data;
        buff[pos] = (byte)(x >> 24);
        buff[pos + 1] = (byte)(x >> 16);
        buff[pos + 2] = (byte)(x >> 8);
        buff[pos + 3] = (byte)x;
    }

    public void writeInt(int x) {
        byte[] buff = this.data;
        buff[this.pos] = (byte)(x >> 24);
        buff[this.pos + 1] = (byte)(x >> 16);
        buff[this.pos + 2] = (byte)(x >> 8);
        buff[this.pos + 3] = (byte)x;
        this.pos += 4;
    }

    public int readInt() {
        byte[] buff = this.data;
        int x = (buff[this.pos] << 24) + ((buff[this.pos + 1] & 0xFF) << 16) + ((buff[this.pos + 2] & 0xFF) << 8) + (buff[this.pos + 3] & 0xFF);
        this.pos += 4;
        return x;
    }

    public static int getStringLen(String s) {
        int len = s.length();
        return Data.getStringWithoutLengthLen(s, len) + Data.getVarIntLen(len);
    }

    private static int getStringWithoutLengthLen(String s, int len) {
        int plus = 0;
        for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            if (c >= '\u0800') {
                plus += 2;
                continue;
            }
            if (c < '\u0080') continue;
            ++plus;
        }
        return len + plus;
    }

    public String readString() {
        int len = this.readVarInt();
        return this.readString(len);
    }

    private String readString(int len) {
        byte[] buff = this.data;
        int p = this.pos;
        char[] chars = new char[len];
        for (int i = 0; i < len; ++i) {
            int x;
            chars[i] = (x = buff[p++] & 0xFF) < 128 ? (char)x : (x >= 224 ? (char)(((x & 0xF) << 12) + ((buff[p++] & 0x3F) << 6) + (buff[p++] & 0x3F)) : (char)(((x & 0x1F) << 6) + (buff[p++] & 0x3F)));
        }
        this.pos = p;
        return new String(chars);
    }

    public void writeString(String s) {
        int len = s.length();
        this.writeVarInt(len);
        this.writeStringWithoutLength(s, len);
    }

    private void writeStringWithoutLength(String s, int len) {
        int p = this.pos;
        byte[] buff = this.data;
        for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            if (c < '\u0080') {
                buff[p++] = (byte)c;
                continue;
            }
            if (c >= '\u0800') {
                buff[p++] = (byte)(0xE0 | c >> 12);
                buff[p++] = (byte)(c >> 6 & 0x3F);
                buff[p++] = (byte)(c & 0x3F);
                continue;
            }
            buff[p++] = (byte)(0xC0 | c >> 6);
            buff[p++] = (byte)(c & 0x3F);
        }
        this.pos = p;
    }

    private void writeStringWithoutLength(char[] chars, int len) {
        int p = this.pos;
        byte[] buff = this.data;
        for (int i = 0; i < len; ++i) {
            char c = chars[i];
            if (c < '\u0080') {
                buff[p++] = (byte)c;
                continue;
            }
            if (c >= '\u0800') {
                buff[p++] = (byte)(0xE0 | c >> 12);
                buff[p++] = (byte)(c >> 6 & 0x3F);
                buff[p++] = (byte)(c & 0x3F);
                continue;
            }
            buff[p++] = (byte)(0xC0 | c >> 6);
            buff[p++] = (byte)(c & 0x3F);
        }
        this.pos = p;
    }

    public static Data create(DataHandler handler, int capacity) {
        return new Data(handler, new byte[capacity]);
    }

    public static Data create(DataHandler handler, byte[] buff) {
        return new Data(handler, buff);
    }

    public int length() {
        return this.pos;
    }

    public byte[] getBytes() {
        return this.data;
    }

    public void reset() {
        this.pos = 0;
    }

    public void write(byte[] buff, int off, int len) {
        System.arraycopy(buff, off, this.data, this.pos, len);
        this.pos += len;
    }

    public void read(byte[] buff, int off, int len) {
        System.arraycopy(this.data, this.pos, buff, off, len);
        this.pos += len;
    }

    public void writeByte(byte x) {
        this.data[this.pos++] = x;
    }

    public byte readByte() {
        return this.data[this.pos++];
    }

    public long readLong() {
        return ((long)this.readInt() << 32) + ((long)this.readInt() & 0xFFFFFFFFL);
    }

    public void writeLong(long x) {
        this.writeInt((int)(x >>> 32));
        this.writeInt((int)x);
    }

    public void writeValue(Value v) {
        int start = this.pos;
        if (v == ValueNull.INSTANCE) {
            this.data[this.pos++] = 0;
            return;
        }
        int type = v.getType();
        switch (type) {
            case 1: {
                this.writeByte((byte)(v.getBoolean() != false ? 65 : 64));
                break;
            }
            case 2: {
                this.writeByte((byte)type);
                this.writeByte(v.getByte());
                break;
            }
            case 3: {
                this.writeByte((byte)type);
                this.writeShortInt(v.getShort());
                break;
            }
            case 4: {
                int x = v.getInt();
                if (x < 0) {
                    this.writeByte((byte)66);
                    this.writeVarInt(-x);
                    break;
                }
                if (x < 16) {
                    this.writeByte((byte)(32 + x));
                    break;
                }
                this.writeByte((byte)type);
                this.writeVarInt(x);
                break;
            }
            case 5: {
                long x = v.getLong();
                if (x < 0L) {
                    this.writeByte((byte)67);
                    this.writeVarLong(-x);
                    break;
                }
                if (x < 8L) {
                    this.writeByte((byte)(48L + x));
                    break;
                }
                this.writeByte((byte)type);
                this.writeVarLong(x);
                break;
            }
            case 6: {
                BigDecimal x = v.getBigDecimal();
                if (BigDecimal.ZERO.equals(x)) {
                    this.writeByte((byte)56);
                    break;
                }
                if (BigDecimal.ONE.equals(x)) {
                    this.writeByte((byte)57);
                    break;
                }
                int scale = x.scale();
                BigInteger b = x.unscaledValue();
                int bits = b.bitLength();
                if (bits <= 63) {
                    if (scale == 0) {
                        this.writeByte((byte)58);
                        this.writeVarLong(b.longValue());
                        break;
                    }
                    this.writeByte((byte)59);
                    this.writeVarInt(scale);
                    this.writeVarLong(b.longValue());
                    break;
                }
                this.writeByte((byte)type);
                this.writeVarInt(scale);
                byte[] bytes = b.toByteArray();
                this.writeVarInt(bytes.length);
                this.write(bytes, 0, bytes.length);
                break;
            }
            case 9: {
                this.writeByte((byte)type);
                this.writeVarLong(DateTimeUtils.getTimeLocalWithoutDst(v.getTime()));
                break;
            }
            case 10: {
                this.writeByte((byte)type);
                long x = DateTimeUtils.getTimeLocalWithoutDst(v.getDate());
                this.writeVarLong(x / 60000L);
                break;
            }
            case 11: {
                Timestamp ts = v.getTimestamp();
                this.writeByte((byte)type);
                this.writeVarLong(DateTimeUtils.getTimeLocalWithoutDst(ts));
                this.writeVarInt(ts.getNanos() % 1000000);
                break;
            }
            case 24: {
                ValueTimestampTimeZone ts = (ValueTimestampTimeZone)v;
                this.writeByte((byte)type);
                this.writeVarLong(ts.getDateValue());
                this.writeVarLong(ts.getTimeNanos());
                this.writeVarInt(ts.getTimeZoneOffsetMins());
            }
            case 19: 
            case 22: {
                this.writeByte((byte)type);
                byte[] b = v.getBytesNoCopy();
                int len = b.length;
                this.writeVarInt(len);
                this.write(b, 0, len);
                break;
            }
            case 12: {
                byte[] b = v.getBytesNoCopy();
                int len = b.length;
                if (len < 32) {
                    this.writeByte((byte)(100 + len));
                    this.write(b, 0, len);
                    break;
                }
                this.writeByte((byte)type);
                this.writeVarInt(len);
                this.write(b, 0, len);
                break;
            }
            case 20: {
                this.writeByte((byte)type);
                ValueUuid uuid = (ValueUuid)v;
                this.writeLong(uuid.getHigh());
                this.writeLong(uuid.getLow());
                break;
            }
            case 13: {
                String s = v.getString();
                int len = s.length();
                if (len < 32) {
                    this.writeByte((byte)(68 + len));
                    this.writeStringWithoutLength(s, len);
                    break;
                }
                this.writeByte((byte)type);
                this.writeString(s);
                break;
            }
            case 14: 
            case 21: {
                this.writeByte((byte)type);
                this.writeString(v.getString());
                break;
            }
            case 7: {
                double x = v.getDouble();
                if (x == 1.0) {
                    this.writeByte((byte)61);
                    break;
                }
                long d = Double.doubleToLongBits(x);
                if (d == ValueDouble.ZERO_BITS) {
                    this.writeByte((byte)60);
                    break;
                }
                this.writeByte((byte)type);
                this.writeVarLong(Long.reverse(d));
                break;
            }
            case 8: {
                float x = v.getFloat();
                if (x == 1.0f) {
                    this.writeByte((byte)63);
                    break;
                }
                int f = Float.floatToIntBits(x);
                if (f == ValueFloat.ZERO_BITS) {
                    this.writeByte((byte)62);
                    break;
                }
                this.writeByte((byte)type);
                this.writeVarInt(Integer.reverse(f));
                break;
            }
            case 15: 
            case 16: {
                this.writeByte((byte)type);
                if (v instanceof ValueLob) {
                    ValueLob lob = (ValueLob)v;
                    lob.convertToFileIfRequired(this.handler);
                    byte[] small = lob.getSmall();
                    if (small == null) {
                        int t = -1;
                        if (!lob.isLinkedToTable()) {
                            t = -2;
                        }
                        this.writeVarInt(t);
                        this.writeVarInt(lob.getTableId());
                        this.writeVarInt(lob.getObjectId());
                        this.writeVarLong(lob.getPrecision());
                        this.writeByte((byte)(lob.isCompressed() ? 1 : 0));
                        if (t != -2) break;
                        this.writeString(lob.getFileName());
                        break;
                    }
                    this.writeVarInt(small.length);
                    this.write(small, 0, small.length);
                    break;
                }
                ValueLobDb lob = (ValueLobDb)v;
                byte[] small = lob.getSmall();
                if (small == null) {
                    this.writeVarInt(-3);
                    this.writeVarInt(lob.getTableId());
                    this.writeVarLong(lob.getLobId());
                    this.writeVarLong(lob.getPrecision());
                    break;
                }
                this.writeVarInt(small.length);
                this.write(small, 0, small.length);
                break;
            }
            case 17: {
                this.writeByte((byte)type);
                Value[] list = ((ValueArray)v).getList();
                this.writeVarInt(list.length);
                for (Value x : list) {
                    this.writeValue(x);
                }
                break;
            }
            case 18: {
                this.writeByte((byte)type);
                try {
                    int i;
                    ResultSet rs = ((ValueResultSet)v).getResultSet();
                    rs.beforeFirst();
                    ResultSetMetaData meta = rs.getMetaData();
                    int columnCount = meta.getColumnCount();
                    this.writeVarInt(columnCount);
                    for (i = 0; i < columnCount; ++i) {
                        this.writeString(meta.getColumnName(i + 1));
                        this.writeVarInt(meta.getColumnType(i + 1));
                        this.writeVarInt(meta.getPrecision(i + 1));
                        this.writeVarInt(meta.getScale(i + 1));
                    }
                    while (rs.next()) {
                        this.writeByte((byte)1);
                        for (i = 0; i < columnCount; ++i) {
                            int t = DataType.getValueTypeFromResultSet(meta, i + 1);
                            Value val = DataType.readValue(null, rs, i + 1, t);
                            this.writeValue(val);
                        }
                    }
                    this.writeByte((byte)0);
                    rs.beforeFirst();
                    break;
                }
                catch (SQLException e) {
                    throw DbException.convert(e);
                }
            }
            default: {
                DbException.throwInternalError("type=" + v.getType());
            }
        }
        if (SysProperties.CHECK2 && this.pos - start != Data.getValueLen(v, this.handler)) {
            throw DbException.throwInternalError("value size error: got " + (this.pos - start) + " expected " + Data.getValueLen(v, this.handler));
        }
    }

    public Value readValue() {
        int type = this.data[this.pos++] & 0xFF;
        switch (type) {
            case 0: {
                return ValueNull.INSTANCE;
            }
            case 65: {
                return ValueBoolean.get(true);
            }
            case 64: {
                return ValueBoolean.get(false);
            }
            case 66: {
                return ValueInt.get(-this.readVarInt());
            }
            case 4: {
                return ValueInt.get(this.readVarInt());
            }
            case 67: {
                return ValueLong.get(-this.readVarLong());
            }
            case 5: {
                return ValueLong.get(this.readVarLong());
            }
            case 2: {
                return ValueByte.get(this.readByte());
            }
            case 3: {
                return ValueShort.get(this.readShortInt());
            }
            case 56: {
                return (ValueDecimal)ValueDecimal.ZERO;
            }
            case 57: {
                return (ValueDecimal)ValueDecimal.ONE;
            }
            case 58: {
                return ValueDecimal.get(BigDecimal.valueOf(this.readVarLong()));
            }
            case 59: {
                int scale = this.readVarInt();
                return ValueDecimal.get(BigDecimal.valueOf(this.readVarLong(), scale));
            }
            case 6: {
                int scale = this.readVarInt();
                int len = this.readVarInt();
                byte[] buff = DataUtils.newBytes(len);
                this.read(buff, 0, len);
                BigInteger b = new BigInteger(buff);
                return ValueDecimal.get(new BigDecimal(b, scale));
            }
            case 133: {
                return ValueDate.fromDateValue(this.readVarLong());
            }
            case 10: {
                long x = this.readVarLong() * 60000L;
                return ValueDate.fromMillis(DateTimeUtils.getTimeUTCWithoutDst(x));
            }
            case 132: {
                long nanos = this.readVarLong() * 1000000L + this.readVarLong();
                return ValueTime.fromNanos(nanos);
            }
            case 9: {
                return ValueTime.fromMillis(DateTimeUtils.getTimeUTCWithoutDst(this.readVarLong()));
            }
            case 134: {
                long dateValue = this.readVarLong();
                long nanos = this.readVarLong() * 1000000L + this.readVarLong();
                return ValueTimestamp.fromDateValueAndNanos(dateValue, nanos);
            }
            case 11: {
                return ValueTimestamp.fromMillisNanos(DateTimeUtils.getTimeUTCWithoutDst(this.readVarLong()), this.readVarInt());
            }
            case 24: {
                long dateValue = this.readVarLong();
                long nanos = this.readVarLong();
                short tz = (short)this.readVarInt();
                return ValueTimestampTimeZone.fromDateValueAndNanos(dateValue, nanos, tz);
            }
            case 12: {
                int len = this.readVarInt();
                byte[] b = DataUtils.newBytes(len);
                this.read(b, 0, len);
                return ValueBytes.getNoCopy(b);
            }
            case 22: {
                int len = this.readVarInt();
                byte[] b = DataUtils.newBytes(len);
                this.read(b, 0, len);
                return ValueGeometry.get(b);
            }
            case 19: {
                int len = this.readVarInt();
                byte[] b = DataUtils.newBytes(len);
                this.read(b, 0, len);
                return ValueJavaObject.getNoCopy(null, b, this.handler);
            }
            case 20: {
                return ValueUuid.get(this.readLong(), this.readLong());
            }
            case 13: {
                return ValueString.get(this.readString());
            }
            case 14: {
                return ValueStringIgnoreCase.get(this.readString());
            }
            case 21: {
                return ValueStringFixed.get(this.readString());
            }
            case 62: {
                return ValueFloat.get(0.0f);
            }
            case 63: {
                return ValueFloat.get(1.0f);
            }
            case 60: {
                return ValueDouble.get(0.0);
            }
            case 61: {
                return ValueDouble.get(1.0);
            }
            case 7: {
                return ValueDouble.get(Double.longBitsToDouble(Long.reverse(this.readVarLong())));
            }
            case 8: {
                return ValueFloat.get(Float.intBitsToFloat(Integer.reverse(this.readVarInt())));
            }
            case 15: 
            case 16: {
                int smallLen = this.readVarInt();
                if (smallLen >= 0) {
                    byte[] small = DataUtils.newBytes(smallLen);
                    this.read(small, 0, smallLen);
                    return ValueLobDb.createSmallLob(type, small);
                }
                if (smallLen == -3) {
                    int tableId = this.readVarInt();
                    long lobId = this.readVarLong();
                    long precision = this.readVarLong();
                    ValueLobDb lob = ValueLobDb.create(type, this.handler, tableId, lobId, null, precision);
                    return lob;
                }
                int tableId = this.readVarInt();
                int objectId = this.readVarInt();
                long precision = 0L;
                boolean compression = false;
                if (smallLen == -1 || smallLen == -2) {
                    precision = this.readVarLong();
                    boolean bl = compression = this.readByte() == 1;
                }
                if (smallLen == -2) {
                    String filename = this.readString();
                    return ValueLob.openUnlinked(type, this.handler, tableId, objectId, precision, compression, filename);
                }
                return ValueLob.openLinked(type, this.handler, tableId, objectId, precision, compression);
            }
            case 17: {
                int len = this.readVarInt();
                Value[] list = new Value[len];
                for (int i = 0; i < len; ++i) {
                    list[i] = this.readValue();
                }
                return ValueArray.get(list);
            }
            case 18: {
                SimpleResultSet rs = new SimpleResultSet();
                rs.setAutoClose(false);
                int columns = this.readVarInt();
                for (int i = 0; i < columns; ++i) {
                    rs.addColumn(this.readString(), this.readVarInt(), this.readVarInt(), this.readVarInt());
                }
                while (this.readByte() != 0) {
                    Object[] o = new Object[columns];
                    for (int i = 0; i < columns; ++i) {
                        o[i] = this.readValue().getObject();
                    }
                    rs.addRow(o);
                }
                return ValueResultSet.get(rs);
            }
        }
        if (type >= 32 && type < 48) {
            return ValueInt.get(type - 32);
        }
        if (type >= 48 && type < 56) {
            return ValueLong.get(type - 48);
        }
        if (type >= 100 && type < 132) {
            int len = type - 100;
            byte[] b = DataUtils.newBytes(len);
            this.read(b, 0, len);
            return ValueBytes.getNoCopy(b);
        }
        if (type >= 68 && type < 100) {
            return ValueString.get(this.readString(type - 68));
        }
        throw DbException.get(90030, "type: " + type);
    }

    public int getValueLen(Value v) {
        return Data.getValueLen(v, this.handler);
    }

    public static int getValueLen(Value v, DataHandler handler) {
        if (v == ValueNull.INSTANCE) {
            return 1;
        }
        switch (v.getType()) {
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 3;
            }
            case 4: {
                int x = v.getInt();
                if (x < 0) {
                    return 1 + Data.getVarIntLen(-x);
                }
                if (x < 16) {
                    return 1;
                }
                return 1 + Data.getVarIntLen(x);
            }
            case 5: {
                long x = v.getLong();
                if (x < 0L) {
                    return 1 + Data.getVarLongLen(-x);
                }
                if (x < 8L) {
                    return 1;
                }
                return 1 + Data.getVarLongLen(x);
            }
            case 7: {
                double x = v.getDouble();
                if (x == 1.0) {
                    return 1;
                }
                long d = Double.doubleToLongBits(x);
                if (d == ValueDouble.ZERO_BITS) {
                    return 1;
                }
                return 1 + Data.getVarLongLen(Long.reverse(d));
            }
            case 8: {
                float x = v.getFloat();
                if (x == 1.0f) {
                    return 1;
                }
                int f = Float.floatToIntBits(x);
                if (f == ValueFloat.ZERO_BITS) {
                    return 1;
                }
                return 1 + Data.getVarIntLen(Integer.reverse(f));
            }
            case 13: {
                String s = v.getString();
                int len = s.length();
                if (len < 32) {
                    return 1 + Data.getStringWithoutLengthLen(s, len);
                }
                return 1 + Data.getStringLen(s);
            }
            case 14: 
            case 21: {
                return 1 + Data.getStringLen(v.getString());
            }
            case 6: {
                BigDecimal x = v.getBigDecimal();
                if (BigDecimal.ZERO.equals(x)) {
                    return 1;
                }
                if (BigDecimal.ONE.equals(x)) {
                    return 1;
                }
                int scale = x.scale();
                BigInteger b = x.unscaledValue();
                int bits = b.bitLength();
                if (bits <= 63) {
                    if (scale == 0) {
                        return 1 + Data.getVarLongLen(b.longValue());
                    }
                    return 1 + Data.getVarIntLen(scale) + Data.getVarLongLen(b.longValue());
                }
                byte[] bytes = b.toByteArray();
                return 1 + Data.getVarIntLen(scale) + Data.getVarIntLen(bytes.length) + bytes.length;
            }
            case 9: {
                return 1 + Data.getVarLongLen(DateTimeUtils.getTimeLocalWithoutDst(v.getTime()));
            }
            case 10: {
                long x = DateTimeUtils.getTimeLocalWithoutDst(v.getDate());
                return 1 + Data.getVarLongLen(x / 60000L);
            }
            case 11: {
                Timestamp ts = v.getTimestamp();
                return 1 + Data.getVarLongLen(DateTimeUtils.getTimeLocalWithoutDst(ts)) + Data.getVarIntLen(ts.getNanos() % 1000000);
            }
            case 24: {
                ValueTimestampTimeZone ts = (ValueTimestampTimeZone)v;
                long dateValue = ts.getDateValue();
                long nanos = ts.getTimeNanos();
                short tz = ts.getTimeZoneOffsetMins();
                return 1 + Data.getVarLongLen(dateValue) + Data.getVarLongLen(nanos) + Data.getVarIntLen(tz);
            }
            case 19: 
            case 22: {
                byte[] b = v.getBytesNoCopy();
                return 1 + Data.getVarIntLen(b.length) + b.length;
            }
            case 12: {
                byte[] b = v.getBytesNoCopy();
                int len = b.length;
                if (len < 32) {
                    return 1 + b.length;
                }
                return 1 + Data.getVarIntLen(b.length) + b.length;
            }
            case 20: {
                return 17;
            }
            case 15: 
            case 16: {
                int len = 1;
                if (v instanceof ValueLob) {
                    ValueLob lob = (ValueLob)v;
                    lob.convertToFileIfRequired(handler);
                    byte[] small = lob.getSmall();
                    if (small == null) {
                        int t = -1;
                        if (!lob.isLinkedToTable()) {
                            t = -2;
                        }
                        len += Data.getVarIntLen(t);
                        len += Data.getVarIntLen(lob.getTableId());
                        len += Data.getVarIntLen(lob.getObjectId());
                        len += Data.getVarLongLen(lob.getPrecision());
                        ++len;
                        if (t == -2) {
                            len += Data.getStringLen(lob.getFileName());
                        }
                    } else {
                        len += Data.getVarIntLen(small.length);
                        len += small.length;
                    }
                } else {
                    ValueLobDb lob = (ValueLobDb)v;
                    byte[] small = lob.getSmall();
                    if (small == null) {
                        len += Data.getVarIntLen(-3);
                        len += Data.getVarIntLen(lob.getTableId());
                        len += Data.getVarLongLen(lob.getLobId());
                        len += Data.getVarLongLen(lob.getPrecision());
                    } else {
                        len += Data.getVarIntLen(small.length);
                        len += small.length;
                    }
                }
                return len;
            }
            case 17: {
                Value[] list = ((ValueArray)v).getList();
                int len = 1 + Data.getVarIntLen(list.length);
                for (Value x : list) {
                    len += Data.getValueLen(x, handler);
                }
                return len;
            }
            case 18: {
                int len = 1;
                try {
                    int i;
                    ResultSet rs = ((ValueResultSet)v).getResultSet();
                    rs.beforeFirst();
                    ResultSetMetaData meta = rs.getMetaData();
                    int columnCount = meta.getColumnCount();
                    len += Data.getVarIntLen(columnCount);
                    for (i = 0; i < columnCount; ++i) {
                        len += Data.getStringLen(meta.getColumnName(i + 1));
                        len += Data.getVarIntLen(meta.getColumnType(i + 1));
                        len += Data.getVarIntLen(meta.getPrecision(i + 1));
                        len += Data.getVarIntLen(meta.getScale(i + 1));
                    }
                    while (rs.next()) {
                        ++len;
                        for (i = 0; i < columnCount; ++i) {
                            int t = DataType.getValueTypeFromResultSet(meta, i + 1);
                            Value val = DataType.readValue(null, rs, i + 1, t);
                            len += Data.getValueLen(val, handler);
                        }
                    }
                    rs.beforeFirst();
                }
                catch (SQLException e) {
                    throw DbException.convert(e);
                }
                return ++len;
            }
        }
        throw DbException.throwInternalError("type=" + v.getType());
    }

    public void setPos(int pos) {
        this.pos = pos;
    }

    public void writeShortInt(int x) {
        byte[] buff = this.data;
        buff[this.pos++] = (byte)(x >> 8);
        buff[this.pos++] = (byte)x;
    }

    public short readShortInt() {
        byte[] buff = this.data;
        return (short)(((buff[this.pos++] & 0xFF) << 8) + (buff[this.pos++] & 0xFF));
    }

    public void truncate(int size) {
        if (this.pos > size) {
            byte[] buff = new byte[size];
            System.arraycopy(this.data, 0, buff, 0, size);
            this.pos = size;
            this.data = buff;
        }
    }

    private static int getVarIntLen(int x) {
        if ((x & 0xFFFFFF80) == 0) {
            return 1;
        }
        if ((x & 0xFFFFC000) == 0) {
            return 2;
        }
        if ((x & 0xFFE00000) == 0) {
            return 3;
        }
        if ((x & 0xF0000000) == 0) {
            return 4;
        }
        return 5;
    }

    public void writeVarInt(int x) {
        while ((x & 0xFFFFFF80) != 0) {
            this.data[this.pos++] = (byte)(0x80 | x & 0x7F);
            x >>>= 7;
        }
        this.data[this.pos++] = (byte)x;
    }

    public int readVarInt() {
        byte b = this.data[this.pos];
        if (b >= 0) {
            ++this.pos;
            return b;
        }
        return this.readVarIntRest(b);
    }

    private int readVarIntRest(int b) {
        int x = b & 0x7F;
        b = this.data[this.pos + 1];
        if (b >= 0) {
            this.pos += 2;
            return x | b << 7;
        }
        x |= (b & 0x7F) << 7;
        b = this.data[this.pos + 2];
        if (b >= 0) {
            this.pos += 3;
            return x | b << 14;
        }
        x |= (b & 0x7F) << 14;
        b = this.data[this.pos + 3];
        if (b >= 0) {
            this.pos += 4;
            return x | b << 21;
        }
        this.pos += 5;
        return x |= (b & 0x7F) << 21 | this.data[this.pos + 4] << 28;
    }

    public static int getVarLongLen(long x) {
        int i = 1;
        while ((x >>>= 7) != 0L) {
            ++i;
        }
        return i;
    }

    public void writeVarLong(long x) {
        while ((x & 0xFFFFFFFFFFFFFF80L) != 0L) {
            this.data[this.pos++] = (byte)(x & 0x7FL | 0x80L);
            x >>>= 7;
        }
        this.data[this.pos++] = (byte)x;
    }

    public long readVarLong() {
        long x;
        if ((x = (long)this.data[this.pos++]) >= 0L) {
            return x;
        }
        x &= 0x7FL;
        int s = 7;
        while (true) {
            long b = this.data[this.pos++];
            x |= (b & 0x7FL) << s;
            if (b >= 0L) {
                return x;
            }
            s += 7;
        }
    }

    public void checkCapacity(int plus) {
        if (this.pos + plus >= this.data.length) {
            this.expand(plus);
        }
    }

    private void expand(int plus) {
        byte[] d = DataUtils.newBytes((this.data.length + plus) * 2);
        System.arraycopy(this.data, 0, d, 0, this.data.length);
        this.data = d;
    }

    public void fillAligned() {
        int len;
        this.pos = len = MathUtils.roundUpInt(this.pos + 2, 16);
        if (this.data.length < len) {
            this.checkCapacity(len - this.data.length);
        }
    }

    public static void copyString(Reader source, OutputStream target) throws IOException {
        int l;
        char[] buff = new char[4096];
        Data d = new Data(null, new byte[12288]);
        while ((l = source.read(buff)) >= 0) {
            d.writeStringWithoutLength(buff, l);
            target.write(d.data, 0, d.pos);
            d.reset();
        }
    }

    public DataHandler getHandler() {
        return this.handler;
    }
}

