/*
 * Decompiled with CFR 0.152.
 */
package org.h2.util;

import java.sql.Timestamp;
import java.util.Calendar;
import java.util.List;
import org.h2.util.ToDateTokenizer;

public class ToDateParser {
    private final String unmodifiedInputStr;
    private final String unmodifiedFormatStr;
    private final ConfigParam functionName;
    private String inputStr;
    private String formatStr;
    private final Calendar resultCalendar = (Calendar)Calendar.getInstance().clone();
    private Integer nanos;

    private ToDateParser(ConfigParam functionName, String input, String format) {
        this.resultCalendar.set(1, 1970);
        this.resultCalendar.set(2, Calendar.getInstance().get(2));
        this.resultCalendar.clear(6);
        this.resultCalendar.clear(7);
        this.resultCalendar.clear(8);
        this.resultCalendar.set(5, 1);
        this.resultCalendar.set(10, 0);
        this.resultCalendar.set(11, 0);
        this.resultCalendar.set(12, 0);
        this.resultCalendar.set(13, 0);
        this.resultCalendar.set(14, 0);
        this.resultCalendar.set(9, 0);
        this.functionName = functionName;
        this.unmodifiedInputStr = this.inputStr = input.trim();
        this.formatStr = format == null || format.isEmpty() ? functionName.getDefaultFormatStr() : format.trim();
        this.unmodifiedFormatStr = this.formatStr;
    }

    private static ToDateParser getDateParser(String input, String format) {
        ToDateParser result = new ToDateParser(ConfigParam.TO_DATE, input, format);
        ToDateParser.parse(result);
        return result;
    }

    private static ToDateParser getTimestampParser(String input, String format) {
        ToDateParser result = new ToDateParser(ConfigParam.TO_TIMESTAMP, input, format);
        ToDateParser.parse(result);
        return result;
    }

    private Timestamp getResultingTimestamp() {
        Calendar cal = (Calendar)this.getResultCalendar().clone();
        int nanosToSet = this.nanos == null ? cal.get(14) * 1000000 : this.nanos;
        cal.set(14, 0);
        Timestamp ts = new Timestamp(cal.getTimeInMillis());
        ts.setNanos(nanosToSet);
        return ts;
    }

    Calendar getResultCalendar() {
        return this.resultCalendar;
    }

    String getInputStr() {
        return this.inputStr;
    }

    String getFormatStr() {
        return this.formatStr;
    }

    String getFunctionName() {
        return this.functionName.name();
    }

    void setNanos(int nanos) {
        this.nanos = nanos;
    }

    private boolean hasToParseData() {
        return this.formatStr.length() > 0;
    }

    private void removeFirstChar() {
        if (!this.formatStr.isEmpty()) {
            this.formatStr = this.formatStr.substring(1);
        }
        if (!this.inputStr.isEmpty()) {
            this.inputStr = this.inputStr.substring(1);
        }
    }

    private static ToDateParser parse(ToDateParser p) {
        while (p.hasToParseData()) {
            List<ToDateTokenizer.FormatTokenEnum> tokenList = ToDateTokenizer.FormatTokenEnum.getTokensInQuestion(p.getFormatStr());
            if (tokenList.isEmpty()) {
                p.removeFirstChar();
                continue;
            }
            boolean foundAnToken = false;
            for (ToDateTokenizer.FormatTokenEnum token : tokenList) {
                if (!token.parseFormatStrWithToken(p)) continue;
                foundAnToken = true;
                break;
            }
            if (foundAnToken) continue;
            p.removeFirstChar();
        }
        return p;
    }

    void remove(String inputFragmentStr, String formatFragment) {
        if (inputFragmentStr != null && this.inputStr.length() >= inputFragmentStr.length()) {
            this.inputStr = this.inputStr.substring(inputFragmentStr.length());
        }
        if (formatFragment != null && this.formatStr.length() >= formatFragment.length()) {
            this.formatStr = this.formatStr.substring(formatFragment.length());
        }
    }

    public String toString() {
        int inputStrLen = this.inputStr.length();
        int orgInputLen = this.unmodifiedInputStr.length();
        int currentInputPos = orgInputLen - inputStrLen;
        int restInputLen = inputStrLen <= 0 ? inputStrLen : inputStrLen - 1;
        int orgFormatLen = this.unmodifiedFormatStr.length();
        int currentFormatPos = orgFormatLen - this.formatStr.length();
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("\n    %s('%s', '%s')", new Object[]{this.functionName, this.unmodifiedInputStr, this.unmodifiedFormatStr}));
        sb.append(String.format("\n      %s^%s ,  %s^ <-- Parsing failed at this point", String.format("%" + (this.functionName.name().length() + currentInputPos) + "s", ""), restInputLen <= 0 ? "" : String.format("%" + restInputLen + "s", ""), currentFormatPos <= 0 ? "" : String.format("%" + currentFormatPos + "s", "")));
        return sb.toString();
    }

    public static Timestamp toTimestamp(String input, String format) {
        ToDateParser parser = ToDateParser.getTimestampParser(input, format);
        return parser.getResultingTimestamp();
    }

    public static Timestamp toDate(String input, String format) {
        ToDateParser parser = ToDateParser.getDateParser(input, format);
        return parser.getResultingTimestamp();
    }

    private static enum ConfigParam {
        TO_DATE("DD MON YYYY"),
        TO_TIMESTAMP("DD MON YYYY HH:MI:SS");

        private final String defaultFormatStr;

        private ConfigParam(String defaultFormatStr) {
            this.defaultFormatStr = defaultFormatStr;
        }

        String getDefaultFormatStr() {
            return this.defaultFormatStr;
        }
    }
}

