/*
 * Decompiled with CFR 0.152.
 */
package org.h2.value;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.h2.message.DbException;
import org.h2.value.CompareMode;
import org.h2.value.Value;

public class ValueDouble
extends Value {
    public static final int PRECISION = 17;
    public static final int DISPLAY_SIZE = 24;
    public static final long ZERO_BITS = Double.doubleToLongBits(0.0);
    private static final ValueDouble ZERO = new ValueDouble(0.0);
    private static final ValueDouble ONE = new ValueDouble(1.0);
    private static final ValueDouble NAN = new ValueDouble(Double.NaN);
    private final double value;

    private ValueDouble(double value) {
        this.value = value;
    }

    @Override
    public Value add(Value v) {
        ValueDouble v2 = (ValueDouble)v;
        return ValueDouble.get(this.value + v2.value);
    }

    @Override
    public Value subtract(Value v) {
        ValueDouble v2 = (ValueDouble)v;
        return ValueDouble.get(this.value - v2.value);
    }

    @Override
    public Value negate() {
        return ValueDouble.get(-this.value);
    }

    @Override
    public Value multiply(Value v) {
        ValueDouble v2 = (ValueDouble)v;
        return ValueDouble.get(this.value * v2.value);
    }

    @Override
    public Value divide(Value v) {
        ValueDouble v2 = (ValueDouble)v;
        if (v2.value == 0.0) {
            throw DbException.get(22012, this.getSQL());
        }
        return ValueDouble.get(this.value / v2.value);
    }

    @Override
    public ValueDouble modulus(Value v) {
        ValueDouble other = (ValueDouble)v;
        if (other.value == 0.0) {
            throw DbException.get(22012, this.getSQL());
        }
        return ValueDouble.get(this.value % other.value);
    }

    @Override
    public String getSQL() {
        if (this.value == Double.POSITIVE_INFINITY) {
            return "POWER(0, -1)";
        }
        if (this.value == Double.NEGATIVE_INFINITY) {
            return "(-POWER(0, -1))";
        }
        if (Double.isNaN(this.value)) {
            return "SQRT(-1)";
        }
        return this.getString();
    }

    @Override
    public int getType() {
        return 7;
    }

    @Override
    protected int compareSecure(Value o, CompareMode mode) {
        ValueDouble v = (ValueDouble)o;
        return Double.compare(this.value, v.value);
    }

    @Override
    public int getSignum() {
        return this.value == 0.0 ? 0 : (this.value < 0.0 ? -1 : 1);
    }

    @Override
    public double getDouble() {
        return this.value;
    }

    @Override
    public String getString() {
        return String.valueOf(this.value);
    }

    @Override
    public long getPrecision() {
        return 17L;
    }

    @Override
    public int getScale() {
        return 0;
    }

    @Override
    public int hashCode() {
        long hash = Double.doubleToLongBits(this.value);
        return (int)(hash ^ hash >> 32);
    }

    @Override
    public Object getObject() {
        return this.value;
    }

    @Override
    public void set(PreparedStatement prep, int parameterIndex) throws SQLException {
        prep.setDouble(parameterIndex, this.value);
    }

    public static ValueDouble get(double d) {
        if (d == 1.0) {
            return ONE;
        }
        if (d == 0.0) {
            return ZERO;
        }
        if (Double.isNaN(d)) {
            return NAN;
        }
        return (ValueDouble)Value.cache(new ValueDouble(d));
    }

    @Override
    public int getDisplaySize() {
        return 24;
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof ValueDouble)) {
            return false;
        }
        return this.compareSecure((ValueDouble)other, null) == 0;
    }
}

