/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.provider;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.commons.util.CloseableIterator;
import org.infinispan.context.Flag;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryCreated;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryModified;
import org.infinispan.notifications.cachelistener.event.CacheEntryEvent;
import org.jboss.threads.JBossThreadFactory;
import org.wildfly.clustering.dispatcher.CommandDispatcher;
import org.wildfly.clustering.ee.Batch;
import org.wildfly.clustering.ee.Batcher;
import org.wildfly.clustering.group.Group;
import org.wildfly.clustering.group.Node;
import org.wildfly.clustering.provider.ServiceProviderRegistration;
import org.wildfly.clustering.provider.ServiceProviderRegistry;
import org.wildfly.clustering.server.logging.ClusteringServerLogger;
import org.wildfly.clustering.server.provider.CacheServiceProviderRegistryConfiguration;
import org.wildfly.clustering.server.provider.GetLocalServicesCommand;
import org.wildfly.clustering.server.provider.SimpleServiceProviderRegistration;
import org.wildfly.clustering.service.concurrent.ClassLoaderThreadFactory;
import org.wildfly.security.manager.WildFlySecurityManager;

@Listener(sync=false)
public class CacheServiceProviderRegistry<T>
implements ServiceProviderRegistry<T>,
Group.Listener,
AutoCloseable {
    private final ConcurrentMap<T, Map.Entry<ServiceProviderRegistration.Listener, ExecutorService>> listeners = new ConcurrentHashMap<T, Map.Entry<ServiceProviderRegistration.Listener, ExecutorService>>();
    private final Batcher<? extends Batch> batcher;
    private final Cache<T, Set<Node>> cache;
    private final Group group;
    private final CommandDispatcher<Set<T>> dispatcher;

    private static ThreadFactory createThreadFactory(Class<?> targetClass) {
        PrivilegedAction<ThreadFactory> action = () -> new JBossThreadFactory(new ThreadGroup(targetClass.getSimpleName()), Boolean.FALSE, null, "%G - %t", null, null);
        return new ClassLoaderThreadFactory((ThreadFactory)WildFlySecurityManager.doUnchecked(action), AccessController.doPrivileged(() -> targetClass.getClassLoader()));
    }

    public CacheServiceProviderRegistry(CacheServiceProviderRegistryConfiguration<T> config) {
        this.group = config.getGroup();
        this.cache = config.getCache();
        this.batcher = config.getBatcher();
        this.dispatcher = config.getCommandDispatcherFactory().createCommandDispatcher(config.getId(), this.listeners.keySet());
        this.cache.addListener((Object)this);
        this.group.addListener((Group.Listener)this);
    }

    @Override
    public void close() {
        this.group.removeListener((Group.Listener)this);
        this.cache.removeListener((Object)this);
        this.dispatcher.close();
        for (Map.Entry entry : this.listeners.values()) {
            ExecutorService executor = (ExecutorService)entry.getValue();
            if (executor == null) continue;
            PrivilegedAction<List> action = () -> executor.shutdownNow();
            WildFlySecurityManager.doUnchecked(action);
        }
        this.listeners.clear();
    }

    public Group getGroup() {
        return this.group;
    }

    public ServiceProviderRegistration<T> register(T service) {
        return this.register(service, null);
    }

    public ServiceProviderRegistration<T> register(T service, ServiceProviderRegistration.Listener listener) {
        AbstractMap.SimpleEntry<ServiceProviderRegistration.Listener, Object> newEntry = new AbstractMap.SimpleEntry<ServiceProviderRegistration.Listener, Object>(listener, null);
        Map.Entry entry = this.listeners.computeIfAbsent(service, key -> {
            if (listener != null) {
                newEntry.setValue(Executors.newSingleThreadExecutor(CacheServiceProviderRegistry.createThreadFactory(listener.getClass())));
            }
            return newEntry;
        });
        if (entry != newEntry) {
            throw new IllegalArgumentException(service.toString());
        }
        try (Batch batch = this.batcher.createBatch();){
            this.register(this.group.getLocalNode(), service);
        }
        return new SimpleServiceProviderRegistration<T>(service, this, () -> {
            Node node = this.getGroup().getLocalNode();
            try (Batch batch = this.batcher.createBatch();){
                Set nodes = (Set)this.cache.getAdvancedCache().withFlags(new Flag[]{Flag.FORCE_WRITE_LOCK}).get(service);
                if (nodes != null && nodes.remove(node)) {
                    AdvancedCache cache = this.cache.getAdvancedCache().withFlags(new Flag[]{Flag.IGNORE_RETURN_VALUES});
                    if (nodes.isEmpty()) {
                        cache.remove(service);
                    } else {
                        cache.replace(service, (Object)nodes);
                    }
                }
            }
            finally {
                ExecutorService executor;
                Map.Entry oldEntry = (Map.Entry)this.listeners.remove(service);
                if (oldEntry != null && (executor = (ExecutorService)oldEntry.getValue()) != null) {
                    PrivilegedAction<List> action = () -> executor.shutdownNow();
                    WildFlySecurityManager.doUnchecked(action);
                    try {
                        executor.awaitTermination(this.cache.getCacheConfiguration().transaction().cacheStopTimeout(), TimeUnit.MILLISECONDS);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                }
            }
        });
    }

    void register(Node node, T service) {
        Set nodes = (Set)this.cache.getAdvancedCache().withFlags(new Flag[]{Flag.FORCE_SYNCHRONOUS, Flag.FORCE_WRITE_LOCK}).computeIfAbsent(service, key -> new CopyOnWriteArraySet<Node>(Collections.singleton(node)));
        if (nodes.add(node)) {
            this.cache.getAdvancedCache().withFlags(new Flag[]{Flag.IGNORE_RETURN_VALUES}).replace(service, (Object)nodes);
        }
    }

    public Set<Node> getProviders(T service) {
        Set nodes = (Set)this.cache.get(service);
        return nodes != null ? Collections.unmodifiableSet(nodes) : Collections.emptySet();
    }

    public Set<T> getServices() {
        return this.cache.keySet();
    }

    public void membershipChanged(List<Node> previousMembers, List<Node> members, boolean merged) {
        if (this.getGroup().isCoordinator()) {
            HashSet<Node> deadNodes = new HashSet<Node>(previousMembers);
            deadNodes.removeAll(members);
            HashSet<Node> newNodes = new HashSet<Node>(members);
            newNodes.removeAll(previousMembers);
            if (!deadNodes.isEmpty()) {
                try (Batch batch = this.batcher.createBatch();
                     CloseableIterator entries = this.cache.entrySet().iterator();){
                    while (entries.hasNext()) {
                        Map.Entry entry = (Map.Entry)entries.next();
                        Set nodes = (Set)entry.getValue();
                        if (!nodes.removeAll(deadNodes)) continue;
                        entry.setValue(nodes);
                    }
                }
            }
            if (merged) {
                for (Node node : newNodes) {
                    try {
                        Collection services = (Collection)this.dispatcher.executeOnNode(new GetLocalServicesCommand(), node).get();
                        Batch batch = this.batcher.createBatch();
                        Throwable throwable = null;
                        try {
                            services.forEach(service -> this.register(node, service));
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            if (batch == null) continue;
                            if (throwable != null) {
                                try {
                                    batch.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                                continue;
                            }
                            batch.close();
                        }
                    }
                    catch (Exception e) {
                        ClusteringServerLogger.ROOT_LOGGER.warn(e.getLocalizedMessage(), e);
                    }
                }
            }
        }
    }

    @CacheEntryCreated
    @CacheEntryModified
    public void modified(CacheEntryEvent<T, Set<Node>> event) {
        ServiceProviderRegistration.Listener listener;
        if (event.isPre()) {
            return;
        }
        Map.Entry entry = (Map.Entry)this.listeners.get(event.getKey());
        if (entry != null && (listener = (ServiceProviderRegistration.Listener)entry.getKey()) != null) {
            ExecutorService executor = (ExecutorService)entry.getValue();
            try {
                executor.submit(() -> {
                    try {
                        listener.providersChanged((Set)event.getValue());
                    }
                    catch (Throwable e) {
                        ClusteringServerLogger.ROOT_LOGGER.serviceProviderRegistrationListenerFailed(e, this.cache.getCacheManager().getCacheManagerConfiguration().globalJmxStatistics().cacheManagerName(), this.cache.getName(), (Set)event.getValue());
                    }
                });
            }
            catch (RejectedExecutionException rejectedExecutionException) {
                // empty catch block
            }
        }
    }
}

