/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.blocks;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.NotSerializableException;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import org.jgroups.Address;
import org.jgroups.AnycastAddress;
import org.jgroups.Event;
import org.jgroups.Message;
import org.jgroups.View;
import org.jgroups.blocks.AsyncRequestHandler;
import org.jgroups.blocks.GroupRequest;
import org.jgroups.blocks.Request;
import org.jgroups.blocks.RequestHandler;
import org.jgroups.blocks.RequestOptions;
import org.jgroups.blocks.Response;
import org.jgroups.blocks.RpcDispatcher;
import org.jgroups.blocks.UnicastRequest;
import org.jgroups.conf.ClassConfigurator;
import org.jgroups.logging.Log;
import org.jgroups.logging.LogFactory;
import org.jgroups.protocols.TP;
import org.jgroups.protocols.relay.SiteMaster;
import org.jgroups.stack.DiagnosticsHandler;
import org.jgroups.stack.Protocol;
import org.jgroups.util.Bits;
import org.jgroups.util.Buffer;
import org.jgroups.util.MessageBatch;
import org.jgroups.util.RpcStats;
import org.jgroups.util.Util;

public class RequestCorrelator {
    protected Protocol transport;
    protected final ConcurrentMap<Long, Request> requests = Util.createConcurrentMap();
    protected static final AtomicLong REQUEST_ID = new AtomicLong(1L);
    protected RequestHandler request_handler;
    protected RpcDispatcher.Marshaller marshaller;
    protected short corr_id = ClassConfigurator.getProtocolId(this.getClass());
    protected Address local_addr;
    protected volatile View view;
    protected boolean started;
    protected boolean async_dispatching;
    protected boolean wrap_exceptions = true;
    protected final MyProbeHandler probe_handler = new MyProbeHandler();
    protected final RpcStats rpc_stats = new RpcStats(false);
    protected static final Log log = LogFactory.getLog(RequestCorrelator.class);

    public RequestCorrelator(short corr_id, Protocol transport, RequestHandler handler, Address local_addr) {
        this.corr_id = corr_id;
        this.transport = transport;
        this.local_addr = local_addr;
        this.request_handler = handler;
        this.start();
    }

    public RequestCorrelator(Protocol transport, RequestHandler handler, Address local_addr) {
        this.transport = transport;
        this.local_addr = local_addr;
        this.request_handler = handler;
        this.start();
    }

    public void setRequestHandler(RequestHandler handler) {
        this.request_handler = handler;
        this.start();
    }

    public Address getLocalAddress() {
        return this.local_addr;
    }

    public void setLocalAddress(Address a) {
        this.local_addr = a;
    }

    public RpcDispatcher.Marshaller getMarshaller() {
        return this.marshaller;
    }

    public void setMarshaller(RpcDispatcher.Marshaller marshaller) {
        this.marshaller = marshaller;
    }

    public void sendRequest(List<Address> dest_mbrs, Message msg, Request req) throws Exception {
        this.sendRequest(dest_mbrs, msg, req, new RequestOptions().setAnycasting(false));
    }

    public boolean asyncDispatching() {
        return this.async_dispatching;
    }

    public RequestCorrelator asyncDispatching(boolean flag) {
        this.async_dispatching = flag;
        return this;
    }

    public boolean wrapExceptions() {
        return this.wrap_exceptions;
    }

    public RequestCorrelator wrapExceptions(boolean flag) {
        this.wrap_exceptions = flag;
        return this;
    }

    public void sendRequest(Collection<Address> dest_mbrs, Message msg, Request req, RequestOptions options) throws Exception {
        if (this.transport == null) {
            log.warn("transport is not available !");
            return;
        }
        Header hdr = options.hasExclusionList() ? new MultiDestinationHeader(0, 0L, this.corr_id, options.exclusionList()) : new Header(0, 0L, this.corr_id);
        msg.putHeader(this.corr_id, hdr);
        if (req != null) {
            long req_id = REQUEST_ID.getAndIncrement();
            req.requestId(req_id);
            hdr.requestId(req_id);
            if (log.isTraceEnabled()) {
                log.trace("%s: invoking multicast RPC [req-id=%d]", this.local_addr, req_id);
            }
            this.requests.putIfAbsent(req_id, req);
            req.viewChange(this.view);
            if (this.rpc_stats.extendedStats()) {
                req.start_time = System.nanoTime();
            }
        } else if (options != null && options.getAnycasting()) {
            this.rpc_stats.addAnycast(false, 0L, dest_mbrs);
        } else {
            this.rpc_stats.add(RpcStats.Type.MULTICAST, null, false, 0L);
        }
        if (options.getAnycasting()) {
            if (options.useAnycastAddresses()) {
                this.transport.down(new Event(1, msg.dest(new AnycastAddress(dest_mbrs))));
            } else {
                boolean first = true;
                for (Address mbr : dest_mbrs) {
                    Message copy = (first ? msg : msg.copy(true)).dest(mbr);
                    first = false;
                    if (!mbr.equals(this.local_addr) && copy.isTransientFlagSet(Message.TransientFlag.DONT_LOOPBACK)) {
                        copy.clearTransientFlag(Message.TransientFlag.DONT_LOOPBACK);
                    }
                    this.transport.down(new Event(1, copy));
                }
            }
        } else {
            this.transport.down(new Event(1, msg));
        }
    }

    public void sendUnicastRequest(Address target, Message msg, Request req) throws Exception {
        if (this.transport == null) {
            if (log.isWarnEnabled()) {
                log.warn("transport is not available !");
            }
            return;
        }
        Header hdr = new Header(0, 0L, this.corr_id);
        msg.putHeader(this.corr_id, hdr);
        if (req != null) {
            long req_id = REQUEST_ID.getAndIncrement();
            req.requestId(req_id);
            hdr.requestId(req_id);
            if (log.isTraceEnabled()) {
                log.trace("%s: invoking unicast RPC [req-id=%d] on %s", this.local_addr, req_id, target);
            }
            this.requests.putIfAbsent(req_id, req);
            req.viewChange(this.view);
            if (this.rpc_stats.extendedStats()) {
                req.start_time = System.nanoTime();
            }
        } else {
            this.rpc_stats.add(RpcStats.Type.UNICAST, target, false, 0L);
        }
        this.transport.down(new Event(1, msg));
    }

    public void done(long id) {
        this.removeEntry(id);
    }

    public boolean receive(Event evt) {
        switch (evt.getType()) {
            case 9: {
                this.receiveSuspect((Address)evt.getArg());
                break;
            }
            case 6: {
                this.receiveView((View)evt.getArg());
                break;
            }
            case 8: {
                this.setLocalAddress((Address)evt.getArg());
                break;
            }
            case 1: {
                if (!this.receiveMessage((Message)evt.getArg())) break;
                return true;
            }
            case 104: {
                SiteMaster site_master = (SiteMaster)evt.getArg();
                String site = site_master.getSite();
                this.setSiteUnreachable(site);
            }
        }
        return false;
    }

    public final void start() {
        this.started = true;
    }

    public void stop() {
        this.started = false;
        for (Request req : this.requests.values()) {
            req.transportClosed();
        }
        this.requests.clear();
    }

    public void registerProbeHandler(TP transport) {
        if (transport != null) {
            transport.registerProbeHandler(this.probe_handler);
        }
    }

    public void unregisterProbeHandler(TP transport) {
        if (transport != null) {
            transport.unregisterProbeHandler(this.probe_handler);
        }
    }

    public void receiveSuspect(Address mbr) {
        if (mbr == null) {
            return;
        }
        log.debug("suspect=" + mbr);
        for (Request req : this.requests.values()) {
            if (req == null) continue;
            req.suspect(mbr);
        }
    }

    public void setSiteUnreachable(String site) {
        for (Request req : this.requests.values()) {
            if (req == null) continue;
            req.siteUnreachable(site);
        }
    }

    public void receiveView(View new_view) {
        this.view = new_view;
        for (Request req : this.requests.values()) {
            if (req == null) continue;
            req.viewChange(new_view);
        }
    }

    public boolean receiveMessage(Message msg) {
        Address[] exclusion_list;
        Header hdr = (Header)msg.getHeader(this.corr_id);
        if (hdr == null) {
            return false;
        }
        if (hdr.corrId != this.corr_id) {
            if (log.isTraceEnabled()) {
                log.trace(new StringBuilder("id of request correlator header (").append(hdr.corrId).append(") is different from ours (").append(this.corr_id).append("). Msg not accepted, passed up"));
            }
            return false;
        }
        if (hdr instanceof MultiDestinationHeader && (exclusion_list = ((MultiDestinationHeader)hdr).exclusion_list) != null && this.local_addr != null && Util.contains(this.local_addr, exclusion_list)) {
            if (log.isTraceEnabled()) {
                log.trace("%s: discarded request from %s as we are in the exclusion list, hdr=", this.local_addr, msg.getSrc(), hdr);
            }
            return true;
        }
        this.dispatch(msg, hdr);
        return true;
    }

    public void receiveMessageBatch(MessageBatch batch) {
        for (Message msg : batch) {
            Address[] exclusion_list;
            Header hdr = (Header)msg.getHeader(this.corr_id);
            if (hdr == null || hdr.corrId != this.corr_id) continue;
            if (hdr instanceof MultiDestinationHeader && (exclusion_list = ((MultiDestinationHeader)hdr).exclusion_list) != null && this.local_addr != null && Util.contains(this.local_addr, exclusion_list)) {
                log.trace("%s: dropped req from %s as we are in the exclusion list, hdr=%s", this.local_addr, msg.src(), hdr);
                batch.remove(msg);
                continue;
            }
            this.dispatch(msg, hdr);
        }
    }

    protected RequestCorrelator removeEntry(long id) {
        Request req = (Request)this.requests.remove(id);
        if (req != null) {
            long time_ns;
            long l = time_ns = req.start_time > 0L ? System.nanoTime() - req.start_time : 0L;
            if (req instanceof UnicastRequest) {
                this.rpc_stats.add(RpcStats.Type.UNICAST, ((UnicastRequest)req).target, true, time_ns);
            } else if (req instanceof GroupRequest) {
                if (req.options != null && req.options.getAnycasting()) {
                    this.rpc_stats.addAnycast(true, time_ns, ((GroupRequest)req).requests.keySet());
                } else {
                    this.rpc_stats.add(RpcStats.Type.MULTICAST, null, true, time_ns);
                }
            } else {
                log.error("request type %s not known", req != null ? req.getClass().getSimpleName() : req);
            }
        }
        return this;
    }

    protected void dispatch(Message msg, Header hdr) {
        switch (hdr.type) {
            case 0: {
                this.handleRequest(msg, hdr);
                break;
            }
            case 1: 
            case 2: {
                Object retval;
                Request req = (Request)this.requests.get(hdr.req_id);
                if (req == null) break;
                boolean is_exception = hdr.type == 2;
                Address sender = msg.getSrc();
                byte[] buf = msg.getRawBuffer();
                int offset = msg.getOffset();
                int length = msg.getLength();
                try {
                    retval = this.marshaller != null ? this.marshaller.objectFromBuffer(buf, offset, length) : Util.objectFromByteBuffer(buf, offset, length);
                }
                catch (Exception e) {
                    log.error(Util.getMessage("FailedUnmarshallingBufferIntoReturnValue"), e);
                    retval = e;
                    is_exception = true;
                }
                req.receiveResponse(retval, sender, is_exception);
                break;
            }
            default: {
                log.error(Util.getMessage("HeaderSTypeIsNeitherREQNorRSP"));
            }
        }
    }

    protected void handleRequest(Message req, Header hdr) {
        Object retval;
        boolean threw_exception = false;
        if (log.isTraceEnabled()) {
            log.trace("calling (%s) with request %d", this.request_handler != null ? this.request_handler.getClass().getName() : "null", hdr.req_id);
        }
        if (this.async_dispatching && this.request_handler instanceof AsyncRequestHandler) {
            ResponseImpl rsp = hdr.rspExpected() ? new ResponseImpl(req, hdr.req_id) : null;
            try {
                ((AsyncRequestHandler)this.request_handler).handle(req, rsp);
            }
            catch (Throwable t) {
                if (rsp != null) {
                    rsp.send(this.wrap_exceptions ? new InvocationTargetException(t) : t, true);
                }
                log.error("%s: failed dispatching request asynchronously: %s", this.local_addr, t);
            }
            return;
        }
        try {
            retval = this.request_handler.handle(req);
        }
        catch (Throwable t) {
            threw_exception = true;
            Object object = retval = this.wrap_exceptions ? new InvocationTargetException(t) : t;
        }
        if (hdr.rspExpected()) {
            this.sendReply(req, hdr.req_id, retval, threw_exception);
        }
    }

    protected void sendReply(Message req, long req_id, Object reply, boolean is_exception) {
        Buffer rsp_buf;
        try {
            rsp_buf = this.marshaller != null ? this.marshaller.objectToBuffer(reply) : Util.objectToBuffer(reply);
        }
        catch (Throwable t) {
            try {
                rsp_buf = this.marshaller != null ? this.marshaller.objectToBuffer(t) : Util.objectToBuffer(t);
                is_exception = true;
            }
            catch (NotSerializableException not_serializable) {
                if (log.isErrorEnabled()) {
                    log.error(Util.getMessage("FailedMarshallingRsp") + reply + "): not serializable");
                }
                return;
            }
            catch (Throwable tt) {
                if (log.isErrorEnabled()) {
                    log.error(Util.getMessage("FailedMarshallingRsp") + reply + "): " + tt);
                }
                return;
            }
        }
        Message rsp = req.makeReply().setFlag(req.getFlags()).setBuffer(rsp_buf).clearFlag(Message.Flag.RSVP, Message.Flag.SCOPED, Message.Flag.INTERNAL);
        this.sendResponse(rsp, req_id, is_exception);
    }

    protected void sendResponse(Message rsp, long req_id, boolean is_exception) {
        this.prepareResponse(rsp);
        Header rsp_hdr = new Header(is_exception ? (byte)2 : 1, req_id, this.corr_id);
        rsp.putHeader(this.corr_id, rsp_hdr);
        if (log.isTraceEnabled()) {
            log.trace("sending rsp for %d to %s", req_id, rsp.getDest());
        }
        this.transport.down(new Event(1, rsp));
    }

    protected void prepareResponse(Message rsp) {
    }

    protected class MyProbeHandler
    implements DiagnosticsHandler.ProbeHandler {
        protected MyProbeHandler() {
        }

        @Override
        public Map<String, String> handleProbe(String ... keys) {
            if (RequestCorrelator.this.requests == null) {
                return null;
            }
            HashMap<String, String> retval = new HashMap<String, String>();
            String[] stringArray = keys;
            int n = stringArray.length;
            block18: for (int i = 0; i < n; ++i) {
                String key;
                switch (key = stringArray[i]) {
                    case "requests": {
                        StringBuilder sb = new StringBuilder();
                        for (Map.Entry entry : RequestCorrelator.this.requests.entrySet()) {
                            sb.append(entry.getKey()).append(": ").append(entry.getValue()).append("\n");
                        }
                        retval.put(key, sb.toString());
                        continue block18;
                    }
                    case "reqtable-info": {
                        retval.put(key, String.format("size=%d, next-id=%d", RequestCorrelator.this.requests.size(), REQUEST_ID.get()));
                        continue block18;
                    }
                    case "rpcs": {
                        retval.put("sync  unicast   RPCs", String.valueOf(RequestCorrelator.this.rpc_stats.unicasts(true)));
                        retval.put("sync  multicast RPCs", String.valueOf(RequestCorrelator.this.rpc_stats.multicasts(true)));
                        retval.put("async unicast   RPCs", String.valueOf(RequestCorrelator.this.rpc_stats.unicasts(false)));
                        retval.put("async multicast RPCs", String.valueOf(RequestCorrelator.this.rpc_stats.multicasts(false)));
                        retval.put("sync  anycast   RPCs", String.valueOf(RequestCorrelator.this.rpc_stats.anycasts(true)));
                        retval.put("async anycast   RPCs", String.valueOf(RequestCorrelator.this.rpc_stats.anycasts(false)));
                        continue block18;
                    }
                    case "rpcs-reset": {
                        RequestCorrelator.this.rpc_stats.reset();
                        continue block18;
                    }
                    case "rpcs-enable-details": {
                        RequestCorrelator.this.rpc_stats.extendedStats(true);
                        continue block18;
                    }
                    case "rpcs-disable-details": {
                        RequestCorrelator.this.rpc_stats.extendedStats(false);
                        continue block18;
                    }
                    case "rpcs-details": {
                        if (!RequestCorrelator.this.rpc_stats.extendedStats()) {
                            retval.put(key, "<details not enabled: use rpcs-enable-details to enable>");
                            continue block18;
                        }
                        retval.put(key, RequestCorrelator.this.rpc_stats.printOrderByDest());
                    }
                }
            }
            return retval;
        }

        @Override
        public String[] supportedKeys() {
            return new String[]{"requests", "reqtable-info", "rpcs", "rpcs-reset", "rpcs-enable-details", "rpcs-disable-details", "rpcs-details"};
        }
    }

    public static final class MultiDestinationHeader
    extends Header {
        public Address[] exclusion_list;

        public MultiDestinationHeader() {
        }

        public MultiDestinationHeader(byte type, long id, short corr_id, Address[] exclusion_list) {
            super(type, id, corr_id);
            this.exclusion_list = exclusion_list;
        }

        @Override
        public void writeTo(DataOutput out) throws Exception {
            super.writeTo(out);
            Util.writeAddresses(this.exclusion_list, out);
        }

        @Override
        public void readFrom(DataInput in) throws Exception {
            super.readFrom(in);
            this.exclusion_list = Util.readAddresses(in);
        }

        @Override
        public int size() {
            return (int)((long)super.size() + Util.size(this.exclusion_list));
        }

        @Override
        public String toString() {
            String str = super.toString();
            if (this.exclusion_list != null) {
                str = str + ", exclusion_list=" + Arrays.toString(this.exclusion_list);
            }
            return str;
        }
    }

    public static class Header
    extends org.jgroups.Header {
        public static final byte REQ = 0;
        public static final byte RSP = 1;
        public static final byte EXC_RSP = 2;
        public byte type;
        public long req_id;
        public short corrId;

        public Header() {
        }

        public Header(byte type, long req_id, short corr_id) {
            this.type = type;
            this.req_id = req_id;
            this.corrId = corr_id;
        }

        public Header requestId(long req_id) {
            if (this.req_id > 0L) {
                throw new IllegalStateException(String.format("request-id (%d) is already set: trying to set it again (%d)", this.req_id, req_id));
            }
            this.req_id = req_id;
            return this;
        }

        public long requestId() {
            return this.req_id;
        }

        public boolean rspExpected() {
            return this.req_id > 0L;
        }

        public short corrId() {
            return this.corrId;
        }

        @Override
        public String toString() {
            StringBuilder ret = new StringBuilder();
            ret.append("corr_id=" + this.corrId + ", type=");
            switch (this.type) {
                case 0: {
                    ret.append("REQ");
                    break;
                }
                case 1: {
                    ret.append("RSP");
                    break;
                }
                case 2: {
                    ret.append("EXC_RSP");
                    break;
                }
                default: {
                    ret.append("<unknown>");
                }
            }
            ret.append(", req_id=" + this.req_id).append(", rsp_expected=" + this.rspExpected());
            return ret.toString();
        }

        @Override
        public void writeTo(DataOutput out) throws Exception {
            out.writeByte(this.type);
            Bits.writeLong(this.req_id, out);
            out.writeShort(this.corrId);
        }

        @Override
        public void readFrom(DataInput in) throws Exception {
            this.type = in.readByte();
            this.req_id = Bits.readLong(in);
            this.corrId = in.readShort();
        }

        @Override
        public int size() {
            return 1 + Bits.size(this.req_id) + 2;
        }
    }

    protected class ResponseImpl
    implements Response {
        protected final Message req;
        protected final long req_id;

        public ResponseImpl(Message req, long req_id) {
            this.req = req;
            this.req_id = req_id;
        }

        @Override
        public void send(Object reply, boolean is_exception) {
            RequestCorrelator.this.sendReply(this.req, this.req_id, reply, is_exception);
        }

        @Override
        public void send(Message reply, boolean is_exception) {
            RequestCorrelator.this.sendResponse(reply, this.req_id, is_exception);
        }
    }
}

