/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.elytron;

import org.jboss.as.controller.AbstractWriteAttributeHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceRegistry;
import org.wildfly.extension.elytron.BaseAddHandler;
import org.wildfly.extension.elytron.ElytronExtension;
import org.wildfly.extension.elytron.ElytronRemoveStepHandler;
import org.wildfly.extension.elytron.ElytronWriteAttributeHandler;
import org.wildfly.extension.elytron.SecurityPropertyService;

class SecurityPropertyResourceDefinition
extends SimpleResourceDefinition {
    static final SimpleAttributeDefinition VALUE = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("value", ModelType.STRING, false).setAllowExpression(true)).build();

    SecurityPropertyResourceDefinition() {
        super(PathElement.pathElement((String)"security-property"), (ResourceDescriptionResolver)ElytronExtension.getResourceDescriptionResolver("security-property"), (OperationStepHandler)new PropertyAddHandler(), (OperationStepHandler)new PropertyRemoveHandler());
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        resourceRegistration.registerReadWriteAttribute((AttributeDefinition)VALUE, null, (OperationStepHandler)new WriteAttributeHandler());
    }

    private static String getSimpleName(PathAddress resourceAddress) {
        for (int i = resourceAddress.size(); i > 0; --i) {
            PathElement element = resourceAddress.getElement(i - 1);
            if (!"security-property".equals(element.getKey())) continue;
            return element.getValue();
        }
        throw new IllegalStateException("Unable to identify name of resource.");
    }

    private static SecurityPropertyService getService(OperationContext context) {
        Service serviceImplementation;
        ServiceRegistry serviceRegistry = context.getServiceRegistry(true);
        ServiceController service = serviceRegistry.getService(SecurityPropertyService.SERVICE_NAME);
        if (service != null && (serviceImplementation = service.getService()) != null && serviceImplementation instanceof SecurityPropertyService) {
            return (SecurityPropertyService)serviceImplementation;
        }
        throw new IllegalStateException("Requires service not available or wrong type.");
    }

    private static void setProperty(OperationContext context, String name, String value) {
        SecurityPropertyResourceDefinition.getService(context).setProperty(name, value);
    }

    private static void removeProperty(OperationContext context, String name) {
        SecurityPropertyResourceDefinition.getService(context).removeProperty(name);
    }

    private static class PropertyRemoveHandler
    extends ElytronRemoveStepHandler {
        private PropertyRemoveHandler() {
        }

        protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
            String name = SecurityPropertyResourceDefinition.getSimpleName(context.getCurrentAddress());
            SecurityPropertyResourceDefinition.removeProperty(context, name);
        }

        protected void recoverServices(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
            String name = SecurityPropertyResourceDefinition.getSimpleName(context.getCurrentAddress());
            String value = VALUE.resolveModelAttribute(context, model).asString();
            SecurityPropertyResourceDefinition.setProperty(context, name, value);
        }
    }

    private static class PropertyAddHandler
    extends BaseAddHandler {
        private PropertyAddHandler() {
            super(new AttributeDefinition[]{VALUE});
        }

        protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
            String name = SecurityPropertyResourceDefinition.getSimpleName(context.getCurrentAddress());
            String value = VALUE.resolveModelAttribute(context, model).asString();
            SecurityPropertyResourceDefinition.setProperty(context, name, value);
        }

        protected void rollbackRuntime(OperationContext context, ModelNode operation, Resource resource) {
            String name = SecurityPropertyResourceDefinition.getSimpleName(context.getCurrentAddress());
            SecurityPropertyResourceDefinition.removeProperty(context, name);
        }
    }

    private static class WriteAttributeHandler
    extends ElytronWriteAttributeHandler<String> {
        private WriteAttributeHandler() {
            super(new AttributeDefinition[]{VALUE});
        }

        protected boolean applyUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode resolvedValue, ModelNode currentValue, AbstractWriteAttributeHandler.HandbackHolder<String> handbackHolder) throws OperationFailedException {
            String name = SecurityPropertyResourceDefinition.getSimpleName(context.getCurrentAddress());
            String value = currentValue.asString();
            SecurityPropertyResourceDefinition.setProperty(context, name, value);
            return false;
        }

        protected void revertUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode valueToRestore, ModelNode valueToRevert, String handback) throws OperationFailedException {
            String name = SecurityPropertyResourceDefinition.getSimpleName(context.getCurrentAddress());
            String value = valueToRestore.asString();
            SecurityPropertyResourceDefinition.setProperty(context, name, value);
        }
    }
}

