/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.infinispan.session.fine;

import java.util.Map;
import java.util.Set;
import org.infinispan.Cache;
import org.wildfly.clustering.marshalling.spi.InvalidSerializedFormException;
import org.wildfly.clustering.marshalling.spi.Marshaller;
import org.wildfly.clustering.web.infinispan.logging.InfinispanWebLogger;
import org.wildfly.clustering.web.infinispan.session.fine.SessionAttributeKey;
import org.wildfly.clustering.web.session.ImmutableSessionAttributes;

public class FineImmutableSessionAttributes<V>
implements ImmutableSessionAttributes {
    private final String id;
    private final Map<String, Integer> names;
    private final Cache<SessionAttributeKey, V> cache;
    private final Marshaller<Object, V> marshaller;

    public FineImmutableSessionAttributes(String id, Map<String, Integer> names, Cache<SessionAttributeKey, V> attributeCache, Marshaller<Object, V> marshaller) {
        this.id = id;
        this.names = names;
        this.cache = attributeCache;
        this.marshaller = marshaller;
    }

    public Set<String> getAttributeNames() {
        return this.names.keySet();
    }

    public Object getAttribute(String name) {
        Integer attributeId = this.names.get(name);
        return attributeId != null ? this.read(name, this.cache.get((Object)this.createKey(attributeId))) : null;
    }

    protected SessionAttributeKey createKey(int attributeId) {
        return new SessionAttributeKey(this.id, attributeId);
    }

    protected Object read(String name, V value) {
        try {
            return this.marshaller.read(value);
        }
        catch (InvalidSerializedFormException e) {
            throw InfinispanWebLogger.ROOT_LOGGER.failedToReadSessionAttribute(e, this.id, name);
        }
    }
}

