/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.metadata.resolver.impl;

import com.google.common.base.Strings;
import java.util.Collections;
import java.util.Iterator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.DestructableComponent;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import net.shibboleth.utilities.java.support.resolver.ResolverException;
import org.opensaml.core.criterion.EntityIdCriterion;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.saml.metadata.IterableMetadataSource;
import org.opensaml.saml.metadata.resolver.BatchMetadataResolver;
import org.opensaml.saml.metadata.resolver.filter.FilterException;
import org.opensaml.saml.metadata.resolver.impl.AbstractMetadataResolver;
import org.opensaml.saml.saml2.metadata.EntitiesDescriptor;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractBatchMetadataResolver
extends AbstractMetadataResolver
implements BatchMetadataResolver,
IterableMetadataSource {
    private final Logger log = LoggerFactory.getLogger(AbstractBatchMetadataResolver.class);
    private boolean cacheSourceMetadata;

    public AbstractBatchMetadataResolver() {
        this.setCacheSourceMetadata(true);
    }

    public Iterator<EntityDescriptor> iterator() {
        ComponentSupport.ifNotInitializedThrowUninitializedComponentException((InitializableComponent)this);
        return Collections.unmodifiableList(this.getBackingStore().getOrderedDescriptors()).iterator();
    }

    protected boolean isCacheSourceMetadata() {
        return this.cacheSourceMetadata;
    }

    protected void setCacheSourceMetadata(boolean flag) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        this.cacheSourceMetadata = flag;
    }

    @Nonnull
    public Iterable<EntityDescriptor> resolve(CriteriaSet criteria) throws ResolverException {
        ComponentSupport.ifNotInitializedThrowUninitializedComponentException((InitializableComponent)this);
        EntityIdCriterion entityIdCriterion = (EntityIdCriterion)criteria.get(EntityIdCriterion.class);
        if (entityIdCriterion == null || Strings.isNullOrEmpty((String)entityIdCriterion.getEntityId())) {
            throw new ResolverException("Entity Id was not supplied in criteria set");
        }
        return this.lookupEntityID(entityIdCriterion.getEntityId());
    }

    @Override
    @Nonnull
    protected BatchEntityBackingStore createNewBackingStore() {
        return new BatchEntityBackingStore();
    }

    @Override
    @Nonnull
    protected BatchEntityBackingStore getBackingStore() {
        return (BatchEntityBackingStore)super.getBackingStore();
    }

    @Override
    protected void initMetadataResolver() throws ComponentInitializationException {
        super.initMetadataResolver();
        this.setBackingStore(this.createNewBackingStore());
    }

    @Nullable
    protected XMLObject getCachedOriginalMetadata() {
        return this.getBackingStore().getCachedOriginalMetadata();
    }

    @Nullable
    protected XMLObject getCachedFilteredMetadata() {
        return this.getBackingStore().getCachedFilteredMetadata();
    }

    @Nonnull
    protected BatchEntityBackingStore preProcessNewMetadata(@Nonnull XMLObject root) throws FilterException {
        BatchEntityBackingStore newBackingStore = this.createNewBackingStore();
        XMLObject filteredMetadata = this.filterMetadata(root);
        if (this.isCacheSourceMetadata()) {
            newBackingStore.setCachedOriginalMetadata(root);
            newBackingStore.setCachedFilteredMetadata(filteredMetadata);
        }
        if (filteredMetadata == null) {
            this.log.info("Metadata filtering process produced a null document, resulting in an empty data set");
            return newBackingStore;
        }
        if (filteredMetadata instanceof EntityDescriptor) {
            this.preProcessEntityDescriptor((EntityDescriptor)filteredMetadata, newBackingStore);
        } else if (filteredMetadata instanceof EntitiesDescriptor) {
            this.preProcessEntitiesDescriptor((EntitiesDescriptor)filteredMetadata, newBackingStore);
        } else {
            this.log.warn("Document root was neither an EntityDescriptor nor an EntitiesDescriptor: {}", (Object)root.getClass().getName());
        }
        return newBackingStore;
    }

    protected class BatchEntityBackingStore
    extends AbstractMetadataResolver.EntityBackingStore {
        private XMLObject cachedOriginalMetadata;
        private XMLObject cachedFilteredMetadata;

        protected BatchEntityBackingStore() {
        }

        public XMLObject getCachedOriginalMetadata() {
            return this.cachedOriginalMetadata;
        }

        public void setCachedOriginalMetadata(XMLObject metadata) {
            this.cachedOriginalMetadata = metadata;
        }

        public XMLObject getCachedFilteredMetadata() {
            return this.cachedFilteredMetadata;
        }

        public void setCachedFilteredMetadata(XMLObject metadata) {
            this.cachedFilteredMetadata = metadata;
        }
    }
}

