/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.core.connectionmanager.pool;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionFactory;
import javax.security.auth.Subject;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.TransactionSynchronizationRegistry;
import org.jboss.jca.core.CoreBundle;
import org.jboss.jca.core.CoreLogger;
import org.jboss.jca.core.api.connectionmanager.pool.FlushMode;
import org.jboss.jca.core.api.connectionmanager.pool.PoolConfiguration;
import org.jboss.jca.core.api.connectionmanager.pool.PoolStatistics;
import org.jboss.jca.core.connectionmanager.ConnectionManager;
import org.jboss.jca.core.connectionmanager.TxConnectionManager;
import org.jboss.jca.core.connectionmanager.listener.ConnectionListener;
import org.jboss.jca.core.connectionmanager.pool.PoolStatisticsImpl;
import org.jboss.jca.core.connectionmanager.pool.SecurityActions;
import org.jboss.jca.core.connectionmanager.pool.api.Capacity;
import org.jboss.jca.core.connectionmanager.pool.api.Pool;
import org.jboss.jca.core.connectionmanager.pool.api.Semaphore;
import org.jboss.jca.core.connectionmanager.pool.capacity.DefaultCapacity;
import org.jboss.jca.core.connectionmanager.pool.capacity.TimedOutDecrementer;
import org.jboss.jca.core.connectionmanager.pool.mcp.ManagedConnectionPool;
import org.jboss.jca.core.connectionmanager.pool.mcp.ManagedConnectionPoolFactory;
import org.jboss.jca.core.connectionmanager.transaction.LockKey;
import org.jboss.jca.core.spi.transaction.TransactionIntegration;
import org.jboss.jca.core.tracer.Tracer;
import org.jboss.logging.Messages;

public abstract class AbstractPool
implements Pool {
    private static String newLine = SecurityActions.getSystemProperty("line.separator");
    protected final CoreLogger log;
    private static CoreBundle bundle = (CoreBundle)Messages.getBundle(CoreBundle.class);
    private final ConcurrentMap<Object, ManagedConnectionPool> mcpPools = new ConcurrentHashMap<Object, ManagedConnectionPool>();
    private final ManagedConnectionFactory mcf;
    private ConnectionManager cm;
    private final PoolConfiguration poolConfiguration;
    private final boolean noTxSeparatePools;
    private final AtomicBoolean shutdown = new AtomicBoolean(false);
    private String poolName;
    private PoolStatisticsImpl statistics;
    private Semaphore permits;
    private boolean sharable;
    private String mcpClass;
    private Capacity capacity;
    private boolean interleaving;
    private AtomicBoolean noLazyEnlistmentAvailable;

    protected AbstractPool(ManagedConnectionFactory mcf, PoolConfiguration pc, boolean noTxSeparatePools, boolean sharable, String mcp) {
        if (mcf == null) {
            throw new IllegalArgumentException("MCF is null");
        }
        if (pc == null) {
            throw new IllegalArgumentException("PoolConfiguration is null");
        }
        this.mcf = mcf;
        this.poolConfiguration = pc;
        this.noTxSeparatePools = noTxSeparatePools;
        this.sharable = sharable;
        this.mcpClass = mcp;
        this.log = this.getLogger();
        this.statistics = new PoolStatisticsImpl(pc.getMaxSize());
        this.permits = new Semaphore(pc.getMaxSize(), pc.isFair(), this.statistics);
        this.capacity = null;
        this.interleaving = false;
        this.noLazyEnlistmentAvailable = new AtomicBoolean(false);
    }

    @Override
    public void setName(String poolName) {
        this.poolName = poolName;
    }

    public String getName() {
        return this.poolName;
    }

    @Override
    public Semaphore getLock() {
        return this.permits;
    }

    @Override
    public boolean isSharable() {
        return this.sharable;
    }

    @Override
    public Capacity getCapacity() {
        if (this.capacity == null) {
            return DefaultCapacity.INSTANCE;
        }
        return this.capacity;
    }

    @Override
    public void setCapacity(Capacity c) {
        this.capacity = c;
    }

    @Override
    public boolean isFIFO() {
        return this.capacity != null && this.capacity.getDecrementer() != null && !TimedOutDecrementer.class.getName().equals(this.capacity.getDecrementer().getClass().getName());
    }

    @Override
    public boolean isInterleaving() {
        return this.interleaving;
    }

    @Override
    public void setInterleaving(boolean v) {
        this.interleaving = v;
    }

    @Override
    public boolean isIdle() {
        for (ManagedConnectionPool mcp : this.mcpPools.values()) {
            if (mcp.isIdle()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isFull() {
        return this.permits.availablePermits() == 0;
    }

    protected abstract Object getKey(Subject var1, ConnectionRequestInfo var2, boolean var3) throws ResourceException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ManagedConnectionPool getManagedConnectionPool(Object key, Subject subject, ConnectionRequestInfo cri) throws ResourceException {
        try {
            ManagedConnectionPool mcp = (ManagedConnectionPool)this.mcpPools.get(key);
            if (mcp == null) {
                AbstractPool abstractPool = this;
                synchronized (abstractPool) {
                    mcp = (ManagedConnectionPool)this.mcpPools.get(key);
                    if (mcp == null) {
                        ManagedConnectionPoolFactory mcpf = new ManagedConnectionPoolFactory();
                        ManagedConnectionPool newMcp = mcpf.create(this.mcpClass, this.mcf, this.cm, subject, cri, this.poolConfiguration, this);
                        mcp = this.mcpPools.putIfAbsent(key, newMcp);
                        if (mcp == null) {
                            mcp = newMcp;
                            if (Tracer.isEnabled()) {
                                Tracer.createManagedConnectionPool(this.getName(), mcp);
                            }
                            try {
                                this.initLock();
                            }
                            catch (Throwable throwable) {}
                        } else {
                            newMcp.shutdown();
                        }
                        this.log.tracef("%s: mcpPools=%s", this.getName(), this.mcpPools);
                    }
                }
            }
            return mcp;
        }
        catch (Throwable t) {
            throw new ResourceException(bundle.unableGetManagedConnectionPool(), t);
        }
    }

    protected TransactionIntegration getTransactionIntegration() {
        if (this.cm != null) {
            return this.cm.getTransactionIntegration();
        }
        return null;
    }

    protected TransactionManager getTransactionManager() {
        if (this.getTransactionIntegration() != null) {
            return this.getTransactionIntegration().getTransactionManager();
        }
        return null;
    }

    protected TransactionSynchronizationRegistry getTransactionSynchronizationRegistry() {
        if (this.getTransactionIntegration() != null) {
            return this.getTransactionIntegration().getTransactionSynchronizationRegistry();
        }
        return null;
    }

    private Lock initLock() {
        TransactionSynchronizationRegistry tsr = this.getTransactionSynchronizationRegistry();
        if (tsr != null) {
            return this.initLock(tsr);
        }
        return null;
    }

    private Lock initLock(TransactionSynchronizationRegistry tsr) {
        if (tsr.getTransactionKey() != null) {
            Lock lock = (Lock)tsr.getResource((Object)LockKey.INSTANCE);
            if (lock == null) {
                lock = new ReentrantLock(true);
                tsr.putResource((Object)LockKey.INSTANCE, (Object)lock);
                return lock;
            }
            return lock;
        }
        return null;
    }

    private Lock getTSRLock() {
        Lock result = null;
        try {
            TransactionSynchronizationRegistry tsr = this.getTransactionSynchronizationRegistry();
            if (tsr != null && tsr.getTransactionKey() != null && (result = (Lock)tsr.getResource((Object)LockKey.INSTANCE)) == null) {
                result = this.initLock(tsr);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return result;
    }

    @Override
    public void emptyManagedConnectionPool(ManagedConnectionPool pool) {
        this.log.debugf("%s: emptyManagedConnectionPool(%s)", this.poolName, pool);
        if (pool != null && this.mcpPools.size() > 1 && pool.isEmpty() && this.mcpPools.values().remove(pool)) {
            try {
                pool.shutdown();
            }
            catch (Exception e) {
                this.log.trace("MCP.shutdown: " + e.getMessage(), e);
            }
            if (Tracer.isEnabled()) {
                Tracer.destroyManagedConnectionPool(this.getName(), pool);
            }
            this.log.tracef("%s: mcpPools=%s", this.getName(), this.mcpPools);
        }
    }

    public void flush() {
        this.flush(FlushMode.IDLE);
    }

    public void flush(boolean kill) {
        if (!kill) {
            this.flush(FlushMode.IDLE);
        } else {
            this.flush(FlushMode.ALL);
        }
    }

    public synchronized void flush(FlushMode mode) {
        this.log.debugf("%s: flush(%s)", this.poolName, mode);
        HashSet<ManagedConnectionPool> clearMcpPools = new HashSet<ManagedConnectionPool>();
        int size = this.mcpPools.size();
        for (ManagedConnectionPool mcp : this.mcpPools.values()) {
            try {
                mcp.flush(mode);
            }
            catch (Exception e) {
                this.log.trace("MCP.flush: " + e.getMessage(), e);
            }
            if (!mcp.isEmpty() || this.isPrefill() || size <= 1) continue;
            clearMcpPools.add(mcp);
        }
        if (clearMcpPools.size() > 0) {
            for (ManagedConnectionPool mcp : clearMcpPools) {
                if (!mcp.isEmpty()) continue;
                try {
                    mcp.shutdown();
                }
                catch (Exception e) {
                    this.log.trace("MCP.shutdown: " + e.getMessage(), e);
                }
                if (Tracer.isEnabled()) {
                    Tracer.destroyManagedConnectionPool(this.getName(), mcp);
                }
                this.mcpPools.values().remove(mcp);
            }
            this.log.tracef("%s: mcpPools=%s", this.getName(), this.mcpPools);
        }
    }

    @Override
    public ConnectionListener getConnection(Transaction trackByTransaction, Subject subject, ConnectionRequestInfo cri) throws ResourceException {
        Object transactionKey;
        ConnectionListener cl = null;
        boolean separateNoTx = false;
        if (this.shutdown.get()) {
            throw new ResourceException(bundle.connectionManagerIsShutdown(this.poolName));
        }
        if (this.noTxSeparatePools) {
            separateNoTx = this.cm.isTransactional();
        }
        Object key = this.getKey(subject, cri, separateNoTx);
        ManagedConnectionPool mcp = this.getManagedConnectionPool(key, subject, cri);
        TransactionSynchronizationRegistry tsr = this.getTransactionSynchronizationRegistry();
        Object object = transactionKey = tsr != null ? tsr.getTransactionKey() : null;
        if (trackByTransaction == null || transactionKey == null) {
            return this.getSimpleConnection(subject, cri, mcp);
        }
        cl = this.getTransactionOldConnection(trackByTransaction, mcp);
        if (cl == null) {
            cl = this.getTransactionNewConnection(trackByTransaction, mcp, subject, cri);
        }
        return cl;
    }

    private ConnectionListener getSimpleConnection(Subject subject, ConnectionRequestInfo cri, ManagedConnectionPool mcp) throws ResourceException {
        ConnectionListener cl = mcp.getConnection(subject, cri);
        this.log.tracef("Got connection from pool: %s", cl);
        if (this.cm instanceof TxConnectionManager && this.cm.getCachedConnectionManager() == null && this.noLazyEnlistmentAvailable.compareAndSet(false, true)) {
            this.log.noLazyEnlistmentAvailable(this.poolName);
        }
        return cl;
    }

    ConnectionListener getTransactionOldConnection(Transaction trackByTransaction, ManagedConnectionPool mcp) throws ResourceException {
        TransactionSynchronizationRegistry tsr = this.getTransactionSynchronizationRegistry();
        Lock lock = this.getTSRLock();
        if (lock == null) {
            throw new ResourceException(bundle.unableObtainLock());
        }
        try {
            lock.lockInterruptibly();
        }
        catch (InterruptedException ie) {
            Thread.interrupted();
            throw new ResourceException(bundle.unableObtainLock(), (Throwable)ie);
        }
        try {
            ConnectionListener cl = (ConnectionListener)tsr.getResource((Object)mcp);
            if (cl != null) {
                this.log.tracef("Previous connection tracked by transaction=%s tx=%s", cl, trackByTransaction);
                ConnectionListener connectionListener = cl;
                return connectionListener;
            }
            ConnectionListener connectionListener = null;
            return connectionListener;
        }
        catch (Throwable t) {
            throw new ResourceException(bundle.unableGetConnectionListener(), t);
        }
        finally {
            lock.unlock();
        }
    }

    ConnectionListener getTransactionNewConnection(Transaction trackByTransaction, ManagedConnectionPool mcp, Subject subject, ConnectionRequestInfo cri) throws ResourceException {
        ConnectionListener cl = mcp.getConnection(subject, cri);
        this.log.tracef("Got connection from pool tracked by transaction=%s tx=%s", cl, trackByTransaction);
        if (this.cm.isEnlistment() && cl.supportsLazyEnlistment()) {
            this.log.tracef("Lazy enlistment connection from pool tracked by transaction=%s tx=%s", cl, trackByTransaction);
            return cl;
        }
        TransactionSynchronizationRegistry tsr = this.getTransactionSynchronizationRegistry();
        Lock lock = this.getTSRLock();
        if (lock == null) {
            if (cl != null) {
                this.log.tracef("Killing connection tracked by transaction=%s tx=%s", cl, trackByTransaction);
                this.returnConnection(cl, true);
            }
            throw new ResourceException(bundle.unableObtainLock());
        }
        try {
            lock.lockInterruptibly();
        }
        catch (InterruptedException ie) {
            Thread.interrupted();
            if (cl != null) {
                this.log.tracef("Killing connection tracked by transaction=%s tx=%s", cl, trackByTransaction);
                this.returnConnection(cl, true);
            }
            throw new ResourceException(bundle.unableObtainLock(), (Throwable)ie);
        }
        try {
            ConnectionListener other = (ConnectionListener)tsr.getResource((Object)mcp);
            if (other != null) {
                this.returnConnection(cl, false);
                this.log.tracef("Another thread already got a connection tracked by transaction=%s tx=%s", other, trackByTransaction);
                cl = other;
            }
            cl.setTrackByTx(true);
            tsr.putResource((Object)mcp, (Object)cl);
            this.log.tracef("Using connection from pool tracked by transaction=%s tx=%s", cl, trackByTransaction);
            ConnectionListener connectionListener = cl;
            return connectionListener;
        }
        catch (Throwable t) {
            if (cl != null) {
                this.log.tracef("Killing connection tracked by transaction=%s tx=%s", cl, trackByTransaction);
                this.returnConnection(cl, true);
            }
            throw new ResourceException(bundle.unableGetConnectionListener(), t);
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public ConnectionListener findConnectionListener(ManagedConnection mc) {
        return this.findConnectionListener(mc, null);
    }

    @Override
    public ConnectionListener findConnectionListener(ManagedConnection mc, Object connection) {
        for (ManagedConnectionPool mcp : this.mcpPools.values()) {
            ConnectionListener cl = mcp.findConnectionListener(mc, connection);
            if (cl == null) continue;
            return cl;
        }
        return null;
    }

    @Override
    public ManagedConnectionFactory getManagedConnectionFactory() {
        return this.mcf;
    }

    @Override
    public void returnConnection(ConnectionListener cl, boolean kill) throws ResourceException {
        cl.setTrackByTx(false);
        ManagedConnectionPool mcp = cl.getManagedConnectionPool();
        if (Tracer.isEnabled()) {
            if (kill && cl.getException() != null) {
                Tracer.exception(this.poolName, cl.getManagedConnectionPool(), cl, cl.getException());
            }
            Tracer.returnConnectionListener(this.poolName, cl.getManagedConnectionPool(), cl, kill, this.interleaving, Tracer.isRecordCallstacks() ? new Throwable("CALLSTACK") : null);
        }
        mcp.returnConnection(cl, kill);
        this.log.tracef("Returning connection to pool %s", cl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasConnection(Subject subject, ConnectionRequestInfo cri) {
        TransactionSynchronizationRegistry tsr = this.getTransactionSynchronizationRegistry();
        Lock lock = this.getTSRLock();
        if (lock == null) {
            return false;
        }
        try {
            lock.lockInterruptibly();
        }
        catch (InterruptedException ie) {
            Thread.interrupted();
            return false;
        }
        try {
            Object key;
            ManagedConnectionPool mcp;
            ConnectionListener cl;
            boolean separateNoTx = false;
            if (this.noTxSeparatePools) {
                separateNoTx = this.cm.isTransactional();
            }
            if ((cl = (ConnectionListener)tsr.getResource((Object)(mcp = this.getManagedConnectionPool(key = this.getKey(subject, cri, separateNoTx), subject, cri)))) != null) {
                boolean bl = true;
                return bl;
            }
        }
        catch (Throwable t) {
            this.log.debugf(t, "hasConnection error: %s", t.getMessage());
        }
        finally {
            lock.unlock();
        }
        return false;
    }

    protected ConnectionManager getConnectionManager() {
        return this.cm;
    }

    @Override
    public void setConnectionManager(ConnectionManager cm) {
        this.cm = cm;
    }

    @Override
    public boolean isShutdown() {
        return this.shutdown.get();
    }

    @Override
    public synchronized void shutdown() {
        this.log.debugf("%s: shutdown", this.poolName);
        this.shutdown.set(true);
        for (ManagedConnectionPool mcp : this.mcpPools.values()) {
            try {
                mcp.shutdown();
            }
            catch (Exception e) {
                this.log.tracef(e, "MCP.shutdown: %s", e.getMessage());
            }
            if (!Tracer.isEnabled()) continue;
            Tracer.destroyManagedConnectionPool(this.getName(), mcp);
        }
        this.mcpPools.clear();
    }

    @Override
    public void prepareShutdown() {
        this.log.debugf("%s: prepareShutdown", this.poolName);
        this.shutdown.set(true);
        this.flush(FlushMode.GRACEFULLY);
    }

    @Override
    public boolean cancelShutdown() {
        this.log.debugf("%s: cancelShutdown", this.poolName);
        if (this.shutdown.get()) {
            this.shutdown.set(false);
            if (this.isPrefill()) {
                for (ManagedConnectionPool mcp : this.mcpPools.values()) {
                    try {
                        mcp.prefill();
                    }
                    catch (Exception e) {
                        this.log.trace("MCP.prefill: " + e.getMessage(), e);
                    }
                }
            }
            return true;
        }
        return false;
    }

    public PoolStatistics getStatistics() {
        return this.statistics;
    }

    @Override
    public PoolStatisticsImpl getInternalStatistics() {
        return this.statistics;
    }

    public abstract boolean testConnection();

    public abstract boolean testConnection(ConnectionRequestInfo var1, Subject var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean internalTestConnection(ConnectionRequestInfo cri, Subject subject) {
        this.log.debugf("%s: testConnection(%s, %s) (%s)", new Object[]{this.poolName, cri, subject, Integer.toHexString(System.identityHashCode(subject))});
        this.log.debugf("%s:   Statistics=%s", this.poolName, this.statistics);
        boolean result = false;
        boolean kill = false;
        ConnectionListener cl = null;
        if (this.shutdown.get()) {
            return false;
        }
        if (this.isFull()) {
            return false;
        }
        try {
            boolean separateNoTx22 = false;
            if (this.noTxSeparatePools) {
                separateNoTx22 = this.cm.isTransactional();
            }
            Object key = this.getKey(subject, cri, separateNoTx22);
            ManagedConnectionPool mcp = this.getManagedConnectionPool(key, subject, cri);
            cl = mcp.getConnection(subject, cri);
            result = true;
            if (cl == null) return result;
        }
        catch (Throwable t) {
            try {
                kill = true;
                return result;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                if (cl != null) {
                    try {
                        this.returnConnection(cl, kill);
                    }
                    catch (ResourceException resourceException) {}
                }
            }
        }
        try {
            this.returnConnection(cl, kill);
            return result;
        }
        catch (ResourceException separateNoTx22) {
            return result;
        }
    }

    public String[] dumpQueuedThreads() {
        ArrayList<String> result = new ArrayList<String>();
        if (this.permits.hasQueuedThreads()) {
            ArrayList<Thread> queuedThreads = new ArrayList<Thread>(this.permits.getQueuedThreads());
            for (Thread t : queuedThreads) {
                result.add(this.dumpQueuedThread(t));
            }
        }
        return result.toArray(new String[result.size()]);
    }

    private String dumpQueuedThread(Thread t) {
        StringBuilder sb = new StringBuilder();
        sb = sb.append("Queued thread: ");
        sb = sb.append(t.getName());
        sb = sb.append(newLine);
        StackTraceElement[] stes = SecurityActions.getStackTrace(t);
        if (stes != null) {
            for (StackTraceElement ste : stes) {
                sb = sb.append("  ");
                sb = sb.append(ste.getClassName());
                sb = sb.append(":");
                sb = sb.append(ste.getMethodName());
                sb = sb.append(":");
                sb = sb.append(ste.getLineNumber());
                sb = sb.append(newLine);
            }
        }
        return sb.toString();
    }

    protected ConcurrentMap<Object, ManagedConnectionPool> getManagedConnectionPools() {
        return this.mcpPools;
    }

    protected PoolConfiguration getPoolConfiguration() {
        return this.poolConfiguration;
    }

    protected boolean isPrefill() {
        return false;
    }

    @Override
    public abstract CoreLogger getLogger();
}

