/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.undertow.session;

import java.util.Collection;
import java.util.LinkedList;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.function.Supplier;
import java.util.stream.StreamSupport;
import org.jboss.as.clustering.controller.CapabilityServiceBuilder;
import org.jboss.as.web.session.SessionIdentifierCodec;
import org.jboss.msc.service.ServiceName;
import org.wildfly.clustering.service.InjectedValueDependency;
import org.wildfly.clustering.service.ServiceNameProvider;
import org.wildfly.clustering.service.ValueDependency;
import org.wildfly.clustering.web.session.RouteLocatorBuilderProvider;
import org.wildfly.clustering.web.undertow.session.DistributableSessionIdentifierCodecBuilder;
import org.wildfly.clustering.web.undertow.session.RouteBuilder;
import org.wildfly.extension.undertow.session.SimpleSessionIdentifierCodecBuilder;

public class DistributableSessionIdentifierCodecBuilderProvider
implements org.wildfly.extension.undertow.session.DistributableSessionIdentifierCodecBuilderProvider {
    private static final Optional<RouteLocatorBuilderProvider> PROVIDER = StreamSupport.stream(ServiceLoader.load(RouteLocatorBuilderProvider.class, RouteLocatorBuilderProvider.class.getClassLoader()).spliterator(), false).findFirst();

    public CapabilityServiceBuilder<SessionIdentifierCodec> getDeploymentBuilder(ServiceName name, String serverName, String deploymentName) {
        Optional<CapabilityServiceBuilder> builder = PROVIDER.map(provider -> new DistributableSessionIdentifierCodecBuilder(name, serverName, deploymentName, (RouteLocatorBuilderProvider)provider));
        return builder.orElse((CapabilityServiceBuilder)new SimpleSessionIdentifierCodecBuilder(name, serverName));
    }

    public Collection<CapabilityServiceBuilder<?>> getServerBuilders(String serverName) {
        LinkedList builders = new LinkedList();
        RouteBuilder routeBuilder = new RouteBuilder(serverName);
        builders.add(routeBuilder);
        Supplier<ValueDependency> routeDependencyProvider = () -> new InjectedValueDependency((ServiceNameProvider)routeBuilder, String.class);
        PROVIDER.ifPresent(provider -> builders.addAll(provider.getRouteLocatorConfigurationBuilders(serverName, routeDependencyProvider)));
        return builders;
    }
}

