/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.http.server;

import io.undertow.io.IoCallback;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.ResponseCodeHandler;
import io.undertow.util.Headers;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import org.jboss.dmr.ModelNode;

public class Common {
    public static final ResponseCodeHandler MOVED_PERMANENTLY = new ResponseCodeHandler(301);
    public static final ResponseCodeHandler TEMPORARY_REDIRECT = new ResponseCodeHandler(307);
    public static final ResponseCodeHandler UNAUTHORIZED = new ResponseCodeHandler(403);
    public static final ResponseCodeHandler NOT_FOUND = ResponseCodeHandler.HANDLE_404;
    public static final ResponseCodeHandler METHOD_NOT_ALLOWED_HANDLER = new ResponseCodeHandler(405);
    public static final ResponseCodeHandler UNSUPPORTED_MEDIA_TYPE = new ResponseCodeHandler(415);
    public static final ResponseCodeHandler INTERNAL_SERVER_ERROR = new ResponseCodeHandler(500);
    public static final ResponseCodeHandler SERVICE_UNAVAIABLE = new ResponseCodeHandler(503);
    static final String APPLICATION_DMR_ENCODED = "application/dmr-encoded";
    static final String APPLICATION_JSON = "application/json";
    static final String TEXT_PLAIN = "text/plain";
    static final String TEXT_HTML = "text/html";
    static final int ONE_WEEK = 604800;
    static final String UTF_8 = "utf-8";

    static void sendError(HttpServerExchange exchange, boolean encode, String msg) {
        int errorCode = Common.getErrorResponseCode(msg);
        Common.sendError(exchange, encode, new ModelNode(msg == null ? "" : msg), errorCode);
    }

    static void sendError(HttpServerExchange exchange, boolean encode, ModelNode msg) {
        int errorCode = Common.getErrorResponseCode(msg.asString());
        Common.sendError(exchange, encode, msg, errorCode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void sendError(HttpServerExchange exchange, boolean encode, ModelNode msg, int errorCode) {
        if (encode) {
            try {
                ModelNode response = new ModelNode();
                response.set(msg);
                ByteArrayOutputStream bout = new ByteArrayOutputStream();
                response.writeBase64((OutputStream)bout);
                byte[] bytes = bout.toByteArray();
                exchange.getResponseHeaders().put(Headers.CONTENT_TYPE, "application/dmr-encoded; charset=utf-8");
                exchange.getResponseHeaders().put(Headers.CONTENT_LENGTH, String.valueOf(bytes.length));
                exchange.setStatusCode(errorCode);
                exchange.getResponseSender().send(new String(bytes, StandardCharsets.UTF_8), IoCallback.END_EXCHANGE);
            }
            catch (IOException e) {
                Common.sendError(exchange, false, msg);
            }
        } else {
            StringWriter stringWriter = new StringWriter();
            PrintWriter print = new PrintWriter(stringWriter);
            try {
                msg.writeJSONString(print, false);
            }
            finally {
                print.flush();
                stringWriter.flush();
                print.close();
            }
            String msgString = stringWriter.toString();
            byte[] bytes = msgString.getBytes(StandardCharsets.UTF_8);
            exchange.getResponseHeaders().put(Headers.CONTENT_TYPE, "application/json; charset=utf-8");
            exchange.getResponseHeaders().put(Headers.CONTENT_LENGTH, String.valueOf(bytes.length));
            exchange.setStatusCode(errorCode);
            exchange.getResponseSender().send(msgString, IoCallback.END_EXCHANGE);
        }
    }

    private static int getErrorResponseCode(String failureMsg) {
        int result = 500;
        if (failureMsg != null && failureMsg.contains("WFLYCTL0313")) {
            result = 403;
        }
        return result;
    }
}

