/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.client.helpers.domain.impl;

import java.io.Closeable;
import java.io.DataOutput;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import org.jboss.as.controller.client.helpers.domain.AddDeploymentPlanBuilder;
import org.jboss.as.controller.client.helpers.domain.DeployDeploymentPlanBuilder;
import org.jboss.as.controller.client.helpers.domain.DeploymentPlanBuilder;
import org.jboss.as.controller.client.helpers.domain.DuplicateDeploymentNameException;
import org.jboss.as.controller.client.helpers.domain.RemoveDeploymentPlanBuilder;
import org.jboss.as.controller.client.helpers.domain.ReplaceDeploymentPlanBuilder;
import org.jboss.as.controller.client.helpers.domain.ServerGroupDeploymentPlan;
import org.jboss.as.controller.client.helpers.domain.ServerGroupDeploymentPlanBuilder;
import org.jboss.as.controller.client.helpers.domain.UndeployDeploymentPlanBuilder;
import org.jboss.as.controller.client.helpers.domain.impl.AbstractDeploymentPlanBuilder;
import org.jboss.as.controller.client.helpers.domain.impl.AddDeploymentPlanBuilderImpl;
import org.jboss.as.controller.client.helpers.domain.impl.DeployDeploymentPlanBuilderImpl;
import org.jboss.as.controller.client.helpers.domain.impl.DeploymentActionImpl;
import org.jboss.as.controller.client.helpers.domain.impl.DeploymentContentDistributor;
import org.jboss.as.controller.client.helpers.domain.impl.DeploymentSetPlanImpl;
import org.jboss.as.controller.client.helpers.domain.impl.RemoveDeploymentPlanBuilderImpl;
import org.jboss.as.controller.client.helpers.domain.impl.ReplaceDeploymentPlanBuilderImpl;
import org.jboss.as.controller.client.helpers.domain.impl.ServerGroupDeploymentPlanBuilderImpl;
import org.jboss.as.controller.client.helpers.domain.impl.UndeployDeploymentPlanBuilderImpl;
import org.jboss.as.controller.client.impl.InputStreamEntry;
import org.jboss.as.controller.client.logging.ControllerClientLogger;
import org.jboss.as.protocol.StreamUtils;
import org.wildfly.common.Assert;

class DeploymentPlanBuilderImpl
extends AbstractDeploymentPlanBuilder
implements DeploymentPlanBuilder {
    private final DeploymentContentDistributor deploymentDistributor;

    DeploymentPlanBuilderImpl(DeploymentContentDistributor deploymentDistributor) {
        Assert.checkNotNullParam((String)"deploymentDistributor", (Object)deploymentDistributor);
        this.deploymentDistributor = deploymentDistributor;
    }

    DeploymentPlanBuilderImpl(DeploymentPlanBuilderImpl existing, boolean globalRollback) {
        super((AbstractDeploymentPlanBuilder)existing, globalRollback);
        this.deploymentDistributor = existing.deploymentDistributor;
    }

    DeploymentPlanBuilderImpl(DeploymentPlanBuilderImpl existing, DeploymentSetPlanImpl setPlan) {
        super((AbstractDeploymentPlanBuilder)existing, setPlan);
        this.deploymentDistributor = existing.deploymentDistributor;
    }

    @Override
    public AddDeploymentPlanBuilder add(File file) throws IOException, DuplicateDeploymentNameException {
        String name = file.getName();
        return this.add(name, file);
    }

    @Override
    public AddDeploymentPlanBuilder add(URL url) throws IOException, DuplicateDeploymentNameException {
        String name = DeploymentPlanBuilderImpl.getName(url);
        return this.add(name, name, url);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AddDeploymentPlanBuilder add(String name, File file) throws IOException, DuplicateDeploymentNameException {
        FileStreamEntry is = new FileStreamEntry(file);
        try {
            AddDeploymentPlanBuilder addDeploymentPlanBuilder = this.add(name, name, is);
            return addDeploymentPlanBuilder;
        }
        finally {
            try {
                ((InputStream)is).close();
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public AddDeploymentPlanBuilder add(String name, URL url) throws IOException, DuplicateDeploymentNameException {
        return this.add(name, name, url);
    }

    @Override
    public AddDeploymentPlanBuilder add(String name, InputStream stream) throws IOException, DuplicateDeploymentNameException {
        return this.add(name, name, stream);
    }

    @Override
    public AddDeploymentPlanBuilder add(String name, String commonName, InputStream stream) throws IOException, DuplicateDeploymentNameException {
        DeploymentSetPlanImpl currentSet = this.getCurrentDeploymentSetPlan();
        if (currentSet.hasServerGroupPlans()) {
            throw ControllerClientLogger.ROOT_LOGGER.cannotAddDeploymentAction();
        }
        byte[] hash = this.deploymentDistributor.distributeDeploymentContent(name, commonName, stream);
        DeploymentActionImpl mod = DeploymentActionImpl.getAddAction(name, commonName, hash);
        DeploymentSetPlanImpl newSet = currentSet.addAction(mod);
        return new AddDeploymentPlanBuilderImpl(this, newSet);
    }

    @Override
    public AddDeploymentPlanBuilder add(String name) throws IOException {
        DeploymentSetPlanImpl currentSet = this.getCurrentDeploymentSetPlan();
        if (currentSet.hasServerGroupPlans()) {
            throw ControllerClientLogger.ROOT_LOGGER.cannotAddDeploymentAction();
        }
        DeploymentActionImpl mod = DeploymentActionImpl.getAddAction(name, null, null);
        DeploymentSetPlanImpl newSet = currentSet.addAction(mod);
        return new AddDeploymentPlanBuilderImpl(this, newSet);
    }

    @Override
    public DeployDeploymentPlanBuilder deploy(String key) {
        DeploymentSetPlanImpl currentSet = this.getCurrentDeploymentSetPlan();
        if (currentSet.hasServerGroupPlans()) {
            throw ControllerClientLogger.ROOT_LOGGER.cannotAddDeploymentAction();
        }
        DeploymentActionImpl mod = DeploymentActionImpl.getDeployAction(key);
        DeploymentSetPlanImpl newSet = currentSet.addAction(mod);
        return new DeployDeploymentPlanBuilderImpl(this, newSet);
    }

    @Override
    public UndeployDeploymentPlanBuilder undeploy(String key) {
        DeploymentSetPlanImpl currentSet = this.getCurrentDeploymentSetPlan();
        if (currentSet.hasServerGroupPlans()) {
            throw ControllerClientLogger.ROOT_LOGGER.cannotAddDeploymentAction();
        }
        DeploymentActionImpl mod = DeploymentActionImpl.getUndeployAction(key);
        DeploymentSetPlanImpl newSet = currentSet.addAction(mod);
        return new UndeployDeploymentPlanBuilderImpl(this, newSet);
    }

    @Override
    public DeploymentPlanBuilder redeploy(String deploymentName) {
        DeploymentActionImpl mod = DeploymentActionImpl.getRedeployAction(deploymentName);
        return this.getNewBuilder(mod);
    }

    @Override
    public ReplaceDeploymentPlanBuilder replace(String replacement, String toReplace) {
        DeploymentSetPlanImpl currentSet = this.getCurrentDeploymentSetPlan();
        if (currentSet.hasServerGroupPlans()) {
            throw ControllerClientLogger.ROOT_LOGGER.cannotAddDeploymentAction();
        }
        DeploymentActionImpl mod = DeploymentActionImpl.getReplaceAction(replacement, toReplace);
        DeploymentSetPlanImpl newSet = currentSet.addAction(mod);
        return new ReplaceDeploymentPlanBuilderImpl(this, newSet);
    }

    @Override
    public RemoveDeploymentPlanBuilder replace(File file) throws IOException {
        String name = file.getName();
        return this.replace(name, file);
    }

    @Override
    public RemoveDeploymentPlanBuilder replace(URL url) throws IOException {
        String name = DeploymentPlanBuilderImpl.getName(url);
        return this.replace(name, name, url);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RemoveDeploymentPlanBuilder replace(String name, File file) throws IOException {
        FileStreamEntry is = new FileStreamEntry(file);
        try {
            RemoveDeploymentPlanBuilder removeDeploymentPlanBuilder = this.replace(name, name, is);
            return removeDeploymentPlanBuilder;
        }
        finally {
            try {
                ((InputStream)is).close();
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public RemoveDeploymentPlanBuilder replace(String name, URL url) throws IOException {
        return this.replace(name, name, url);
    }

    @Override
    public RemoveDeploymentPlanBuilder replace(String name, InputStream stream) throws IOException {
        return this.replace(name, name, stream);
    }

    @Override
    public RemoveDeploymentPlanBuilder replace(String name, String commonName, InputStream stream) throws IOException {
        DeploymentSetPlanImpl currentSet = this.getCurrentDeploymentSetPlan();
        if (currentSet.hasServerGroupPlans()) {
            throw ControllerClientLogger.ROOT_LOGGER.cannotAddDeploymentAction();
        }
        byte[] hash = this.deploymentDistributor.distributeReplacementDeploymentContent(name, commonName, stream);
        DeploymentActionImpl mod = DeploymentActionImpl.getFullReplaceAction(name, commonName, hash);
        DeploymentSetPlanImpl newSet = currentSet.addAction(mod);
        return new RemoveDeploymentPlanBuilderImpl(this, newSet);
    }

    @Override
    public RemoveDeploymentPlanBuilder remove(String key) {
        DeploymentSetPlanImpl currentSet = this.getCurrentDeploymentSetPlan();
        if (currentSet.hasServerGroupPlans()) {
            throw ControllerClientLogger.ROOT_LOGGER.cannotAddDeploymentAction();
        }
        DeploymentActionImpl mod = DeploymentActionImpl.getRemoveAction(key);
        DeploymentSetPlanImpl newSet = currentSet.addAction(mod);
        return new RemoveDeploymentPlanBuilderImpl(this, newSet);
    }

    ServerGroupDeploymentPlanBuilder toServerGroup(String serverGroupName) {
        DeploymentSetPlanImpl currentSet = this.getCurrentDeploymentSetPlan();
        DeploymentSetPlanImpl newSet = currentSet.storeServerGroup(new ServerGroupDeploymentPlan(serverGroupName));
        return new ServerGroupDeploymentPlanBuilderImpl(this, newSet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AddDeploymentPlanBuilder add(String name, String commonName, URL url) throws IOException, DuplicateDeploymentNameException {
        URLConnection conn = url.openConnection();
        conn.connect();
        InputStream stream = conn.getInputStream();
        try {
            AddDeploymentPlanBuilder addDeploymentPlanBuilder = this.add(name, commonName, stream);
            return addDeploymentPlanBuilder;
        }
        finally {
            try {
                stream.close();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RemoveDeploymentPlanBuilder replace(String name, String commonName, URL url) throws IOException {
        URLConnection conn = url.openConnection();
        conn.connect();
        InputStream stream = conn.getInputStream();
        try {
            RemoveDeploymentPlanBuilder removeDeploymentPlanBuilder = this.replace(name, commonName, stream);
            return removeDeploymentPlanBuilder;
        }
        finally {
            try {
                stream.close();
            }
            catch (Exception exception) {}
        }
    }

    DeploymentPlanBuilderImpl getNewBuilder(DeploymentActionImpl mod) {
        DeploymentSetPlanImpl currentSet = this.getCurrentDeploymentSetPlan();
        if (currentSet.hasServerGroupPlans()) {
            throw ControllerClientLogger.ROOT_LOGGER.cannotAddDeploymentAction();
        }
        DeploymentSetPlanImpl newSet = currentSet.addAction(mod);
        return new DeploymentPlanBuilderImpl(this, newSet);
    }

    private static String getName(URL url) {
        if ("file".equals(url.getProtocol())) {
            try {
                File f = new File(url.toURI());
                return f.getName();
            }
            catch (URISyntaxException e) {
                throw ControllerClientLogger.ROOT_LOGGER.invalidUri(e, url);
            }
        }
        String path = url.getPath();
        int idx = path.lastIndexOf(47);
        while (idx == path.length() - 1) {
            path = path.substring(0, idx);
            idx = path.lastIndexOf(47);
        }
        if (idx == -1) {
            throw ControllerClientLogger.ROOT_LOGGER.cannotDeriveDeploymentName(url);
        }
        return path.substring(idx + 1);
    }

    private static class FileStreamEntry
    extends FilterInputStream
    implements InputStreamEntry {
        private final File file;

        private FileStreamEntry(File file) throws IOException {
            super(new FileInputStream(file));
            this.file = file;
        }

        @Override
        public int initialize() throws IOException {
            return (int)this.file.length();
        }

        @Override
        public void copyStream(DataOutput output) throws IOException {
            FileInputStream is = new FileInputStream(this.file);
            try {
                StreamUtils.copyStream((InputStream)is, (DataOutput)output);
                is.close();
            }
            finally {
                StreamUtils.safeClose((Closeable)is);
            }
        }
    }
}

