/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.ejb.infinispan;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Base64;
import org.jboss.ejb.client.BasicSessionID;
import org.jboss.ejb.client.SessionID;
import org.jboss.ejb.client.UUIDSessionID;
import org.jboss.ejb.client.UnknownSessionID;
import org.wildfly.clustering.infinispan.spi.persistence.SimpleKeyFormat;
import org.wildfly.clustering.marshalling.Externalizer;
import org.wildfly.clustering.marshalling.spi.IndexExternalizer;

public class SessionIDExternalizer<T extends SessionID>
extends SimpleKeyFormat<T>
implements Externalizer<T> {
    public SessionIDExternalizer(Class<T> targetClass) {
        super(targetClass, value -> SessionID.createSessionID((byte[])Base64.getDecoder().decode((String)value)), id -> Base64.getEncoder().encodeToString(id.getEncodedForm()));
    }

    public void writeObject(ObjectOutput output, SessionID id) throws IOException {
        byte[] encoded = id.getEncodedForm();
        IndexExternalizer.UNSIGNED_BYTE.writeData((DataOutput)output, encoded.length);
        output.write(encoded);
    }

    public T readObject(ObjectInput input) throws IOException, ClassNotFoundException {
        byte[] encoded = new byte[IndexExternalizer.UNSIGNED_BYTE.readData((DataInput)input)];
        input.readFully(encoded);
        return (T)SessionID.createSessionID((byte[])encoded);
    }

    public static class UUIDSessionIDExternalizer
    extends SessionIDExternalizer<UUIDSessionID> {
        public UUIDSessionIDExternalizer() {
            super(UUIDSessionID.class);
        }
    }

    public static class UnknownSessionIDExternalizer
    extends SessionIDExternalizer<UnknownSessionID> {
        public UnknownSessionIDExternalizer() {
            super(UnknownSessionID.class);
        }
    }

    public static class BasicSessionIDExternalizer
    extends SessionIDExternalizer<BasicSessionID> {
        public BasicSessionIDExternalizer() {
            super(BasicSessionID.class);
        }
    }
}

