/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.subsystems.jca;

import java.util.Set;
import org.jboss.as.connector.deployers.ra.processors.CachedConnectionManagerSetupProcessor;
import org.jboss.as.connector.logging.ConnectorLogger;
import org.jboss.as.connector.services.jca.CachedConnectionManagerService;
import org.jboss.as.connector.services.jca.NonTxCachedConnectionManagerService;
import org.jboss.as.connector.subsystems.jca.JcaCachedConnectionManagerDefinition;
import org.jboss.as.connector.util.ConnectorServices;
import org.jboss.as.controller.AbstractBoottimeAddStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.server.AbstractDeploymentChainStep;
import org.jboss.as.server.DeploymentProcessorTarget;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.Phase;
import org.jboss.dmr.ModelNode;
import org.jboss.jca.core.spi.transaction.TransactionIntegration;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceTarget;

public class CachedConnectionManagerAdd
extends AbstractBoottimeAddStepHandler {
    public static final CachedConnectionManagerAdd INSTANCE = new CachedConnectionManagerAdd();

    protected Resource createResource(OperationContext context, ModelNode operation) {
        try {
            Resource existing = context.readResourceForUpdate(PathAddress.EMPTY_ADDRESS);
            ModelNode model = existing.getModel();
            boolean allDefault = true;
            for (JcaCachedConnectionManagerDefinition.CcmParameters param : JcaCachedConnectionManagerDefinition.CcmParameters.values()) {
                if (param == JcaCachedConnectionManagerDefinition.CcmParameters.INSTALL || param == JcaCachedConnectionManagerDefinition.CcmParameters.DEBUG || param == JcaCachedConnectionManagerDefinition.CcmParameters.ERROR || param == JcaCachedConnectionManagerDefinition.CcmParameters.IGNORE_UNKNOWN_CONNECTIONS) {
                    SimpleAttributeDefinition ad = param.getAttribute();
                    assert (!ad.isRequired()) : ad.getName();
                    if (!model.hasDefined(ad.getName())) continue;
                    allDefault = false;
                    break;
                }
                throw new IllegalStateException();
            }
            if (allDefault) {
                return existing;
            }
        }
        catch (Resource.NoSuchResourceException noSuchResourceException) {
            // empty catch block
        }
        return super.createResource(context, operation);
    }

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        for (JcaCachedConnectionManagerDefinition.CcmParameters parameter : JcaCachedConnectionManagerDefinition.CcmParameters.values()) {
            parameter.getAttribute().validateAndSet(operation, model);
        }
    }

    protected void recordCapabilitiesAndRequirements(OperationContext context, ModelNode operation, Resource resource) throws OperationFailedException {
        Set capabilitySet = context.getResourceRegistration().getCapabilities();
        assert (capabilitySet.isEmpty());
    }

    protected void performBoottime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        boolean debug = JcaCachedConnectionManagerDefinition.CcmParameters.DEBUG.getAttribute().resolveModelAttribute(context, model).asBoolean();
        boolean error = JcaCachedConnectionManagerDefinition.CcmParameters.ERROR.getAttribute().resolveModelAttribute(context, model).asBoolean();
        boolean ignoreUnknownConnections = JcaCachedConnectionManagerDefinition.CcmParameters.IGNORE_UNKNOWN_CONNECTIONS.getAttribute().resolveModelAttribute(context, model).asBoolean();
        boolean install = JcaCachedConnectionManagerDefinition.CcmParameters.INSTALL.getAttribute().resolveModelAttribute(context, model).asBoolean();
        ServiceTarget serviceTarget = context.getServiceTarget();
        if (install) {
            ConnectorLogger.ROOT_LOGGER.debug("Enabling the Cache Connection Manager valve and interceptor...");
            context.addStep((OperationStepHandler)new AbstractDeploymentChainStep(){

                protected void execute(DeploymentProcessorTarget processorTarget) {
                    processorTarget.addDeploymentProcessor("jca", Phase.POST_MODULE, 10752, (DeploymentUnitProcessor)new CachedConnectionManagerSetupProcessor());
                }
            }, OperationContext.Stage.RUNTIME);
        } else {
            ConnectorLogger.ROOT_LOGGER.debug("Disabling the Cache Connection Manager valve and interceptor...");
        }
        CachedConnectionManagerService ccmService = new CachedConnectionManagerService(debug, error, ignoreUnknownConnections);
        serviceTarget.addService(ConnectorServices.CCM_SERVICE, (Service)ccmService).addDependency(ConnectorServices.TRANSACTION_INTEGRATION_SERVICE, TransactionIntegration.class, ccmService.getTransactionIntegrationInjector()).install();
        NonTxCachedConnectionManagerService noTxCcm = new NonTxCachedConnectionManagerService(debug, error, ignoreUnknownConnections);
        serviceTarget.addService(ConnectorServices.NON_TX_CCM_SERVICE, (Service)noTxCcm).install();
    }
}

