//
// ========================================================================
// Copyright (c) 1995-2020 Mort Bay Consulting Pty Ltd and others.
//
// This program and the accompanying materials are made available under
// the terms of the Eclipse Public License 2.0 which is available at
// https://www.eclipse.org/legal/epl-2.0
//
// This Source Code may also be made available under the following
// Secondary Licenses when the conditions for such availability set
// forth in the Eclipse Public License, v. 2.0 are satisfied:
// the Apache License v2.0 which is available at
// https://www.apache.org/licenses/LICENSE-2.0
//
// SPDX-License-Identifier: EPL-2.0 OR Apache-2.0
// ========================================================================
//

package com.acme;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.StringTokenizer;
import javax.servlet.jsp.JspContext;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.JspFragment;
import javax.servlet.jsp.tagext.SimpleTagSupport;

public class Date2Tag extends SimpleTagSupport
{
    String format;

    public void setFormat(String value)
    {
        this.format = value;
    }

    @Override
    public void doTag() throws JspException, IOException
    {
        String formatted =
            new SimpleDateFormat("long".equals(format) ? "EEE 'the' d:MMM:yyyy" : "d:MM:yy")
                .format(new Date());
        StringTokenizer tok = new StringTokenizer(formatted, ":");
        JspContext context = getJspContext();
        context.setAttribute("day", tok.nextToken());
        context.setAttribute("month", tok.nextToken());
        context.setAttribute("year", tok.nextToken());

        JspFragment fragment = getJspBody();
        fragment.invoke(null);
    }
}

