/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.spdy;

import java.util.concurrent.CancellationException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.eclipse.jetty.spdy.api.Handler;

public class Promise<T>
implements Handler<T>,
Future<T> {
    private final CountDownLatch latch = new CountDownLatch(1);
    private boolean cancelled;
    private Throwable failure;
    private T promise;

    @Override
    public void completed(T result) {
        this.promise = result;
        this.latch.countDown();
    }

    @Override
    public void failed(T context, Throwable x) {
        this.failure = x;
        this.latch.countDown();
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        this.cancelled = true;
        this.latch.countDown();
        return true;
    }

    @Override
    public boolean isCancelled() {
        return this.cancelled;
    }

    @Override
    public boolean isDone() {
        return this.cancelled || this.latch.getCount() == 0L;
    }

    @Override
    public T get() throws InterruptedException, ExecutionException {
        this.latch.await();
        return this.result();
    }

    @Override
    public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        boolean elapsed;
        boolean bl = elapsed = !this.latch.await(timeout, unit);
        if (elapsed) {
            throw new TimeoutException();
        }
        return this.result();
    }

    private T result() throws ExecutionException {
        if (this.isCancelled()) {
            throw new CancellationException();
        }
        Throwable failure = this.failure;
        if (failure != null) {
            throw new ExecutionException(failure);
        }
        return this.promise;
    }
}

