/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.start;

public class FileArg {
    public String uri;
    public String location;

    public FileArg(String uriLocation) {
        String[] parts = uriLocation.split(":", 3);
        if (parts.length == 3) {
            if (!"http".equalsIgnoreCase(parts[0])) {
                throw new IllegalArgumentException("Download only supports http protocol");
            }
            if (!parts[1].startsWith("//")) {
                throw new IllegalArgumentException("Download URI invalid: " + uriLocation);
            }
            this.uri = String.format("%s:%s", parts[0], parts[1]);
            this.location = parts[2];
        } else {
            this.uri = null;
            this.location = uriLocation;
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FileArg other = (FileArg)obj;
        if (this.uri == null ? other.uri != null : !this.uri.equals(other.uri)) {
            return false;
        }
        return !(this.location == null ? other.location != null : !this.location.equals(other.location));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.uri == null ? 0 : this.uri.hashCode());
        result = 31 * result + (this.location == null ? 0 : this.location.hashCode());
        return result;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("DownloadArg [uri=");
        builder.append(this.uri);
        builder.append(", location=");
        builder.append(this.location);
        builder.append("]");
        return builder.toString();
    }
}

