/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client.http;

import java.io.EOFException;
import java.nio.ByteBuffer;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.HttpExchange;
import org.eclipse.jetty.client.HttpReceiver;
import org.eclipse.jetty.client.HttpResponse;
import org.eclipse.jetty.client.HttpResponseException;
import org.eclipse.jetty.client.http.HttpChannelOverHTTP;
import org.eclipse.jetty.client.http.HttpConnectionOverHTTP;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.http.HttpParser;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.EofException;
import org.eclipse.jetty.util.BufferUtil;

public class HttpReceiverOverHTTP
extends HttpReceiver
implements HttpParser.ResponseHandler<ByteBuffer> {
    private final HttpParser parser = new HttpParser((HttpParser.ResponseHandler)this);
    private boolean shutdown;

    public HttpReceiverOverHTTP(HttpChannelOverHTTP channel) {
        super(channel);
    }

    @Override
    public HttpChannelOverHTTP getHttpChannel() {
        return (HttpChannelOverHTTP)super.getHttpChannel();
    }

    private HttpConnectionOverHTTP getHttpConnection() {
        return this.getHttpChannel().getHttpConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receive() {
        block12: {
            HttpConnectionOverHTTP connection = this.getHttpConnection();
            EndPoint endPoint = connection.getEndPoint();
            HttpClient client = this.getHttpDestination().getHttpClient();
            ByteBufferPool bufferPool = client.getByteBufferPool();
            ByteBuffer buffer = bufferPool.acquire(client.getResponseBufferSize(), true);
            try {
                int read;
                while (true) {
                    if (connection.isClosed()) {
                        LOG.debug("{} closed", new Object[]{connection});
                        break block12;
                    }
                    read = endPoint.fill(buffer);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Read {} bytes from {}", new Object[]{read, endPoint});
                    }
                    if (read <= 0) break;
                    this.parse(buffer);
                }
                if (read == 0) {
                    this.fillInterested();
                } else {
                    this.shutdown();
                }
            }
            catch (EofException x) {
                LOG.ignore((Throwable)x);
                this.failAndClose(x);
            }
            catch (Exception x) {
                LOG.debug((Throwable)x);
                this.failAndClose(x);
            }
            finally {
                bufferPool.release(buffer);
            }
        }
    }

    private void parse(ByteBuffer buffer) {
        while (buffer.hasRemaining()) {
            this.parser.parseNext(buffer);
        }
    }

    private void fillInterested() {
        this.getHttpChannel().getHttpConnection().fillInterested();
    }

    private void shutdown() {
        this.shutdown = true;
        this.parser.atEOF();
        this.parser.parseNext(BufferUtil.EMPTY_BUFFER);
    }

    protected boolean isShutdown() {
        return this.shutdown;
    }

    public int getHeaderCacheSize() {
        return 256;
    }

    public boolean startResponse(HttpVersion version, int status, String reason) {
        HttpExchange exchange = this.getHttpExchange();
        if (exchange == null) {
            return false;
        }
        String method = exchange.getRequest().getMethod();
        this.parser.setHeadResponse(HttpMethod.HEAD.is(method) || HttpMethod.CONNECT.is(method));
        exchange.getResponse().version(version).status(status).reason(reason);
        this.responseBegin(exchange);
        return false;
    }

    public boolean parsedHeader(HttpField field) {
        HttpExchange exchange = this.getHttpExchange();
        if (exchange == null) {
            return false;
        }
        this.responseHeader(exchange, field);
        return false;
    }

    public boolean headerComplete() {
        HttpExchange exchange = this.getHttpExchange();
        if (exchange == null) {
            return false;
        }
        this.responseHeaders(exchange);
        return false;
    }

    public boolean content(ByteBuffer buffer) {
        HttpExchange exchange = this.getHttpExchange();
        if (exchange == null) {
            return false;
        }
        this.responseContent(exchange, buffer);
        return false;
    }

    public boolean messageComplete() {
        HttpExchange exchange = this.getHttpExchange();
        if (exchange == null) {
            return false;
        }
        this.responseSuccess(exchange);
        return true;
    }

    public void earlyEOF() {
        HttpExchange exchange = this.getHttpExchange();
        if (exchange == null) {
            this.getHttpConnection().close();
        } else {
            this.failAndClose(new EOFException());
        }
    }

    public void badMessage(int status, String reason) {
        HttpExchange exchange = this.getHttpExchange();
        if (exchange != null) {
            HttpResponse response = exchange.getResponse();
            response.status(status).reason(reason);
            this.failAndClose(new HttpResponseException("HTTP protocol violation: bad response", response));
        }
    }

    @Override
    protected void reset() {
        super.reset();
        this.parser.reset();
    }

    @Override
    protected void dispose() {
        super.dispose();
        this.parser.close();
    }

    private void failAndClose(Throwable failure) {
        if (this.responseFailure(failure)) {
            this.getHttpConnection().close(failure);
        }
    }

    public String toString() {
        return String.format("%s@%x on %s", this.getClass().getSimpleName(), this.hashCode(), this.getHttpConnection());
    }
}

