/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.jsr356;

import java.net.URI;
import java.util.concurrent.atomic.AtomicLong;
import org.eclipse.jetty.websocket.common.LogicalConnection;
import org.eclipse.jetty.websocket.common.SessionFactory;
import org.eclipse.jetty.websocket.common.SessionListener;
import org.eclipse.jetty.websocket.common.WebSocketSession;
import org.eclipse.jetty.websocket.common.events.EventDriver;
import org.eclipse.jetty.websocket.jsr356.ClientContainer;
import org.eclipse.jetty.websocket.jsr356.JsrSession;
import org.eclipse.jetty.websocket.jsr356.endpoints.AbstractJsrEventDriver;

public class JsrSessionFactory
implements SessionFactory {
    private AtomicLong idgen = new AtomicLong(0L);
    private final ClientContainer container;
    private final SessionListener[] listeners;

    public JsrSessionFactory(ClientContainer container, SessionListener ... sessionListeners) {
        this.container = container;
        this.listeners = sessionListeners;
    }

    public WebSocketSession createSession(URI requestURI, EventDriver websocket, LogicalConnection connection) {
        return new JsrSession(requestURI, websocket, connection, this.container, this.getNextId(), this.listeners);
    }

    public String getNextId() {
        return String.format("websocket-%d", this.idgen.incrementAndGet());
    }

    public boolean supports(EventDriver websocket) {
        return websocket instanceof AbstractJsrEventDriver;
    }
}

