/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.fcgi.client.http;

import java.net.URI;
import java.util.Locale;
import org.eclipse.jetty.client.HttpChannel;
import org.eclipse.jetty.client.HttpContent;
import org.eclipse.jetty.client.HttpExchange;
import org.eclipse.jetty.client.HttpSender;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.fcgi.client.http.HttpChannelOverFCGI;
import org.eclipse.jetty.fcgi.client.http.HttpClientTransportOverFCGI;
import org.eclipse.jetty.fcgi.generator.ClientGenerator;
import org.eclipse.jetty.fcgi.generator.Generator;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.Jetty;

public class HttpSenderOverFCGI
extends HttpSender {
    private final ClientGenerator generator;

    public HttpSenderOverFCGI(HttpChannel channel) {
        super(channel);
        this.generator = new ClientGenerator(channel.getHttpDestination().getHttpClient().getByteBufferPool());
    }

    protected HttpChannelOverFCGI getHttpChannel() {
        return (HttpChannelOverFCGI)super.getHttpChannel();
    }

    protected void sendHeaders(HttpExchange exchange, HttpContent content, Callback callback) {
        Request request = exchange.getRequest();
        HttpFields headers = new HttpFields();
        for (HttpField field : request.getHeaders()) {
            headers.put(field);
        }
        HttpFields fcgiHeaders = new HttpFields();
        URI uri = request.getURI();
        String path = uri.getRawPath();
        fcgiHeaders.put("DOCUMENT_URI", path);
        String query = uri.getRawQuery();
        fcgiHeaders.put("QUERY_STRING", query == null ? "" : query);
        HttpField httpField = headers.remove(HttpHeader.AUTHORIZATION);
        if (httpField != null) {
            fcgiHeaders.put("AUTH_TYPE", httpField.getValue());
        }
        fcgiHeaders.put("CONTENT_LENGTH", (httpField = headers.remove(HttpHeader.CONTENT_LENGTH)) == null ? "" : httpField.getValue());
        httpField = headers.remove(HttpHeader.CONTENT_TYPE);
        fcgiHeaders.put("CONTENT_TYPE", httpField == null ? "" : httpField.getValue());
        fcgiHeaders.put("REQUEST_METHOD", request.getMethod());
        fcgiHeaders.put("SERVER_PROTOCOL", request.getVersion().asString());
        fcgiHeaders.put("GATEWAY_INTERFACE", "CGI/1.1");
        fcgiHeaders.put("SERVER_SOFTWARE", "Jetty/" + Jetty.VERSION);
        for (HttpField field : headers) {
            String name = field.getName();
            String fcgiName = "HTTP_" + name.replaceAll("-", "_").toUpperCase(Locale.ENGLISH);
            fcgiHeaders.add(fcgiName, field.getValue());
        }
        HttpClientTransportOverFCGI transport = (HttpClientTransportOverFCGI)this.getHttpChannel().getHttpDestination().getHttpClient().getTransport();
        transport.customize(request, fcgiHeaders);
        int id = this.getHttpChannel().getRequest();
        boolean hasContent = content.hasContent();
        Generator.Result headersResult = this.generator.generateRequestHeaders(id, fcgiHeaders, (Callback)(hasContent ? callback : new Callback.Adapter()));
        if (hasContent) {
            this.getHttpChannel().flush(headersResult);
        } else {
            Generator.Result noContentResult = this.generator.generateRequestContent(id, BufferUtil.EMPTY_BUFFER, true, callback);
            this.getHttpChannel().flush(headersResult, noContentResult);
        }
    }

    protected void sendContent(HttpExchange exchange, HttpContent content, Callback callback) {
        if (content.isConsumed()) {
            callback.succeeded();
        } else {
            int request = this.getHttpChannel().getRequest();
            Generator.Result result = this.generator.generateRequestContent(request, content.getByteBuffer(), content.isLast(), callback);
            this.getHttpChannel().flush(result);
        }
    }
}

