/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.start;

import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jetty.start.PropsException;
import org.eclipse.jetty.start.StartLog;

public final class Props
implements Iterable<Prop> {
    public static final String ORIGIN_SYSPROP = "<system-property>";
    private Map<String, Prop> props = new HashMap<String, Prop>();

    public String cleanReference(String property) {
        String name = property.trim();
        if (name.startsWith("${") && name.endsWith("}")) {
            name = name.substring(2, name.length() - 1);
        }
        return name.trim();
    }

    public boolean containsKey(String key) {
        return this.props.containsKey(key);
    }

    public String expand(String str) {
        return this.expand(str, new Stack<String>());
    }

    public String expand(String str, Stack<String> seenStack) {
        if (str == null) {
            return str;
        }
        if (str.indexOf("${") < 0) {
            return str;
        }
        if (this.props.isEmpty()) {
            return str;
        }
        Pattern pat = Pattern.compile("(?<=[^$]|^)(\\$\\{[^}]*\\})");
        Matcher mat = pat.matcher(str);
        StringBuilder expanded = new StringBuilder();
        int offset = 0;
        while (mat.find(offset)) {
            String property = this.cleanReference(mat.group(1));
            if (seenStack.contains(property)) {
                int idx;
                StringBuilder err = new StringBuilder();
                err.append("Property expansion loop detected: ");
                for (int i = idx = seenStack.lastIndexOf(property); i < seenStack.size(); ++i) {
                    err.append((String)seenStack.get(i));
                    err.append(" -> ");
                }
                err.append(property);
                throw new PropsException(err.toString());
            }
            seenStack.push(property);
            expanded.append(str.subSequence(offset, mat.start(1)));
            String value = this.getString(property);
            if (value == null) {
                StartLog.debug("Unable to expand: %s", property);
                expanded.append(property);
            } else {
                value = this.expand(value, seenStack);
                expanded.append(value);
            }
            offset = mat.end(1);
        }
        expanded.append(str.substring(offset));
        if (expanded.indexOf("$$") >= 0) {
            return expanded.toString().replaceAll("\\$\\$", "\\$");
        }
        return expanded.toString();
    }

    public Prop getProp(String key) {
        Prop prop = this.props.get(key);
        if (prop == null) {
            prop = this.getSystemProperty(key);
        }
        return prop;
    }

    public String getString(String key) {
        if (key == null) {
            throw new PropsException("Cannot get value for null key");
        }
        String name = this.cleanReference(key);
        if (name.length() == 0) {
            throw new PropsException("Cannot get value for empty key");
        }
        Prop prop = this.getProp(name);
        if (prop == null) {
            return null;
        }
        return prop.value;
    }

    public String getString(String key, String defVal) {
        String val = this.getString(key);
        if (val == null) {
            return defVal;
        }
        return val;
    }

    private Prop getSystemProperty(String key) {
        String value = System.getProperty(key);
        if (value == null) {
            return null;
        }
        return new Prop(key, value, ORIGIN_SYSPROP);
    }

    @Override
    public Iterator<Prop> iterator() {
        return this.props.values().iterator();
    }

    public void setProperty(Prop prop) {
        this.props.put(prop.key, prop);
    }

    public void setProperty(String key, String value, String origin) {
        Prop prop = this.props.get(key);
        prop = prop == null ? new Prop(key, value, origin) : new Prop(key, value, origin, prop);
        this.props.put(key, prop);
    }

    public int size() {
        return this.props.size();
    }

    public void store(OutputStream stream, String comments) throws IOException {
        Properties props = new Properties();
        for (Prop prop : this) {
            props.setProperty(prop.key, this.expand(prop.value));
        }
        props.store(stream, comments);
    }

    public static class Prop {
        public String key;
        public String value;
        public String origin;
        public Prop overrides;

        public Prop(String key, String value, String origin) {
            this.key = key;
            this.value = value;
            this.origin = origin;
        }

        public Prop(String key, String value, String origin, Prop overrides) {
            this(key, value, origin);
            this.overrides = overrides;
        }
    }
}

