/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http2.api;

import org.eclipse.jetty.http2.api.Session;
import org.eclipse.jetty.http2.frames.DataFrame;
import org.eclipse.jetty.http2.frames.HeadersFrame;
import org.eclipse.jetty.http2.frames.PushPromiseFrame;
import org.eclipse.jetty.http2.frames.ResetFrame;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.Promise;

public interface Stream {
    public int getId();

    public Session getSession();

    public void headers(HeadersFrame var1, Callback var2);

    public void push(PushPromiseFrame var1, Promise<Stream> var2, Listener var3);

    public void data(DataFrame var1, Callback var2);

    public void reset(ResetFrame var1, Callback var2);

    public Object getAttribute(String var1);

    public void setAttribute(String var1, Object var2);

    public Object removeAttribute(String var1);

    public boolean isReset();

    public boolean isClosed();

    public long getIdleTimeout();

    public void setIdleTimeout(long var1);

    public static interface Listener {
        public void onHeaders(Stream var1, HeadersFrame var2);

        public Listener onPush(Stream var1, PushPromiseFrame var2);

        public void onData(Stream var1, DataFrame var2, Callback var3);

        public void onReset(Stream var1, ResetFrame var2);

        @Deprecated
        default public void onTimeout(Stream stream, Throwable x) {
        }

        default public boolean onIdleTimeout(Stream stream, Throwable x) {
            this.onTimeout(stream, x);
            return true;
        }

        public static class Adapter
        implements Listener {
            @Override
            public void onHeaders(Stream stream, HeadersFrame frame) {
            }

            @Override
            public Listener onPush(Stream stream, PushPromiseFrame frame) {
                return null;
            }

            @Override
            public void onData(Stream stream, DataFrame frame, Callback callback) {
                callback.succeeded();
            }

            @Override
            public void onReset(Stream stream, ResetFrame frame) {
            }

            @Override
            public void onTimeout(Stream stream, Throwable x) {
            }

            @Override
            public boolean onIdleTimeout(Stream stream, Throwable x) {
                this.onTimeout(stream, x);
                return true;
            }
        }
    }
}

