/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client.dynamic;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.jetty.alpn.client.ALPNClientConnection;
import org.eclipse.jetty.alpn.client.ALPNClientConnectionFactory;
import org.eclipse.jetty.client.AbstractConnectorHttpClientTransport;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.HttpDestination;
import org.eclipse.jetty.client.HttpRequest;
import org.eclipse.jetty.client.MultiplexConnectionPool;
import org.eclipse.jetty.client.MultiplexHttpDestination;
import org.eclipse.jetty.client.Origin;
import org.eclipse.jetty.client.http.HttpClientConnectionFactory;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.io.ClientConnectionFactory;
import org.eclipse.jetty.io.ClientConnector;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.util.Callback;

public class HttpClientTransportDynamic
extends AbstractConnectorHttpClientTransport {
    private final List<ClientConnectionFactory.Info> factoryInfos;
    private final List<String> protocols;

    public HttpClientTransportDynamic() {
        this(new ClientConnector(), HttpClientConnectionFactory.HTTP11);
    }

    public HttpClientTransportDynamic(ClientConnector connector, ClientConnectionFactory.Info ... factoryInfos) {
        super(connector);
        this.addBean(connector);
        if (factoryInfos.length == 0) {
            factoryInfos = new ClientConnectionFactory.Info[]{HttpClientConnectionFactory.HTTP11};
        }
        this.factoryInfos = Arrays.asList(factoryInfos);
        this.protocols = Arrays.stream(factoryInfos).flatMap(info -> Stream.concat(info.getProtocols(false).stream(), info.getProtocols(true).stream())).distinct().map(p -> p.toLowerCase(Locale.ENGLISH)).collect(Collectors.toList());
        Arrays.stream(factoryInfos).forEach(arg_0 -> ((HttpClientTransportDynamic)this).addBean(arg_0));
        this.setConnectionPoolFactory(destination -> new MultiplexConnectionPool(destination, destination.getHttpClient().getMaxConnectionsPerDestination(), (Callback)destination, 1));
    }

    @Override
    public Origin newOrigin(HttpRequest request) {
        boolean secure = HttpClient.isSchemeSecure(request.getScheme());
        String http1 = "http/1.1";
        String http2 = secure ? "h2" : "h2c";
        List<Object> protocols = List.of();
        if (request.isVersionExplicit()) {
            String desired;
            HttpVersion version = request.getVersion();
            String string = desired = version == HttpVersion.HTTP_2 ? http2 : http1;
            if (this.protocols.contains(desired)) {
                protocols = List.of(desired);
            }
        } else if (secure) {
            List<String> http = List.of("http/1.1", "h2c", "h2");
            protocols = this.protocols.stream().filter(http::contains).collect(Collectors.toCollection(ArrayList::new));
            if (request.getHeaders().contains(HttpHeader.UPGRADE, "h2c")) {
                protocols.remove("h2");
            }
        } else {
            protocols = List.of(this.protocols.get(0));
        }
        Origin.Protocol protocol = null;
        if (!protocols.isEmpty()) {
            protocol = new Origin.Protocol(protocols, secure && protocols.contains(http2));
        }
        return this.getHttpClient().createOrigin(request, protocol);
    }

    @Override
    public HttpDestination newHttpDestination(Origin origin) {
        return new MultiplexHttpDestination(this.getHttpClient(), origin);
    }

    public Connection newConnection(EndPoint endPoint, Map<String, Object> context) throws IOException {
        HttpDestination destination = (HttpDestination)context.get("org.eclipse.jetty.client.destination");
        Origin.Protocol protocol = destination.getOrigin().getProtocol();
        Object factory = protocol == null ? this.factoryInfos.get(0).getClientConnectionFactory() : (destination.isSecure() && protocol.isNegotiate() ? new ALPNClientConnectionFactory(this.getClientConnector().getExecutor(), this::newNegotiatedConnection, protocol.getProtocols()) : this.findClientConnectionFactoryInfo(protocol.getProtocols(), destination.isSecure()).orElseThrow(() -> new IOException("Cannot find " + ClientConnectionFactory.class.getSimpleName() + " for " + protocol)).getClientConnectionFactory());
        return factory.newConnection(endPoint, context);
    }

    public void upgrade(EndPoint endPoint, Map<String, Object> context) {
        HttpDestination destination = (HttpDestination)context.get("org.eclipse.jetty.client.destination");
        Origin.Protocol protocol = destination.getOrigin().getProtocol();
        ClientConnectionFactory.Info info = this.findClientConnectionFactoryInfo(protocol.getProtocols(), destination.isSecure()).orElseThrow(() -> new IllegalStateException("Cannot find " + ClientConnectionFactory.class.getSimpleName() + " to upgrade to " + protocol));
        info.upgrade(endPoint, context);
    }

    protected Connection newNegotiatedConnection(EndPoint endPoint, Map<String, Object> context) throws IOException {
        try {
            ClientConnectionFactory.Info factoryInfo;
            ALPNClientConnection alpnConnection = (ALPNClientConnection)endPoint.getConnection();
            String protocol = alpnConnection.getProtocol();
            if (protocol != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("ALPN negotiated {} among {}", (Object)protocol, (Object)alpnConnection.getProtocols());
                }
                List<String> protocols = List.of(protocol);
                factoryInfo = this.findClientConnectionFactoryInfo(protocols, true).orElseThrow(() -> new IOException("Cannot find " + ClientConnectionFactory.class.getSimpleName() + " for negotiated protocol " + protocol));
            } else {
                factoryInfo = this.factoryInfos.get(0);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("No ALPN protocol, using {}", (Object)factoryInfo);
                }
            }
            return factoryInfo.getClientConnectionFactory().newConnection(endPoint, context);
        }
        catch (Throwable failure) {
            this.connectFailed(context, failure);
            throw failure;
        }
    }

    private Optional<ClientConnectionFactory.Info> findClientConnectionFactoryInfo(List<String> protocols, boolean secure) {
        return this.factoryInfos.stream().filter(info -> info.matches(protocols, secure)).findFirst();
    }
}

