/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.dispatcher;

import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.jboss.as.clustering.logging.ClusteringLogger;
import org.jboss.threads.JBossThreadFactory;
import org.jgroups.Address;
import org.jgroups.Channel;
import org.jgroups.MembershipListener;
import org.jgroups.MergeView;
import org.jgroups.Message;
import org.jgroups.View;
import org.jgroups.blocks.MessageDispatcher;
import org.jgroups.blocks.RequestCorrelator;
import org.jgroups.blocks.RequestHandler;
import org.jgroups.blocks.RpcDispatcher;
import org.jgroups.stack.Protocol;
import org.wildfly.clustering.dispatcher.CommandDispatcher;
import org.wildfly.clustering.dispatcher.CommandDispatcherFactory;
import org.wildfly.clustering.group.Group;
import org.wildfly.clustering.group.Node;
import org.wildfly.clustering.marshalling.jboss.MarshallingContext;
import org.wildfly.clustering.server.dispatcher.ChannelCommandDispatcher;
import org.wildfly.clustering.server.dispatcher.ChannelCommandDispatcherFactoryConfiguration;
import org.wildfly.clustering.server.dispatcher.CommandDispatcherMarshaller;
import org.wildfly.clustering.server.dispatcher.CommandResponseMarshaller;
import org.wildfly.clustering.server.dispatcher.LocalCommandDispatcher;
import org.wildfly.clustering.server.group.JGroupsNodeFactory;
import org.wildfly.clustering.service.concurrent.ClassLoaderThreadFactory;
import org.wildfly.clustering.service.concurrent.ServiceExecutor;
import org.wildfly.clustering.service.concurrent.StampedLockServiceExecutor;
import org.wildfly.security.manager.WildFlySecurityManager;

public class ChannelCommandDispatcherFactory
implements CommandDispatcherFactory,
RequestHandler,
AutoCloseable,
Group,
MembershipListener {
    private final Map<Object, Optional<Object>> contexts = new ConcurrentHashMap<Object, Optional<Object>>();
    private final ServiceExecutor executor = new StampedLockServiceExecutor();
    private final Map<Group.Listener, ExecutorService> listeners = new ConcurrentHashMap<Group.Listener, ExecutorService>();
    private final AtomicReference<View> view = new AtomicReference();
    private final JGroupsNodeFactory nodeFactory;
    private final MarshallingContext marshallingContext;
    private final MessageDispatcher dispatcher;
    private final long timeout;

    private static ThreadFactory createThreadFactory(Class<?> targetClass) {
        PrivilegedAction<ThreadFactory> action = () -> new JBossThreadFactory(new ThreadGroup(targetClass.getSimpleName()), Boolean.FALSE, null, "%G - %t", null, null);
        return new ClassLoaderThreadFactory((ThreadFactory)WildFlySecurityManager.doUnchecked(action), targetClass.getClassLoader());
    }

    public ChannelCommandDispatcherFactory(final ChannelCommandDispatcherFactoryConfiguration config) {
        this.nodeFactory = config.getNodeFactory();
        this.marshallingContext = config.getMarshallingContext();
        this.timeout = config.getTimeout();
        this.dispatcher = new MessageDispatcher(){

            protected RequestCorrelator createRequestCorrelator(Protocol transport, RequestHandler handler, Address localAddr) {
                RequestCorrelator correlator = super.createRequestCorrelator(transport, handler, localAddr);
                correlator.setMarshaller((RpcDispatcher.Marshaller)new CommandResponseMarshaller(config));
                return correlator;
            }
        };
        Channel channel = config.getChannel();
        this.dispatcher.setChannel(channel);
        this.dispatcher.setRequestHandler((RequestHandler)this);
        this.dispatcher.setMembershipListener((MembershipListener)this);
        this.dispatcher.asyncDispatching(true).start();
        this.view.compareAndSet(null, channel.getView());
    }

    @Override
    public void close() {
        this.executor.close(() -> {
            this.dispatcher.stop();
            this.dispatcher.getChannel().setUpHandler(null);
            this.listeners.values().forEach(executor -> {
                PrivilegedAction<List> action = () -> executor.shutdownNow();
                WildFlySecurityManager.doUnchecked(action);
            });
            this.listeners.clear();
        });
    }

    /*
     * Exception decompiling
     */
    public Object handle(Message message) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public Group getGroup() {
        return this;
    }

    public <C> CommandDispatcher<C> createCommandDispatcher(Object id, C context) {
        this.contexts.put(id, Optional.ofNullable(context));
        CommandDispatcherMarshaller marshaller = new CommandDispatcherMarshaller(this.marshallingContext, id);
        LocalCommandDispatcher localDispatcher = new LocalCommandDispatcher(this.getLocalNode(), context);
        return new ChannelCommandDispatcher(this.dispatcher, marshaller, this.nodeFactory, this.timeout, localDispatcher, () -> {
            localDispatcher.close();
            this.contexts.remove(id);
        });
    }

    public void addListener(Group.Listener listener) {
        this.listeners.computeIfAbsent(listener, key -> Executors.newSingleThreadExecutor(ChannelCommandDispatcherFactory.createThreadFactory(listener.getClass())));
    }

    public void removeListener(Group.Listener listener) {
        ExecutorService executor = this.listeners.remove(listener);
        if (executor != null) {
            executor.shutdownNow();
            try {
                executor.awaitTermination(this.timeout, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public String getName() {
        return this.dispatcher.getChannel().getClusterName();
    }

    public boolean isCoordinator() {
        return this.dispatcher.getChannel().getAddress().equals(this.getCoordinatorAddress());
    }

    public Node getLocalNode() {
        return this.nodeFactory.createNode(this.dispatcher.getChannel().getAddress());
    }

    public Node getCoordinatorNode() {
        return this.nodeFactory.createNode(this.getCoordinatorAddress());
    }

    public List<Node> getNodes() {
        return this.getNodes(this.view.get());
    }

    public boolean isLocal() {
        return false;
    }

    private Address getCoordinatorAddress() {
        List members = this.view.get().getMembers();
        return !members.isEmpty() ? (Address)members.get(0) : null;
    }

    private List<Node> getNodes(View view) {
        return view != null ? this.getNodes(view.getMembers()) : Collections.emptyList();
    }

    private List<Node> getNodes(List<Address> addresses) {
        ArrayList<Node> nodes = new ArrayList<Node>(addresses.size());
        for (Address address : addresses) {
            nodes.add(this.nodeFactory.createNode(address));
        }
        return nodes;
    }

    public void viewAccepted(View view) {
        View oldView = this.view.getAndSet(view);
        if (oldView != null) {
            List<Node> oldNodes = this.getNodes(oldView);
            List<Node> newNodes = this.getNodes(view);
            List leftMembers = View.leftMembers((View)oldView, (View)view);
            if (leftMembers != null) {
                this.nodeFactory.invalidate(leftMembers);
            }
            for (Map.Entry<Group.Listener, ExecutorService> entry : this.listeners.entrySet()) {
                try {
                    Group.Listener listener = entry.getKey();
                    ExecutorService executor = entry.getValue();
                    executor.submit(() -> {
                        try {
                            listener.membershipChanged(oldNodes, newNodes, view instanceof MergeView);
                        }
                        catch (Throwable e) {
                            ClusteringLogger.ROOT_LOGGER.warn((Object)e.getLocalizedMessage(), e);
                        }
                    });
                }
                catch (RejectedExecutionException rejectedExecutionException) {}
            }
        }
    }

    public void suspect(Address member) {
    }

    public void block() {
    }

    public void unblock() {
    }
}

