/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.registry;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.commons.CacheException;
import org.infinispan.context.Flag;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.filter.KeyFilter;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryCreated;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryModified;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryRemoved;
import org.infinispan.notifications.cachelistener.annotation.TopologyChanged;
import org.infinispan.notifications.cachelistener.event.CacheEntryEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryRemovedEvent;
import org.infinispan.notifications.cachelistener.event.Event;
import org.infinispan.notifications.cachelistener.event.TopologyChangedEvent;
import org.infinispan.remoting.transport.Address;
import org.jboss.as.clustering.logging.ClusteringLogger;
import org.jboss.threads.JBossThreadFactory;
import org.wildfly.clustering.ee.Batch;
import org.wildfly.clustering.ee.Batcher;
import org.wildfly.clustering.group.Group;
import org.wildfly.clustering.group.Node;
import org.wildfly.clustering.group.NodeFactory;
import org.wildfly.clustering.registry.Registry;
import org.wildfly.clustering.server.logging.ClusteringServerLogger;
import org.wildfly.clustering.server.registry.CacheRegistryConfiguration;
import org.wildfly.clustering.server.registry.CacheRegistryFilter;
import org.wildfly.clustering.service.concurrent.ClassLoaderThreadFactory;
import org.wildfly.security.manager.WildFlySecurityManager;

@Listener
public class CacheRegistry<K, V>
implements Registry<K, V>,
KeyFilter<Object> {
    private final ExecutorService topologyChangeExecutor = Executors.newSingleThreadExecutor(CacheRegistry.createThreadFactory(this.getClass()));
    private final Map<Registry.Listener<K, V>, ExecutorService> listeners = new ConcurrentHashMap<Registry.Listener<K, V>, ExecutorService>();
    private final Cache<Node, Map.Entry<K, V>> cache;
    private final Batcher<? extends Batch> batcher;
    private final Group group;
    private final NodeFactory<Address> factory;
    private final Runnable closeTask;
    private final Map.Entry<K, V> entry;

    private static ThreadFactory createThreadFactory(Class<?> targetClass) {
        PrivilegedAction<ThreadFactory> action = () -> new JBossThreadFactory(new ThreadGroup(targetClass.getSimpleName()), Boolean.FALSE, null, "%G - %t", null, null);
        return new ClassLoaderThreadFactory((ThreadFactory)WildFlySecurityManager.doUnchecked(action), AccessController.doPrivileged(() -> targetClass.getClassLoader()));
    }

    public CacheRegistry(CacheRegistryConfiguration<K, V> config, Map.Entry<K, V> entry, Runnable closeTask) {
        this.cache = config.getCache();
        this.batcher = config.getBatcher();
        this.group = config.getGroup();
        this.factory = config.getNodeFactory();
        this.closeTask = closeTask;
        this.entry = new AbstractMap.SimpleImmutableEntry<K, V>(entry);
        this.populateRegistry();
        this.cache.addListener((Object)this, (KeyFilter)new CacheRegistryFilter());
    }

    private void populateRegistry() {
        try (Batch batch = this.batcher.createBatch();){
            this.cache.getAdvancedCache().withFlags(new Flag[]{Flag.IGNORE_RETURN_VALUES}).put((Object)this.group.getLocalNode(), this.entry);
        }
    }

    public boolean accept(Object key) {
        return key instanceof Node;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        this.cache.removeListener((Object)this);
        this.shutdown(this.topologyChangeExecutor);
        Node node = this.getGroup().getLocalNode();
        try (Batch batch = this.batcher.createBatch();){
            this.cache.getAdvancedCache().withFlags(new Flag[]{Flag.IGNORE_RETURN_VALUES, Flag.FAIL_SILENTLY}).remove((Object)node);
        }
        catch (CacheException e) {
            ClusteringLogger.ROOT_LOGGER.warn((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        finally {
            this.listeners.values().forEach(executor -> this.shutdown((ExecutorService)executor));
            this.listeners.clear();
            this.closeTask.run();
        }
    }

    public void addListener(Registry.Listener<K, V> listener) {
        this.listeners.computeIfAbsent(listener, key -> Executors.newSingleThreadExecutor(CacheRegistry.createThreadFactory(listener.getClass())));
    }

    public void removeListener(Registry.Listener<K, V> listener) {
        ExecutorService executor = this.listeners.remove(listener);
        if (executor != null) {
            this.shutdown(executor);
        }
    }

    public Group getGroup() {
        return this.group;
    }

    public Map<K, V> getEntries() {
        Set nodes = this.group.getNodes().stream().collect(Collectors.toSet());
        try (Batch batch = this.batcher.createBatch();){
            Map<Object, Object> map = this.cache.getAdvancedCache().getAll(nodes).values().stream().collect(Collectors.toMap(entry -> entry.getKey(), entry -> entry.getValue()));
            return map;
        }
    }

    public Map.Entry<K, V> getEntry(Node node) {
        try (Batch batch = this.batcher.createBatch();){
            Map.Entry entry = (Map.Entry)this.cache.get((Object)node);
            return entry;
        }
    }

    @TopologyChanged
    public void topologyChanged(TopologyChangedEvent<Node, Map.Entry<K, V>> event) {
        if (event.isPre()) {
            return;
        }
        ConsistentHash previousHash = event.getConsistentHashAtStart();
        List previousMembers = previousHash.getMembers();
        ConsistentHash hash = event.getConsistentHashAtEnd();
        List members = hash.getMembers();
        Address localAddress = event.getCache().getCacheManager().getAddress();
        HashSet addresses = new HashSet(previousMembers);
        addresses.removeAll(members);
        try {
            this.topologyChangeExecutor.submit(() -> {
                if (!addresses.isEmpty()) {
                    List<Node> nodes = addresses.stream().filter(address -> hash.locatePrimaryOwner(address).equals(localAddress)).map(address -> this.factory.createNode(address)).collect(Collectors.toList());
                    if (!nodes.isEmpty()) {
                        AdvancedCache cache = this.cache.getAdvancedCache().withFlags(new Flag[]{Flag.FORCE_SYNCHRONOUS});
                        HashMap removed = new HashMap();
                        try (Batch batch = this.batcher.createBatch();){
                            for (Node node : nodes) {
                                Map.Entry old = (Map.Entry)cache.remove((Object)node);
                                if (old == null) continue;
                                removed.put(old.getKey(), old.getValue());
                            }
                        }
                        catch (CacheException e) {
                            ClusteringServerLogger.ROOT_LOGGER.registryPurgeFailed(e, this.cache.getCacheManager().toString(), this.cache.getName(), nodes);
                        }
                        if (!removed.isEmpty()) {
                            this.notifyListeners(Event.Type.CACHE_ENTRY_REMOVED, removed);
                        }
                    }
                } else if (!previousMembers.contains(localAddress)) {
                    try {
                        this.populateRegistry();
                        this.notifyListeners(Event.Type.CACHE_ENTRY_CREATED, this.entry);
                    }
                    catch (CacheException e) {
                        ClusteringServerLogger.ROOT_LOGGER.failedToRestoreLocalRegistryEntry(e, this.cache.getCacheManager().toString(), this.cache.getName());
                    }
                }
            });
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            // empty catch block
        }
    }

    @CacheEntryCreated
    @CacheEntryModified
    public void event(CacheEntryEvent<Node, Map.Entry<K, V>> event) {
        Map.Entry entry;
        if (event.isOriginLocal() || event.isPre()) {
            return;
        }
        if (!this.listeners.isEmpty() && (entry = (Map.Entry)event.getValue()) != null) {
            this.notifyListeners(event.getType(), entry);
        }
    }

    @CacheEntryRemoved
    public void removed(CacheEntryRemovedEvent<Node, Map.Entry<K, V>> event) {
        Map.Entry entry;
        if (event.isOriginLocal() || event.isPre()) {
            return;
        }
        if (!this.listeners.isEmpty() && (entry = (Map.Entry)event.getOldValue()) != null) {
            this.notifyListeners(event.getType(), entry);
        }
    }

    private void notifyListeners(Event.Type type, Map.Entry<K, V> entry) {
        this.notifyListeners(type, Collections.singletonMap(entry.getKey(), entry.getValue()));
    }

    private void notifyListeners(Event.Type type, Map<K, V> entries) {
        for (Map.Entry<Registry.Listener<K, V>, ExecutorService> entry : this.listeners.entrySet()) {
            Registry.Listener<K, V> listener = entry.getKey();
            ExecutorService executor = entry.getValue();
            try {
                executor.submit(() -> {
                    try {
                        switch (type) {
                            case CACHE_ENTRY_CREATED: {
                                listener.addedEntries(entries);
                                break;
                            }
                            case CACHE_ENTRY_MODIFIED: {
                                listener.updatedEntries(entries);
                                break;
                            }
                            case CACHE_ENTRY_REMOVED: {
                                listener.removedEntries(entries);
                                break;
                            }
                            default: {
                                throw new IllegalStateException(type.name());
                            }
                        }
                    }
                    catch (Throwable e) {
                        ClusteringServerLogger.ROOT_LOGGER.registryListenerFailed(e, this.cache.getCacheManager().getCacheManagerConfiguration().globalJmxStatistics().cacheManagerName(), this.cache.getName(), type, entries);
                    }
                });
            }
            catch (RejectedExecutionException rejectedExecutionException) {}
        }
    }

    private void shutdown(ExecutorService executor) {
        PrivilegedAction<List> action = () -> executor.shutdownNow();
        WildFlySecurityManager.doUnchecked(action);
        try {
            executor.awaitTermination(this.cache.getCacheConfiguration().transaction().cacheStopTimeout(), TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }
}

