/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.singleton;

import java.util.AbstractMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StopContext;
import org.wildfly.clustering.dispatcher.CommandDispatcherException;
import org.wildfly.clustering.dispatcher.CommandResponse;
import org.wildfly.clustering.group.Node;
import org.wildfly.clustering.server.logging.ClusteringServerLogger;
import org.wildfly.clustering.server.singleton.PrimaryProxyContext;
import org.wildfly.clustering.server.singleton.SingletonValueCommand;

public class PrimaryProxyService<T>
implements Service<T> {
    private final PrimaryProxyContext<T> context;
    private volatile boolean started = false;

    public PrimaryProxyService(PrimaryProxyContext<T> context) {
        this.context = context;
    }

    public T getValue() {
        if (!this.started) {
            throw ClusteringServerLogger.ROOT_LOGGER.notStarted(this.context.getServiceName().getCanonicalName());
        }
        try {
            Map responses = this.context.getCommandDispatcher().executeOnCluster(new SingletonValueCommand(), new Node[0]);
            List result = responses.entrySet().stream().map(entry -> {
                try {
                    return new AbstractMap.SimpleImmutableEntry(entry.getKey(), ((CommandResponse)entry.getValue()).get());
                }
                catch (ExecutionException e) {
                    throw new IllegalArgumentException(e);
                }
            }).filter(entry -> entry.getValue() != null).collect(Collectors.toList());
            if (result.size() > 1) {
                throw ClusteringServerLogger.ROOT_LOGGER.multiplePrimaryProvidersDetected(this.context.getServiceName().getCanonicalName(), result.stream().map(Map.Entry::getKey).collect(Collectors.toList()));
            }
            return ((Optional)((Map.Entry)result.stream().findFirst().orElseThrow(() -> ClusteringServerLogger.ROOT_LOGGER.noResponseFromMaster(this.context.getServiceName().getCanonicalName()))).getValue()).orElse(null);
        }
        catch (CommandDispatcherException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public void start(StartContext context) {
        this.started = true;
    }

    public void stop(StopContext context) {
        this.started = false;
    }
}

