/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.negotiation;

import java.lang.reflect.Method;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginException;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSName;
import org.jboss.logging.Logger;
import org.jboss.security.negotiation.Constants;
import org.jboss.security.negotiation.SecurityActions;

class GSSUtil {
    private static final Logger log = Logger.getLogger(GSSUtil.class);
    private static final Method CREATE_SUBJECT_METHOD = SecurityActions.getCreateSubjectMethod();

    GSSUtil() {
    }

    static Subject populateSubject(Subject subject, GSSCredential delegatedCredential, GSSCredential privateCredential) throws LoginException {
        Subject intermediateSubject = null;
        if (CREATE_SUBJECT_METHOD != null) {
            try {
                GSSName name = delegatedCredential.getName(Constants.KERBEROS_V5);
                intermediateSubject = SecurityActions.invokeCreateSubject(CREATE_SUBJECT_METHOD, name, delegatedCredential);
                log.trace((Object)"Delegated credential converted to Subject.");
                SecurityActions.copySubjectContents(intermediateSubject, subject);
                log.trace((Object)"Copied conents of temporary Subject to Subject from the LoginContext");
            }
            catch (GSSException e) {
                log.debug((Object)e);
                throw new LoginException("Unable to use supplied GSSCredential to populate Subject.");
            }
        } else if (privateCredential == null) {
            throw new LoginException("Utility not available to convert from GSSCredential and adding GSSCredential to Subject disabled - this would just result in an empty Subject!");
        }
        if (privateCredential != null) {
            log.trace((Object)"Also add the GSSCredential to the Subject");
            SecurityActions.addPrivateCredential(subject, privateCredential);
        }
        return intermediateSubject;
    }

    static void clearSubject(Subject subject, Subject intermediateSubject, GSSCredential credential) {
        log.trace((Object)"Remove the GSSCredential from the Subject");
        SecurityActions.removePrivateCredential(subject, credential);
        log.trace((Object)"Subtract the remaining principals and credentials we added to the Subject");
        SecurityActions.removeSubjectContents(intermediateSubject, subject);
    }
}

