/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.resource.transaction.backend.jta.internal;

import java.sql.Connection;
import java.sql.SQLException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import org.hibernate.HibernateException;
import org.hibernate.engine.transaction.jta.platform.spi.JtaPlatform;
import org.hibernate.resource.transaction.spi.DdlTransactionIsolator;
import org.hibernate.tool.schema.internal.exec.JdbcContext;

public class DdlTransactionIsolatorJtaImpl
implements DdlTransactionIsolator {
    private final JdbcContext jdbcContext;
    private Transaction suspendedTransaction;
    private Connection jdbcConnection;

    public DdlTransactionIsolatorJtaImpl(JdbcContext jdbcContext) {
        this.jdbcContext = jdbcContext;
        try {
            this.suspendedTransaction = jdbcContext.getServiceRegistry().getService(JtaPlatform.class).retrieveTransactionManager().suspend();
        }
        catch (SystemException e) {
            throw new HibernateException("Unable to suspend current JTA transaction in preparation for DDL execution");
        }
        try {
            this.jdbcConnection = jdbcContext.getJdbcConnectionAccess().obtainConnection();
        }
        catch (SQLException e) {
            throw jdbcContext.getSqlExceptionHelper().convert(e, "Unable to open JDBC Connection for DDL execution");
        }
        try {
            this.jdbcConnection.setAutoCommit(true);
        }
        catch (SQLException e) {
            throw jdbcContext.getSqlExceptionHelper().convert(e, "Unable set JDBC Connection for DDL execution to autocommit");
        }
    }

    @Override
    public JdbcContext getJdbcContext() {
        return this.jdbcContext;
    }

    @Override
    public void prepare() {
    }

    @Override
    public Connection getIsolatedConnection() {
        return this.jdbcConnection;
    }

    @Override
    public void release() {
        if (this.jdbcConnection != null) {
            try {
                this.jdbcContext.getJdbcConnectionAccess().releaseConnection(this.jdbcConnection);
            }
            catch (SQLException e) {
                throw this.jdbcContext.getSqlExceptionHelper().convert(e, "Unable to release JDBC Connection used for DDL execution");
            }
        }
        if (this.suspendedTransaction != null) {
            try {
                this.jdbcContext.getServiceRegistry().getService(JtaPlatform.class).retrieveTransactionManager().resume(this.suspendedTransaction);
            }
            catch (Exception e) {
                throw new HibernateException("Unable to resume JTA transaction after DDL execution");
            }
        }
    }
}

