/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.enhance;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javassist.ClassPool;
import javassist.CtClass;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;
import org.hibernate.bytecode.enhance.spi.DefaultEnhancementContext;
import org.hibernate.bytecode.enhance.spi.Enhancer;

public class EnhancementTask
extends Task {
    private List<FileSet> filesets = new ArrayList<FileSet>();
    private final ClassPool classPool = new ClassPool(false);
    private final Enhancer enhancer = new Enhancer(new DefaultEnhancementContext());

    public void addFileset(FileSet set) {
        this.filesets.add(set);
    }

    public void execute() throws BuildException {
        this.log("Starting Hibernate EnhancementTask execution", 2);
        Project project = this.getProject();
        for (FileSet fileSet : this.filesets) {
            File fileSetBaseDir = fileSet.getDir(project);
            DirectoryScanner directoryScanner = fileSet.getDirectoryScanner(project);
            for (String relativeIncludedFileName : directoryScanner.getIncludedFiles()) {
                File javaClassFile = new File(fileSetBaseDir, relativeIncludedFileName);
                if (!javaClassFile.exists()) continue;
                this.processClassFile(javaClassFile);
            }
        }
    }

    private void processClassFile(File javaClassFile) {
        try {
            CtClass ctClass = this.classPool.makeClass((InputStream)new FileInputStream(javaClassFile));
            byte[] result = this.enhancer.enhance(ctClass.getName(), ctClass.toBytecode());
            if (result != null) {
                this.writeEnhancedClass(javaClassFile, result);
            }
        }
        catch (Exception e) {
            this.log("Unable to enhance class file [" + javaClassFile.getAbsolutePath() + "]", e, 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeEnhancedClass(File javaClassFile, byte[] result) {
        try {
            if (javaClassFile.delete()) {
                if (!javaClassFile.createNewFile()) {
                    this.log("Unable to recreate class file [" + javaClassFile.getName() + "]", 2);
                }
            } else {
                this.log("Unable to delete class file [" + javaClassFile.getName() + "]", 2);
            }
            FileOutputStream outputStream = new FileOutputStream(javaClassFile, false);
            try {
                outputStream.write(result);
                outputStream.flush();
            }
            finally {
                try {
                    outputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        catch (FileNotFoundException outputStream) {
        }
        catch (IOException e) {
            throw new BuildException(String.format("Error processing included file [%s]", javaClassFile.getAbsolutePath()), (Throwable)e);
        }
    }
}

