/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.spi.util;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.function.Supplier;
import org.wildfly.clustering.marshalling.Externalizer;

public class EmptyCollectionExternalizer<T>
implements Externalizer<T> {
    private final Supplier<T> factory;

    EmptyCollectionExternalizer(Supplier<T> factory) {
        this.factory = factory;
    }

    public void writeObject(ObjectOutput output, T object) throws IOException {
    }

    public T readObject(ObjectInput input) throws IOException, ClassNotFoundException {
        return this.factory.get();
    }

    public Class<T> getTargetClass() {
        return this.factory.get().getClass();
    }

    public static class EmptySortedSetExternalizer
    extends EmptyCollectionExternalizer<SortedSet<Object>> {
        public EmptySortedSetExternalizer() {
            super(() -> Collections.emptySortedSet());
        }
    }

    public static class EmptySortedMapExternalizer
    extends EmptyCollectionExternalizer<SortedMap<Object, Object>> {
        public EmptySortedMapExternalizer() {
            super(() -> Collections.emptySortedMap());
        }
    }

    public static class EmptySetExternalizer
    extends EmptyCollectionExternalizer<Set<Object>> {
        public EmptySetExternalizer() {
            super(() -> Collections.emptySet());
        }
    }

    public static class EmptyNavigableSetExternalizer
    extends EmptyCollectionExternalizer<NavigableSet<Object>> {
        public EmptyNavigableSetExternalizer() {
            super(() -> Collections.emptyNavigableSet());
        }
    }

    public static class EmptyNavigableMapExternalizer
    extends EmptyCollectionExternalizer<NavigableMap<Object, Object>> {
        public EmptyNavigableMapExternalizer() {
            super(() -> Collections.emptyNavigableMap());
        }
    }

    public static class EmptyMapExternalizer
    extends EmptyCollectionExternalizer<Map<Object, Object>> {
        public EmptyMapExternalizer() {
            super(() -> Collections.emptyMap());
        }
    }

    public static class EmptyListIteratorExternalizer
    extends EmptyCollectionExternalizer<ListIterator<Object>> {
        public EmptyListIteratorExternalizer() {
            super(() -> Collections.emptyListIterator());
        }
    }

    public static class EmptyListExternalizer
    extends EmptyCollectionExternalizer<List<Object>> {
        public EmptyListExternalizer() {
            super(() -> Collections.emptyList());
        }
    }

    public static class EmptyIteratorExternalizer
    extends EmptyCollectionExternalizer<Iterator<Object>> {
        public EmptyIteratorExternalizer() {
            super(() -> Collections.emptyIterator());
        }
    }

    public static class EmptyEnumerationExternalizer
    extends EmptyCollectionExternalizer<Enumeration<Object>> {
        public EmptyEnumerationExternalizer() {
            super(() -> Collections.emptyEnumeration());
        }
    }
}

