/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.jgroups.subsystem;

import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jboss.as.clustering.controller.Registration;
import org.jboss.as.clustering.controller.ResourceDescriptor;
import org.jboss.as.clustering.controller.ResourceServiceBuilderFactory;
import org.jboss.as.clustering.controller.RuntimeResourceRegistration;
import org.jboss.as.clustering.function.Consumers;
import org.jboss.as.clustering.jgroups.subsystem.AuthProtocolResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.EncryptProtocolResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.GenericProtocolResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.JDBCProtocolResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.JGroupsModel;
import org.jboss.as.clustering.jgroups.subsystem.MulticastProtocolConfigurationBuilder;
import org.jboss.as.clustering.jgroups.subsystem.MulticastSocketProtocolConfigurationBuilder;
import org.jboss.as.clustering.jgroups.subsystem.ProtocolConfigurationBuilder;
import org.jboss.as.clustering.jgroups.subsystem.ProtocolResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.SocketBindingProtocolResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.SocketDiscoveryProtocolResourceDefinition;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.transform.description.ResourceTransformationDescriptionBuilder;
import org.wildfly.clustering.jgroups.spi.ChannelFactory;

public class ProtocolRegistration
implements Registration<ManagementResourceRegistration> {
    private final ResourceServiceBuilderFactory<ChannelFactory> parentBuilderFactory;
    private final Consumer<ResourceDescriptor> descriptorConfigurator;

    static void buildTransformation(ModelVersion version, ResourceTransformationDescriptionBuilder parent) {
        ProtocolResourceDefinition.buildTransformation(version, parent);
        ProtocolType.MULTICAST_SOCKET.stream().map(ProtocolResourceDefinition::pathElement).forEach(path -> SocketBindingProtocolResourceDefinition.addTransformations(version, parent.addChildResource(path)));
        ProtocolType.JDBC.stream().map(ProtocolResourceDefinition::pathElement).forEach(path -> {
            if (JGroupsModel.VERSION_5_0_0.requiresTransformation(version)) {
                parent.rejectChildResource(path);
            } else {
                JDBCProtocolResourceDefinition.addTransformations(version, parent.addChildResource(path));
            }
        });
        ProtocolType.ENCRYPT.stream().map(ProtocolResourceDefinition::pathElement).forEach(path -> {
            if (JGroupsModel.VERSION_5_0_0.requiresTransformation(version)) {
                parent.rejectChildResource(path);
            } else {
                EncryptProtocolResourceDefinition.addTransformations(version, parent.addChildResource(path));
            }
        });
        ProtocolType.SOCKET_DISCOVERY.stream().map(ProtocolResourceDefinition::pathElement).forEach(path -> {
            if (JGroupsModel.VERSION_5_0_0.requiresTransformation(version)) {
                parent.rejectChildResource(path);
            } else {
                SocketDiscoveryProtocolResourceDefinition.addTransformations(version, parent.addChildResource(path));
            }
        });
        ProtocolType.AUTH.stream().map(ProtocolResourceDefinition::pathElement).forEach(path -> {
            if (JGroupsModel.VERSION_5_0_0.requiresTransformation(version)) {
                parent.rejectChildResource(path);
            } else {
                AuthProtocolResourceDefinition.addTransformations(version, parent.addChildResource(path));
            }
        });
    }

    ProtocolRegistration(ResourceServiceBuilderFactory<ChannelFactory> parentBuilderFactory) {
        this.parentBuilderFactory = parentBuilderFactory;
        this.descriptorConfigurator = Consumers.empty();
    }

    ProtocolRegistration(ResourceServiceBuilderFactory<ChannelFactory> parentBuilderFactory, RuntimeResourceRegistration runtimeResourceRegistration) {
        this.parentBuilderFactory = parentBuilderFactory;
        this.descriptorConfigurator = descriptor -> descriptor.addRuntimeResourceRegistration(runtimeResourceRegistration);
    }

    public void register(ManagementResourceRegistration registration) {
        new GenericProtocolResourceDefinition(this.descriptorConfigurator, address -> ProtocolType.MULTICAST.contains(address.getLastElement().getValue()) ? new MulticastProtocolConfigurationBuilder(address) : new ProtocolConfigurationBuilder(address), this.parentBuilderFactory).register(registration);
        ProtocolType.MULTICAST_SOCKET.forEach(protocol -> new SocketBindingProtocolResourceDefinition((String)protocol, this.descriptorConfigurator, address -> new MulticastSocketProtocolConfigurationBuilder(address), this.parentBuilderFactory).register(registration));
        ProtocolType.JDBC.forEach(protocol -> {
            new JDBCProtocolResourceDefinition((String)protocol, this.descriptorConfigurator, this.parentBuilderFactory).register(registration);
            new GenericProtocolResourceDefinition((String)protocol, JGroupsModel.VERSION_5_0_0, address -> new ProtocolConfigurationBuilder(address), this.descriptorConfigurator, this.parentBuilderFactory).register(registration);
        });
        ProtocolType.ENCRYPT.forEach(protocol -> {
            new EncryptProtocolResourceDefinition((String)protocol, this.descriptorConfigurator, this.parentBuilderFactory).register(registration);
            new GenericProtocolResourceDefinition((String)protocol, JGroupsModel.VERSION_5_0_0, address -> new ProtocolConfigurationBuilder(address), this.descriptorConfigurator, this.parentBuilderFactory).register(registration);
        });
        ProtocolType.SOCKET_DISCOVERY.forEach(protocol -> {
            new SocketDiscoveryProtocolResourceDefinition((String)protocol, this.descriptorConfigurator, this.parentBuilderFactory).register(registration);
            new GenericProtocolResourceDefinition((String)protocol, JGroupsModel.VERSION_5_0_0, address -> new ProtocolConfigurationBuilder(address), this.descriptorConfigurator, this.parentBuilderFactory).register(registration);
        });
        ProtocolType.AUTH.forEach(protocol -> {
            new AuthProtocolResourceDefinition((String)protocol, this.descriptorConfigurator, this.parentBuilderFactory).register(registration);
            new GenericProtocolResourceDefinition((String)protocol, JGroupsModel.VERSION_5_0_0, address -> new ProtocolConfigurationBuilder(address), this.descriptorConfigurator, this.parentBuilderFactory).register(registration);
        });
    }

    static enum ProtocolType implements Iterable<String>
    {
        AUTH("AUTH"),
        ENCRYPT("ASYM_ENCRYPT", "SYM_ENCRYPT"),
        JDBC("JDBC_PING"),
        MULTICAST("pbcast.NAKACK2"),
        MULTICAST_SOCKET("MPING"),
        SOCKET_DISCOVERY("TCPGOSSIP", "TCPPING");

        private final Set<String> protocols;

        private ProtocolType(String protocol) {
            this.protocols = Collections.singleton(protocol);
        }

        private ProtocolType(String ... protocols) {
            this.protocols = Collections.unmodifiableSet(Stream.of(protocols).collect(Collectors.toSet()));
        }

        @Override
        public Iterator<String> iterator() {
            return this.protocols.iterator();
        }

        Stream<String> stream() {
            return this.protocols.stream();
        }

        boolean contains(String protocol) {
            return this.protocols.contains(protocol);
        }
    }
}

