/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.api.jms.management;

import org.apache.activemq.artemis.api.core.management.Attribute;
import org.apache.activemq.artemis.api.core.management.Operation;
import org.apache.activemq.artemis.api.core.management.Parameter;

public interface DestinationControl {
    @Attribute(desc="the name of this destination")
    public String getName();

    @Attribute(desc="the address corresponding to this destination")
    public String getAddress();

    @Attribute(desc="whether this destination is temporary")
    public boolean isTemporary();

    @Attribute(desc="the number of messages currently in this destination")
    public long getMessageCount() throws Exception;

    @Attribute(desc="the number of messages that this queue is currently delivering to its consumers")
    public int getDeliveringCount();

    @Attribute(desc="the number of messages added to this queue since it was created")
    public long getMessagesAdded();

    @Operation(desc="Remove messages matching the given filter from the destination", impact=1)
    public int removeMessages(@Parameter(name="filter", desc="A JMS message filter (can be empty)") String var1) throws Exception;
}

