/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.httpclient.ejb;

import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.Cookie;
import io.undertow.util.Headers;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.SocketAddress;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import javax.ejb.EJBHome;
import javax.ejb.NoSuchEJBException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.xa.XAException;
import org.jboss.ejb.client.Affinity;
import org.jboss.ejb.client.EJBHomeLocator;
import org.jboss.ejb.client.EJBIdentifier;
import org.jboss.ejb.client.EJBLocator;
import org.jboss.ejb.client.EJBMethodLocator;
import org.jboss.ejb.client.SessionID;
import org.jboss.ejb.client.StatefulEJBLocator;
import org.jboss.ejb.client.StatelessEJBLocator;
import org.jboss.ejb.server.Association;
import org.jboss.ejb.server.CancelHandle;
import org.jboss.ejb.server.InvocationRequest;
import org.jboss.marshalling.InputStreamByteInput;
import org.jboss.marshalling.Marshaller;
import org.jboss.marshalling.Marshalling;
import org.jboss.marshalling.MarshallingConfiguration;
import org.jboss.marshalling.Unmarshaller;
import org.wildfly.common.annotation.NotNull;
import org.wildfly.httpclient.common.ContentType;
import org.wildfly.httpclient.common.ElytronIdentityHandler;
import org.wildfly.httpclient.common.HttpServerHelper;
import org.wildfly.httpclient.common.NoFlushByteOutput;
import org.wildfly.httpclient.ejb.EjbHeaders;
import org.wildfly.httpclient.ejb.EjbHttpClientMessages;
import org.wildfly.httpclient.ejb.HttpProtocolV1ObjectTable;
import org.wildfly.httpclient.ejb.InvocationIdentifier;
import org.wildfly.httpclient.ejb.PackedInteger;
import org.wildfly.httpclient.ejb.RemoteHTTPHandler;
import org.wildfly.security.auth.server.SecurityIdentity;
import org.wildfly.transaction.client.ImportResult;
import org.wildfly.transaction.client.LocalTransaction;
import org.wildfly.transaction.client.LocalTransactionContext;

class HttpInvocationHandler
extends RemoteHTTPHandler {
    private final Association association;
    private final ExecutorService executorService;
    private final LocalTransactionContext localTransactionContext;
    private final Map<InvocationIdentifier, CancelHandle> cancellationFlags;

    HttpInvocationHandler(Association association, ExecutorService executorService, LocalTransactionContext localTransactionContext, Map<InvocationIdentifier, CancelHandle> cancellationFlags) {
        super(executorService);
        this.association = association;
        this.executorService = executorService;
        this.localTransactionContext = localTransactionContext;
        this.cancellationFlags = cancellationFlags;
    }

    @Override
    protected void handleInternal(final HttpServerExchange exchange) throws Exception {
        String[] parts;
        String ct = exchange.getRequestHeaders().getFirst(Headers.CONTENT_TYPE);
        ContentType contentType = ContentType.parse(ct);
        if (contentType == null || contentType.getVersion() != 1 || !"application/x-wf-ejb-jbmar-invocation".equals(contentType.getType())) {
            exchange.setStatusCode(400);
            EjbHttpClientMessages.MESSAGES.debugf("Bad content type %s", (Object)ct);
            return;
        }
        String relativePath = exchange.getRelativePath();
        if (relativePath.startsWith("/")) {
            relativePath = relativePath.substring(1);
        }
        if ((parts = relativePath.split("/")).length < 7) {
            exchange.setStatusCode(404);
            return;
        }
        final String app = HttpInvocationHandler.handleDash(parts[0]);
        final String module = HttpInvocationHandler.handleDash(parts[1]);
        final String distinct = HttpInvocationHandler.handleDash(parts[2]);
        final String bean = parts[3];
        String originalSessionId = HttpInvocationHandler.handleDash(parts[4]);
        final byte[] sessionID = originalSessionId.isEmpty() ? null : Base64.getUrlDecoder().decode(originalSessionId);
        final String viewName = parts[5];
        final String method = parts[6];
        final String[] parameterTypeNames = new String[parts.length - 7];
        System.arraycopy(parts, 7, parameterTypeNames, 0, parameterTypeNames.length);
        Cookie cookie = exchange.getRequestCookies().get("JSESSIONID");
        final String sessionAffinity = cookie != null ? cookie.getValue() : null;
        final EJBIdentifier ejbIdentifier = new EJBIdentifier(app, module, bean, distinct);
        String cancellationId = exchange.getRequestHeaders().getFirst(EjbHeaders.INVOCATION_ID);
        final InvocationIdentifier identifier = cancellationId != null && sessionAffinity != null ? new InvocationIdentifier(cancellationId, sessionAffinity) : null;
        exchange.dispatch((Executor)this.executorService, () -> {
            CancelHandle handle = this.association.receiveInvocationRequest(new InvocationRequest(){

                @Override
                public SocketAddress getPeerAddress() {
                    return exchange.getSourceAddress();
                }

                @Override
                public SocketAddress getLocalAddress() {
                    return exchange.getDestinationAddress();
                }

                /*
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                @Override
                public InvocationRequest.Resolved getRequestContent(ClassLoader classLoader) throws IOException, ClassNotFoundException {
                    Object[] methodParams = new Object[parameterTypeNames.length];
                    Class<?> view = Class.forName(viewName, false, classLoader);
                    MarshallingConfiguration marshallingConfiguration = new MarshallingConfiguration();
                    marshallingConfiguration.setObjectTable(HttpProtocolV1ObjectTable.INSTANCE);
                    marshallingConfiguration.setVersion(2);
                    Unmarshaller unmarshaller = HttpServerHelper.RIVER_MARSHALLER_FACTORY.createUnmarshaller(marshallingConfiguration);
                    try (InputStream inputStream = exchange.getInputStream();){
                        HashMap<String, Object> privateAttachments;
                        LocalTransaction transaction;
                        unmarshaller.start(new InputStreamByteInput(inputStream));
                        RemoteHTTPHandler.ReceivedTransaction txConfig = HttpInvocationHandler.this.readTransaction(unmarshaller);
                        if (txConfig == null || HttpInvocationHandler.this.localTransactionContext == null) {
                            transaction = null;
                        } else {
                            try {
                                ImportResult<LocalTransaction> result = HttpInvocationHandler.this.localTransactionContext.findOrImportTransaction(txConfig.getXid(), txConfig.getRemainingTime());
                                transaction = result.getTransaction();
                            }
                            catch (XAException e) {
                                throw new IllegalStateException(e);
                            }
                        }
                        for (int i = 0; i < parameterTypeNames.length; ++i) {
                            methodParams[i] = unmarshaller.readObject();
                        }
                        int attachementCount = PackedInteger.readPackedInteger(unmarshaller);
                        if (attachementCount > 0) {
                            HashMap<String, Object> contextData = new HashMap<String, Object>();
                            for (int i = 0; i < attachementCount - 1; ++i) {
                                String key = (String)unmarshaller.readObject();
                                Object value = unmarshaller.readObject();
                                contextData.put(key, value);
                            }
                            privateAttachments = new HashMap((Map)unmarshaller.readObject());
                        } else {
                            Map contextData = Collections.emptyMap();
                            privateAttachments = new HashMap<String, Object>();
                        }
                        unmarshaller.finish();
                        EJBLocator locator = EJBHome.class.isAssignableFrom(view) ? new EJBHomeLocator(view, app, module, bean, distinct, Affinity.LOCAL) : (sessionID != null ? new StatefulEJBLocator(view, app, module, bean, distinct, SessionID.createSessionID(sessionID), Affinity.LOCAL) : new StatelessEJBLocator(view, app, module, bean, distinct, Affinity.LOCAL));
                        ResolvedInvocation resolvedInvocation = new ResolvedInvocation(privateAttachments, methodParams, locator, exchange, marshallingConfiguration, sessionAffinity, transaction, identifier);
                        return resolvedInvocation;
                    }
                    catch (IOException | ClassNotFoundException e) {
                        throw e;
                    }
                    catch (Throwable e) {
                        throw new IOException(e);
                    }
                }

                @Override
                public EJBMethodLocator getMethodLocator() {
                    return new EJBMethodLocator(method, parameterTypeNames);
                }

                @Override
                public void writeNoSuchMethod() {
                    if (identifier != null) {
                        HttpInvocationHandler.this.cancellationFlags.remove(identifier);
                    }
                    HttpServerHelper.sendException(exchange, 404, EjbHttpClientMessages.MESSAGES.noSuchMethod());
                }

                @Override
                public void writeSessionNotActive() {
                    if (identifier != null) {
                        HttpInvocationHandler.this.cancellationFlags.remove(identifier);
                    }
                    HttpServerHelper.sendException(exchange, 500, EjbHttpClientMessages.MESSAGES.sessionNotActive());
                }

                @Override
                public void writeWrongViewType() {
                    if (identifier != null) {
                        HttpInvocationHandler.this.cancellationFlags.remove(identifier);
                    }
                    HttpServerHelper.sendException(exchange, 404, EjbHttpClientMessages.MESSAGES.wrongViewType());
                }

                @Override
                public Executor getRequestExecutor() {
                    return HttpInvocationHandler.this.executorService == null ? exchange.getIoThread().getWorker() : HttpInvocationHandler.this.executorService;
                }

                @Override
                public String getProtocol() {
                    return exchange.getProtocol().toString();
                }

                @Override
                public boolean isBlockingCaller() {
                    return false;
                }

                @Override
                public EJBIdentifier getEJBIdentifier() {
                    return ejbIdentifier;
                }

                @Override
                public SecurityIdentity getSecurityIdentity() {
                    return exchange.getAttachment(ElytronIdentityHandler.IDENTITY_KEY);
                }

                @Override
                public void writeException(@NotNull Exception exception) {
                    if (identifier != null) {
                        HttpInvocationHandler.this.cancellationFlags.remove(identifier);
                    }
                    HttpServerHelper.sendException(exchange, 500, exception);
                }

                @Override
                public void writeNoSuchEJB() {
                    if (identifier != null) {
                        HttpInvocationHandler.this.cancellationFlags.remove(identifier);
                    }
                    HttpServerHelper.sendException(exchange, 404, new NoSuchEJBException());
                }

                @Override
                public void writeCancelResponse() {
                    if (identifier != null) {
                        HttpInvocationHandler.this.cancellationFlags.remove(identifier);
                    }
                }

                @Override
                public void writeNotStateful() {
                    if (identifier != null) {
                        HttpInvocationHandler.this.cancellationFlags.remove(identifier);
                    }
                    HttpServerHelper.sendException(exchange, 500, EjbHttpClientMessages.MESSAGES.notStateful());
                }

                @Override
                public void convertToStateful(@NotNull SessionID sessionId) throws IllegalArgumentException, IllegalStateException {
                    throw new RuntimeException("nyi");
                }
            });
            if (handle != null && identifier != null) {
                this.cancellationFlags.put(identifier, handle);
            }
        });
    }

    private static String handleDash(String s) {
        if (s.equals("-")) {
            return "";
        }
        return s;
    }

    class ResolvedInvocation
    implements InvocationRequest.Resolved {
        private final Map<String, Object> privateAttachments;
        private final Object[] methodParams;
        private final EJBLocator<?> locator;
        private final HttpServerExchange exchange;
        private final MarshallingConfiguration marshallingConfiguration;
        private final String sessionAffinity;
        private final Transaction transaction;
        private final InvocationIdentifier identifier;

        public ResolvedInvocation(Map<String, Object> privateAttachments, Object[] methodParams, EJBLocator<?> locator, HttpServerExchange exchange, MarshallingConfiguration marshallingConfiguration, String sessionAffinity, Transaction transaction, InvocationIdentifier identifier) {
            this.privateAttachments = privateAttachments;
            this.methodParams = methodParams;
            this.locator = locator;
            this.exchange = exchange;
            this.marshallingConfiguration = marshallingConfiguration;
            this.sessionAffinity = sessionAffinity;
            this.transaction = transaction;
            this.identifier = identifier;
        }

        @Override
        public Map<String, Object> getAttachments() {
            return this.privateAttachments;
        }

        @Override
        public Object[] getParameters() {
            return this.methodParams;
        }

        @Override
        public EJBLocator<?> getEJBLocator() {
            return this.locator;
        }

        @Override
        public boolean hasTransaction() {
            return this.transaction != null;
        }

        @Override
        public Transaction getTransaction() throws SystemException, IllegalStateException {
            return this.transaction;
        }

        String getSessionAffinity() {
            return this.sessionAffinity;
        }

        HttpServerExchange getExchange() {
            return this.exchange;
        }

        @Override
        public void writeInvocationResult(Object result) {
            if (this.identifier != null) {
                HttpInvocationHandler.this.cancellationFlags.remove(this.identifier);
            }
            try {
                this.exchange.getResponseHeaders().put(Headers.CONTENT_TYPE, EjbHeaders.EJB_RESPONSE_VERSION_ONE.toString());
                Marshaller marshaller = HttpServerHelper.RIVER_MARSHALLER_FACTORY.createMarshaller(this.marshallingConfiguration);
                OutputStream outputStream = this.exchange.getOutputStream();
                NoFlushByteOutput byteOutput = new NoFlushByteOutput(Marshalling.createByteOutput(outputStream));
                marshaller.start(byteOutput);
                marshaller.writeObject(result);
                PackedInteger.writePackedInteger(marshaller, this.privateAttachments.size());
                for (Map.Entry<String, Object> entry : this.privateAttachments.entrySet()) {
                    marshaller.writeObject(entry.getKey());
                    marshaller.writeObject(entry.getValue());
                }
                marshaller.finish();
                marshaller.flush();
                this.exchange.endExchange();
            }
            catch (Exception e) {
                HttpServerHelper.sendException(this.exchange, 500, e);
            }
        }
    }
}

