/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.model;

import javax.faces.model.DataModel;
import javax.faces.model.DataModelEvent;
import javax.faces.model.DataModelListener;
import javax.faces.model.NoRowAvailableException;

public class ArrayDataModel<E>
extends DataModel<E> {
    private Object[] array;
    private int index = -1;

    public ArrayDataModel() {
        this(null);
    }

    public ArrayDataModel(E[] array) {
        this.setWrappedData(array);
    }

    @Override
    public boolean isRowAvailable() {
        if (this.array == null) {
            return false;
        }
        return this.index >= 0 && this.index < this.array.length;
    }

    @Override
    public int getRowCount() {
        if (this.array == null) {
            return -1;
        }
        return this.array.length;
    }

    @Override
    public E getRowData() {
        if (this.array == null) {
            return null;
        }
        if (!this.isRowAvailable()) {
            throw new NoRowAvailableException();
        }
        return (E)this.array[this.index];
    }

    @Override
    public int getRowIndex() {
        return this.index;
    }

    @Override
    public void setRowIndex(int rowIndex) {
        if (rowIndex < -1) {
            throw new IllegalArgumentException();
        }
        int old = this.index;
        this.index = rowIndex;
        if (this.array == null) {
            return;
        }
        DataModelListener[] listeners = this.getDataModelListeners();
        if (old != this.index && listeners != null) {
            Object rowData = null;
            if (this.isRowAvailable()) {
                rowData = this.getRowData();
            }
            DataModelEvent event = new DataModelEvent(this, this.index, rowData);
            int n = listeners.length;
            for (int i = 0; i < n; ++i) {
                if (null == listeners[i]) continue;
                listeners[i].rowSelected(event);
            }
        }
    }

    @Override
    public Object getWrappedData() {
        return this.array;
    }

    @Override
    public void setWrappedData(Object data) {
        if (data == null) {
            this.array = null;
            this.setRowIndex(-1);
        } else {
            this.array = (Object[])data;
            this.index = -1;
            this.setRowIndex(0);
        }
    }
}

