/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.spi.util;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.IntFunction;
import org.wildfly.clustering.marshalling.Externalizer;
import org.wildfly.clustering.marshalling.spi.IndexExternalizer;

public class MapExternalizer<T extends Map<Object, Object>>
implements Externalizer<T> {
    private final Class<T> targetClass;
    private final IntFunction<T> factory;

    MapExternalizer(Class<?> targetClass, IntFunction<T> factory) {
        this.targetClass = targetClass;
        this.factory = factory;
    }

    public void writeObject(ObjectOutput output, T map) throws IOException {
        MapExternalizer.writeMap(output, map);
    }

    static <T extends Map<Object, Object>> void writeMap(ObjectOutput output, T map) throws IOException {
        IndexExternalizer.VARIABLE.writeData(output, map.size());
        for (Map.Entry<Object, Object> entry : map.entrySet()) {
            output.writeObject(entry.getKey());
            output.writeObject(entry.getValue());
        }
    }

    public T readObject(ObjectInput input) throws IOException, ClassNotFoundException {
        int size = IndexExternalizer.VARIABLE.readData(input);
        return (T)MapExternalizer.readMap(input, (Map)this.factory.apply(size), size);
    }

    static <T extends Map<Object, Object>> T readMap(ObjectInput input, T map, int size) throws IOException, ClassNotFoundException {
        for (int i = 0; i < size; ++i) {
            map.put((Object)input.readObject(), (Object)input.readObject());
        }
        return map;
    }

    public Class<T> getTargetClass() {
        return this.targetClass;
    }

    public static class LinkedHashMapExternalizer
    extends MapExternalizer<LinkedHashMap<Object, Object>> {
        public LinkedHashMapExternalizer() {
            super(LinkedHashMap.class, LinkedHashMap::new);
        }
    }

    public static class HashMapExternalizer
    extends MapExternalizer<HashMap<Object, Object>> {
        public HashMapExternalizer() {
            super(HashMap.class, HashMap::new);
        }
    }

    public static class ConcurrentHashMapExternalizer
    extends MapExternalizer<ConcurrentHashMap<Object, Object>> {
        public ConcurrentHashMapExternalizer() {
            super(ConcurrentHashMap.class, ConcurrentHashMap::new);
        }
    }
}

