/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.service.concurrent;

import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.StampedLock;
import java.util.function.Supplier;
import org.wildfly.clustering.service.concurrent.ServiceExecutor;

public class StampedLockServiceExecutor
implements ServiceExecutor {
    private final StampedLock lock = new StampedLock();
    private final AtomicBoolean closed = new AtomicBoolean(false);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(Runnable executeTask) {
        long stamp = this.lock.tryReadLock();
        if (stamp != 0L) {
            try {
                executeTask.run();
            }
            finally {
                this.lock.unlock(stamp);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <R> Optional<R> execute(Callable<R> executeTask) throws Exception {
        long stamp = this.lock.tryReadLock();
        if (stamp != 0L) {
            try {
                Optional<R> optional = Optional.of(executeTask.call());
                return optional;
            }
            finally {
                this.lock.unlock(stamp);
            }
        }
        return Optional.empty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <R> Optional<R> execute(Supplier<R> executeTask) {
        long stamp = this.lock.tryReadLock();
        if (stamp != 0L) {
            try {
                Optional<R> optional = Optional.of(executeTask.get());
                return optional;
            }
            finally {
                this.lock.unlock(stamp);
            }
        }
        return Optional.empty();
    }

    @Override
    public void close(Runnable closeTask) {
        if (this.closed.compareAndSet(false, true)) {
            this.lock.writeLock();
            closeTask.run();
        }
    }
}

