/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.naming.client.remote;

import java.io.IOException;
import java.net.URI;
import java.security.AccessController;
import java.security.GeneralSecurityException;
import java.util.List;
import javax.naming.NamingException;
import javax.net.ssl.SSLContext;
import org.jboss.remoting3.ConnectionPeerIdentity;
import org.jboss.remoting3.Endpoint;
import org.wildfly.common.Assert;
import org.wildfly.naming.client.NamingProvider;
import org.wildfly.naming.client._private.Messages;
import org.wildfly.naming.client.util.FastHashtable;
import org.wildfly.security.auth.AuthenticationException;
import org.wildfly.security.auth.client.AuthenticationConfiguration;
import org.wildfly.security.auth.client.AuthenticationContext;
import org.wildfly.security.auth.client.AuthenticationContextConfigurationClient;
import org.xnio.FailedIoFuture;
import org.xnio.IoFuture;

public final class RemoteNamingProvider
implements NamingProvider {
    private static final AuthenticationContextConfigurationClient CLIENT = (AuthenticationContextConfigurationClient)AccessController.doPrivileged(AuthenticationContextConfigurationClient.ACTION);
    private final Endpoint endpoint;
    private final List<NamingProvider.Location> locationsList;

    RemoteNamingProvider(Endpoint endpoint, List<NamingProvider.Location> locationsList, FastHashtable<String, Object> env) {
        this.endpoint = endpoint;
        this.locationsList = locationsList;
    }

    public Endpoint getEndpoint() {
        return this.endpoint;
    }

    @Override
    public List<NamingProvider.Location> getLocations() {
        return this.locationsList;
    }

    public ConnectionPeerIdentity getPeerIdentityForNaming() throws NamingException {
        return (ConnectionPeerIdentity)NamingProvider.super.getPeerIdentityForNaming();
    }

    public ConnectionPeerIdentity getPeerIdentityForNaming(NamingProvider.Location location) throws NamingException {
        Assert.checkNotNullParam((String)"location", (Object)location);
        try {
            return this.getPeerIdentity(location);
        }
        catch (AuthenticationException e) {
            throw Messages.log.authenticationFailed(e);
        }
        catch (IOException e) {
            throw Messages.log.connectFailed(e);
        }
    }

    public ConnectionPeerIdentity getPeerIdentity(NamingProvider.Location location) throws IOException {
        Assert.checkNotNullParam((String)"location", (Object)location);
        return (ConnectionPeerIdentity)this.getFuturePeerIdentity(location).get();
    }

    public IoFuture<ConnectionPeerIdentity> getFuturePeerIdentity(NamingProvider.Location location) {
        return AccessController.doPrivileged(() -> this.getFuturePeerIdentityPrivileged(location));
    }

    private IoFuture<ConnectionPeerIdentity> getFuturePeerIdentityPrivileged(NamingProvider.Location location) {
        SSLContext realSSLContext;
        SSLContext sslContext = location.getSSLContext();
        URI providerUri = location.getUri();
        AuthenticationConfiguration authenticationConfiguration = location.getAuthenticationConfiguration();
        if (sslContext == null) {
            try {
                realSSLContext = CLIENT.getSSLContext(providerUri, AuthenticationContext.captureCurrent(), "jndi", "jboss");
            }
            catch (GeneralSecurityException e) {
                return new FailedIoFuture(new IOException(e));
            }
        } else {
            realSSLContext = sslContext;
        }
        AuthenticationConfiguration realConf = authenticationConfiguration == null ? CLIENT.getAuthenticationConfiguration(providerUri, AuthenticationContext.captureCurrent(), -1, "jndi", "jboss") : authenticationConfiguration;
        return this.endpoint.getConnectedIdentity(providerUri, realSSLContext, realConf);
    }
}

