/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.messaging.activemq.jms;

import org.apache.activemq.artemis.api.core.management.QueueControl;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.jboss.as.controller.AbstractRuntimeOnlyHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.logging.ControllerLogger;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.operations.validation.ParametersValidator;
import org.jboss.as.controller.operations.validation.StringLengthValidator;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.wildfly.extension.messaging.activemq.ActiveMQActivationService;
import org.wildfly.extension.messaging.activemq.CommonAttributes;
import org.wildfly.extension.messaging.activemq.MessagingServices;
import org.wildfly.extension.messaging.activemq.jms.JMSQueueDefinition;
import org.wildfly.extension.messaging.activemq.logging.MessagingLogger;

public class JMSQueueReadAttributeHandler
extends AbstractRuntimeOnlyHandler {
    public static final JMSQueueReadAttributeHandler INSTANCE = new JMSQueueReadAttributeHandler();
    private ParametersValidator validator = new ParametersValidator();

    private JMSQueueReadAttributeHandler() {
        this.validator.registerValidator("name", (ParameterValidator)new StringLengthValidator(1));
    }

    public void executeRuntimeStep(OperationContext context, ModelNode operation) throws OperationFailedException {
        if (ActiveMQActivationService.ignoreOperationIfServerNotActive(context, operation)) {
            return;
        }
        this.validator.validate(operation);
        String attributeName = operation.require("name").asString();
        QueueControl control = this.getControl(context, operation);
        if (control == null) {
            PathAddress address = PathAddress.pathAddress((ModelNode)operation.require("address"));
            throw ControllerLogger.ROOT_LOGGER.managementResourceNotFound(address);
        }
        if (CommonAttributes.MESSAGE_COUNT.getName().equals(attributeName)) {
            try {
                context.getResult().set(control.getMessageCount());
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        } else if (CommonAttributes.SCHEDULED_COUNT.getName().equals(attributeName)) {
            context.getResult().set(control.getScheduledCount());
        } else if (CommonAttributes.CONSUMER_COUNT.getName().equals(attributeName)) {
            context.getResult().set(control.getConsumerCount());
        } else if (CommonAttributes.DELIVERING_COUNT.getName().equals(attributeName)) {
            context.getResult().set(control.getDeliveringCount());
        } else if (CommonAttributes.MESSAGES_ADDED.getName().equals(attributeName)) {
            context.getResult().set(control.getMessagesAdded());
        } else if (JMSQueueDefinition.QUEUE_ADDRESS.getName().equals(attributeName)) {
            context.getResult().set(control.getAddress());
        } else if (JMSQueueDefinition.EXPIRY_ADDRESS.getName().equals(attributeName)) {
            ModelNode result = context.getResult();
            String expiryAddress = control.getExpiryAddress();
            if (expiryAddress != null) {
                result.set(expiryAddress);
            }
        } else if (JMSQueueDefinition.DEAD_LETTER_ADDRESS.getName().equals(attributeName)) {
            ModelNode result = context.getResult();
            String dla = control.getDeadLetterAddress();
            if (dla != null) {
                result.set(dla);
            }
        } else if (CommonAttributes.PAUSED.getName().equals(attributeName)) {
            try {
                context.getResult().set(control.isPaused());
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        } else if (CommonAttributes.TEMPORARY.getName().equals(attributeName)) {
            context.getResult().set(control.isTemporary());
        } else {
            throw MessagingLogger.ROOT_LOGGER.unsupportedAttribute(attributeName);
        }
    }

    private QueueControl getControl(OperationContext context, ModelNode operation) {
        String queueName = PathAddress.pathAddress((ModelNode)operation.require("address")).getLastElement().getValue();
        ServiceName serviceName = MessagingServices.getActiveMQServiceName(PathAddress.pathAddress((ModelNode)operation.get("address")));
        ServiceController service = context.getServiceRegistry(false).getService(serviceName);
        ActiveMQServer server = (ActiveMQServer)ActiveMQServer.class.cast(service.getValue());
        QueueControl control = (QueueControl)QueueControl.class.cast(server.getManagementService().getResource("queue.jms.queue." + queueName));
        return control;
    }
}

