/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.messaging.activemq.jms.bridge;

import java.util.Hashtable;
import java.util.Properties;
import java.util.function.Supplier;
import org.apache.activemq.artemis.jms.bridge.ConnectionFactoryFactory;
import org.apache.activemq.artemis.jms.bridge.DestinationFactory;
import org.apache.activemq.artemis.jms.bridge.JMSBridge;
import org.apache.activemq.artemis.jms.bridge.QualityOfServiceMode;
import org.apache.activemq.artemis.jms.bridge.impl.JMSBridgeImpl;
import org.apache.activemq.artemis.jms.bridge.impl.JNDIConnectionFactoryFactory;
import org.apache.activemq.artemis.jms.bridge.impl.JNDIDestinationFactory;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ObjectTypeAttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.security.CredentialReference;
import org.jboss.as.naming.deployment.ContextNames;
import org.jboss.as.server.Services;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;
import org.jboss.modules.ModuleNotFoundException;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.wildfly.common.function.ExceptionSupplier;
import org.wildfly.extension.messaging.activemq.CommonAttributes;
import org.wildfly.extension.messaging.activemq.MessagingServices;
import org.wildfly.extension.messaging.activemq.jms.bridge.JMSBridgeDefinition;
import org.wildfly.extension.messaging.activemq.jms.bridge.JMSBridgeService;
import org.wildfly.extension.messaging.activemq.logging.MessagingLogger;
import org.wildfly.security.credential.source.CredentialSource;
import org.wildfly.security.manager.WildFlySecurityManager;

public class JMSBridgeAdd
extends AbstractAddStepHandler {
    public static final JMSBridgeAdd INSTANCE = new JMSBridgeAdd();

    private JMSBridgeAdd() {
        super(JMSBridgeDefinition.ATTRIBUTES);
    }

    protected void performRuntime(OperationContext context, ModelNode operation, final ModelNode model) throws OperationFailedException {
        context.addStep(new OperationStepHandler(){

            public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                PathAddress address = PathAddress.pathAddress((ModelNode)operation.get("address"));
                String moduleName = JMSBridgeAdd.this.resolveAttribute(JMSBridgeDefinition.MODULE, context, model);
                JMSBridge bridge = JMSBridgeAdd.this.createJMSBridge(context, model);
                String bridgeName = address.getLastElement().getValue();
                ServiceName bridgeServiceName = MessagingServices.getJMSBridgeServiceName(bridgeName);
                ServiceBuilder jmsBridgeServiceBuilder = context.getServiceTarget().addService(bridgeServiceName);
                jmsBridgeServiceBuilder.requires(context.getCapabilityServiceName("org.wildfly.transactions.global-default-local-provider", null));
                jmsBridgeServiceBuilder.setInitialMode(ServiceController.Mode.ACTIVE);
                Supplier executorSupplier = Services.requireServerExecutor((ServiceBuilder)jmsBridgeServiceBuilder);
                if (JMSBridgeAdd.this.dependsOnLocalResources(context, model, (AttributeDefinition)JMSBridgeDefinition.SOURCE_CONTEXT)) {
                    JMSBridgeAdd.this.addDependencyForJNDIResource(jmsBridgeServiceBuilder, model, context, (AttributeDefinition)JMSBridgeDefinition.SOURCE_CONNECTION_FACTORY);
                    JMSBridgeAdd.this.addDependencyForJNDIResource(jmsBridgeServiceBuilder, model, context, (AttributeDefinition)JMSBridgeDefinition.SOURCE_DESTINATION);
                }
                if (JMSBridgeAdd.this.dependsOnLocalResources(context, model, (AttributeDefinition)JMSBridgeDefinition.TARGET_CONTEXT)) {
                    JMSBridgeAdd.this.addDependencyForJNDIResource(jmsBridgeServiceBuilder, model, context, (AttributeDefinition)JMSBridgeDefinition.TARGET_CONNECTION_FACTORY);
                    JMSBridgeAdd.this.addDependencyForJNDIResource(jmsBridgeServiceBuilder, model, context, (AttributeDefinition)JMSBridgeDefinition.TARGET_DESTINATION);
                }
                jmsBridgeServiceBuilder.requires(MessagingServices.ACTIVEMQ_CLIENT_THREAD_POOL);
                JMSBridgeService bridgeService = new JMSBridgeService(moduleName, bridgeName, bridge, executorSupplier, (ExceptionSupplier<CredentialSource, Exception>)JMSBridgeAdd.getCredentialStoreReference(JMSBridgeDefinition.SOURCE_CREDENTIAL_REFERENCE, context, model, jmsBridgeServiceBuilder, new String[0]), (ExceptionSupplier<CredentialSource, Exception>)JMSBridgeAdd.getCredentialStoreReference(JMSBridgeDefinition.TARGET_CREDENTIAL_REFERENCE, context, model, jmsBridgeServiceBuilder, new String[0]));
                jmsBridgeServiceBuilder.setInstance((Service)bridgeService);
                jmsBridgeServiceBuilder.install();
                context.completeStep(OperationContext.RollbackHandler.NOOP_ROLLBACK_HANDLER);
            }
        }, OperationContext.Stage.RUNTIME);
    }

    private boolean dependsOnLocalResources(OperationContext context, ModelNode model, AttributeDefinition attr) throws OperationFailedException {
        return this.resolveContextProperties(attr, context, model).isEmpty();
    }

    private void addDependencyForJNDIResource(ServiceBuilder builder, ModelNode model, OperationContext context, AttributeDefinition attribute) throws OperationFailedException {
        String jndiName = attribute.resolveModelAttribute(context, model).asString();
        builder.requires(ContextNames.bindInfoFor((String)jndiName).getBinderServiceName());
    }

    private JMSBridge createJMSBridge(OperationContext context, ModelNode model) throws OperationFailedException {
        Properties sourceContextProperties = this.resolveContextProperties((AttributeDefinition)JMSBridgeDefinition.SOURCE_CONTEXT, context, model);
        String sourceConnectionFactoryName = JMSBridgeDefinition.SOURCE_CONNECTION_FACTORY.resolveModelAttribute(context, model).asString();
        JNDIConnectionFactoryFactory sourceCff = new JNDIConnectionFactoryFactory((Hashtable)sourceContextProperties, sourceConnectionFactoryName);
        String sourceDestinationName = JMSBridgeDefinition.SOURCE_DESTINATION.resolveModelAttribute(context, model).asString();
        JNDIDestinationFactory sourceDestinationFactory = new JNDIDestinationFactory((Hashtable)sourceContextProperties, sourceDestinationName);
        Properties targetContextProperties = this.resolveContextProperties((AttributeDefinition)JMSBridgeDefinition.TARGET_CONTEXT, context, model);
        String targetConnectionFactoryName = JMSBridgeDefinition.TARGET_CONNECTION_FACTORY.resolveModelAttribute(context, model).asString();
        JNDIConnectionFactoryFactory targetCff = new JNDIConnectionFactoryFactory((Hashtable)targetContextProperties, targetConnectionFactoryName);
        String targetDestinationName = JMSBridgeDefinition.TARGET_DESTINATION.resolveModelAttribute(context, model).asString();
        JNDIDestinationFactory targetDestinationFactory = new JNDIDestinationFactory((Hashtable)targetContextProperties, targetDestinationName);
        String sourceUsername = this.resolveAttribute(JMSBridgeDefinition.SOURCE_USER, context, model);
        String sourcePassword = this.resolveAttribute(JMSBridgeDefinition.SOURCE_PASSWORD, context, model);
        String targetUsername = this.resolveAttribute(JMSBridgeDefinition.TARGET_USER, context, model);
        String targetPassword = this.resolveAttribute(JMSBridgeDefinition.TARGET_PASSWORD, context, model);
        String selector = this.resolveAttribute(CommonAttributes.SELECTOR, context, model);
        long failureRetryInterval = JMSBridgeDefinition.FAILURE_RETRY_INTERVAL.resolveModelAttribute(context, model).asLong();
        int maxRetries = JMSBridgeDefinition.MAX_RETRIES.resolveModelAttribute(context, model).asInt();
        QualityOfServiceMode qosMode = QualityOfServiceMode.valueOf((String)JMSBridgeDefinition.QUALITY_OF_SERVICE.resolveModelAttribute(context, model).asString());
        int maxBatchSize = JMSBridgeDefinition.MAX_BATCH_SIZE.resolveModelAttribute(context, model).asInt();
        long maxBatchTime = JMSBridgeDefinition.MAX_BATCH_TIME.resolveModelAttribute(context, model).asLong();
        String subName = this.resolveAttribute(JMSBridgeDefinition.SUBSCRIPTION_NAME, context, model);
        String clientID = this.resolveAttribute(JMSBridgeDefinition.CLIENT_ID, context, model);
        boolean addMessageIDInHeader = JMSBridgeDefinition.ADD_MESSAGE_ID_IN_HEADER.resolveModelAttribute(context, model).asBoolean();
        String moduleName = this.resolveAttribute(JMSBridgeDefinition.MODULE, context, model);
        ClassLoader oldTccl = WildFlySecurityManager.getCurrentContextClassLoaderPrivileged();
        try {
            Module module;
            if (moduleName != null) {
                module = Module.getCallerModuleLoader().loadModule(ModuleIdentifier.fromString((String)moduleName));
                WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)module.getClassLoader());
            }
            module = new JMSBridgeImpl((ConnectionFactoryFactory)sourceCff, (ConnectionFactoryFactory)targetCff, (DestinationFactory)sourceDestinationFactory, (DestinationFactory)targetDestinationFactory, sourceUsername, sourcePassword, targetUsername, targetPassword, selector, failureRetryInterval, maxRetries, qosMode, maxBatchSize, maxBatchTime, subName, clientID, addMessageIDInHeader);
            return module;
        }
        catch (ModuleNotFoundException e) {
            throw MessagingLogger.ROOT_LOGGER.moduleNotFound(moduleName, e.getMessage(), e);
        }
        catch (ModuleLoadException e) {
            throw MessagingLogger.ROOT_LOGGER.unableToLoadModule(moduleName, e);
        }
        finally {
            WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)oldTccl);
        }
    }

    private Properties resolveContextProperties(AttributeDefinition attribute, OperationContext context, ModelNode model) throws OperationFailedException {
        ModelNode contextModel = attribute.resolveModelAttribute(context, model);
        Properties contextProperties = new Properties();
        if (contextModel.isDefined()) {
            for (Property property : contextModel.asPropertyList()) {
                contextProperties.put(property.getName(), property.getValue().asString());
            }
        }
        return contextProperties;
    }

    private String resolveAttribute(SimpleAttributeDefinition attr, OperationContext context, ModelNode model) throws OperationFailedException {
        ModelNode node = attr.resolveModelAttribute(context, model);
        return node.isDefined() ? node.asString() : null;
    }

    private static ExceptionSupplier<CredentialSource, Exception> getCredentialStoreReference(ObjectTypeAttributeDefinition credentialReferenceAttributeDefinition, OperationContext context, ModelNode model, ServiceBuilder<?> serviceBuilder, String ... modelFilter) throws OperationFailedException {
        if (model.hasDefined(credentialReferenceAttributeDefinition.getName())) {
            ModelNode value;
            ModelNode filteredModelNode = model;
            if (modelFilter != null && modelFilter.length > 0) {
                for (String path : modelFilter) {
                    if (!filteredModelNode.get(path).isDefined()) break;
                    filteredModelNode = filteredModelNode.get(path);
                }
            }
            if ((value = credentialReferenceAttributeDefinition.resolveModelAttribute(context, filteredModelNode)).isDefined()) {
                return CredentialReference.getCredentialSourceSupplier((OperationContext)context, (ObjectTypeAttributeDefinition)credentialReferenceAttributeDefinition, (ModelNode)filteredModelNode, serviceBuilder);
            }
        }
        return null;
    }
}

