/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.elytron;

import java.util.Collections;
import java.util.Map;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.transform.ExtensionTransformerRegistration;
import org.jboss.as.controller.transform.SubsystemTransformerRegistration;
import org.jboss.as.controller.transform.TransformationContext;
import org.jboss.as.controller.transform.description.AttributeConverter;
import org.jboss.as.controller.transform.description.AttributeTransformationDescriptionBuilder;
import org.jboss.as.controller.transform.description.ChainedTransformationDescriptionBuilder;
import org.jboss.as.controller.transform.description.DiscardAttributeChecker;
import org.jboss.as.controller.transform.description.RejectAttributeChecker;
import org.jboss.as.controller.transform.description.ResourceTransformationDescriptionBuilder;
import org.jboss.as.controller.transform.description.TransformationDescriptionBuilder;
import org.jboss.dmr.ModelNode;
import org.wildfly.extension.elytron.AuditResourceDefinitions;
import org.wildfly.extension.elytron.ElytronDefinition;
import org.wildfly.extension.elytron.ElytronExtension;
import org.wildfly.extension.elytron.JdbcRealmDefinition;
import org.wildfly.extension.elytron.KerberosSecurityFactoryDefinition;
import org.wildfly.extension.elytron._private.ElytronSubsystemMessages;

public final class ElytronSubsystemTransformers
implements ExtensionTransformerRegistration {
    private static final AttributeConverter MAPPING_PERMISSION_SET_CONVERTER = new AttributeConverter.DefaultAttributeConverter(){

        protected void convertAttribute(PathAddress address, String attributeName, ModelNode attributeValue, TransformationContext context) {
            if (attributeValue.isDefined()) {
                for (ModelNode permissionMapping : attributeValue.asList()) {
                    if (!permissionMapping.hasDefined("permission-sets")) continue;
                    ModelNode permissionSets = permissionMapping.get("permission-sets");
                    for (ModelNode permissionSet : permissionSets.asList()) {
                        ModelNode permissionSetName = permissionSet.get("permission-set");
                        PathAddress permissionSetAddress = address.getParent().append("permission-set", permissionSetName.asString());
                        ModelNode permissions = context.readResourceFromRoot(permissionSetAddress).getModel().get("permissions");
                        for (ModelNode permission : permissions.asList()) {
                            permissionMapping.get("permissions").add(permission);
                        }
                    }
                    permissionMapping.remove("permission-sets");
                }
            }
        }
    };
    private static final AttributeConverter CONSTANT_PERMISSION_SET_CONVERTER = new AttributeConverter.DefaultAttributeConverter(){

        protected void convertAttribute(PathAddress address, String attributeName, ModelNode attributeValue, TransformationContext context) {
            if (attributeValue.isDefined()) {
                ModelNode allPermissions = new ModelNode();
                for (ModelNode permissionSet : attributeValue.asList()) {
                    ModelNode permissionSetName = permissionSet.get("permission-set");
                    PathAddress permissionSetAddress = address.getParent().append("permission-set", permissionSetName.asString());
                    ModelNode permissions = context.readResourceFromRoot(permissionSetAddress).getModel().get("permissions");
                    for (ModelNode permission : permissions.asList()) {
                        allPermissions.add(permission);
                    }
                }
                attributeValue.set(allPermissions);
            }
        }
    };
    private static final RejectAttributeChecker REJECT_IF_DIFFERENT_FROM_SYNCHRONIZED = new RejectAttributeChecker.DefaultRejectAttributeChecker(){

        public String getRejectionLogMessage(Map<String, ModelNode> attributes) {
            return ElytronSubsystemMessages.ROOT_LOGGER.unableToTransformTornAttribute("autoflush", "synchronized");
        }

        protected boolean rejectAttribute(PathAddress address, String attributeName, ModelNode attributeValue, TransformationContext context) {
            if (attributeValue.isDefined()) {
                boolean synced = context.readResourceFromRoot(address).getModel().get("synchronized").asBoolean();
                return synced != attributeValue.asBoolean();
            }
            return false;
        }
    };
    private static final DiscardAttributeChecker DISCARD_IF_EQUALS_SYNCHRONIZED = new DiscardAttributeChecker.DefaultDiscardAttributeChecker(){

        protected boolean isValueDiscardable(PathAddress address, String attributeName, ModelNode attributeValue, TransformationContext context) {
            boolean synced = context.readResourceFromRoot(address).getModel().get("synchronized").asBoolean();
            return synced == attributeValue.asBoolean();
        }
    };

    public String getSubsystemName() {
        return "elytron";
    }

    public void registerTransformers(SubsystemTransformerRegistration registration) {
        ChainedTransformationDescriptionBuilder chainedBuilder = TransformationDescriptionBuilder.Factory.createChainedSubystemInstance((ModelVersion)registration.getCurrentSubsystemVersion());
        ElytronSubsystemTransformers.from6(chainedBuilder);
        ElytronSubsystemTransformers.from5(chainedBuilder);
        ElytronSubsystemTransformers.from4(chainedBuilder);
        ElytronSubsystemTransformers.from3(chainedBuilder);
        ElytronSubsystemTransformers.from2(chainedBuilder);
        chainedBuilder.buildAndRegister(registration, (ModelVersion[][])new ModelVersion[][]{{ElytronExtension.ELYTRON_5_0_0, ElytronExtension.ELYTRON_4_0_0, ElytronExtension.ELYTRON_3_0_0, ElytronExtension.ELYTRON_2_0_0, ElytronExtension.ELYTRON_1_2_0}});
    }

    private static void from6(ChainedTransformationDescriptionBuilder chainedBuilder) {
        ResourceTransformationDescriptionBuilder builder = chainedBuilder.createBuilder(ElytronExtension.ELYTRON_6_0_0, ElytronExtension.ELYTRON_5_0_0);
        ((AttributeTransformationDescriptionBuilder)builder.addChildResource(PathElement.pathElement((String)"key-store")).getAttributeBuilder().addRejectCheck(RejectAttributeChecker.UNDEFINED, new String[]{"type"})).end();
    }

    private static void from5(ChainedTransformationDescriptionBuilder chainedBuilder) {
        ResourceTransformationDescriptionBuilder builder = chainedBuilder.createBuilder(ElytronExtension.ELYTRON_5_0_0, ElytronExtension.ELYTRON_4_0_0);
        ((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)builder.getAttributeBuilder().setDiscard(DiscardAttributeChecker.ALWAYS, new AttributeDefinition[]{ElytronDefinition.REGISTER_JASPI_FACTORY})).addRejectCheck(RejectAttributeChecker.DEFINED, new String[]{"default-ssl-context"})).setDiscard(DiscardAttributeChecker.UNDEFINED, new AttributeDefinition[]{ElytronDefinition.DEFAULT_SSL_CONTEXT})).end();
        builder.rejectChildResource(PathElement.pathElement((String)"jaspi-configuration"));
        ElytronSubsystemTransformers.transformAutoFlush(builder, "file-audit-log");
        ElytronSubsystemTransformers.transformAutoFlush(builder, "periodic-rotating-file-audit-log");
        ElytronSubsystemTransformers.transformAutoFlush(builder, "size-rotating-file-audit-log");
        builder.rejectChildResource(PathElement.pathElement((String)"server-ssl-sni-context"));
        ((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)builder.addChildResource(PathElement.pathElement((String)"token-realm")).getAttributeBuilder().addRejectCheck((RejectAttributeChecker)new RejectAttributeChecker.ObjectFieldsRejectAttributeChecker(Collections.singletonMap("host-name-verification-policy", RejectAttributeChecker.DEFINED)), new String[]{"jwt"})).addRejectCheck((RejectAttributeChecker)new RejectAttributeChecker.ObjectFieldsRejectAttributeChecker(Collections.singletonMap("ssl-context", RejectAttributeChecker.DEFINED)), new String[]{"jwt"})).addRejectCheck((RejectAttributeChecker)new RejectAttributeChecker.ObjectFieldsRejectAttributeChecker(Collections.singletonMap("key-map", RejectAttributeChecker.DEFINED)), new String[]{"jwt"})).end();
    }

    private static void transformAutoFlush(ResourceTransformationDescriptionBuilder builder, String resourceName) {
        ((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)builder.addChildResource(PathElement.pathElement((String)resourceName)).getAttributeBuilder().setDiscard(DISCARD_IF_EQUALS_SYNCHRONIZED, new AttributeDefinition[]{AuditResourceDefinitions.AUTOFLUSH})).addRejectCheck(REJECT_IF_DIFFERENT_FROM_SYNCHRONIZED, new AttributeDefinition[]{AuditResourceDefinitions.AUTOFLUSH})).end();
    }

    private static void from4(ChainedTransformationDescriptionBuilder chainedBuilder) {
        ResourceTransformationDescriptionBuilder builder = chainedBuilder.createBuilder(ElytronExtension.ELYTRON_4_0_0, ElytronExtension.ELYTRON_3_0_0);
        ((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)builder.addChildResource(PathElement.pathElement((String)"jdbc-realm")).getAttributeBuilder().addRejectCheck((RejectAttributeChecker)new RejectAttributeChecker.ListRejectAttributeChecker((RejectAttributeChecker)new RejectAttributeChecker.ObjectFieldsRejectAttributeChecker(Collections.singletonMap("scram-mapper", new RejectAttributeChecker.ObjectFieldsRejectAttributeChecker(Collections.singletonMap("algorithm", new RejectAttributeChecker.SimpleRejectAttributeChecker(new ModelNode("scram-sha-384"))))))), new AttributeDefinition[]{JdbcRealmDefinition.PrincipalQueryAttributes.PRINCIPAL_QUERIES})).addRejectCheck((RejectAttributeChecker)new RejectAttributeChecker.ListRejectAttributeChecker((RejectAttributeChecker)new RejectAttributeChecker.ObjectFieldsRejectAttributeChecker(Collections.singletonMap("scram-mapper", new RejectAttributeChecker.ObjectFieldsRejectAttributeChecker(Collections.singletonMap("algorithm", new RejectAttributeChecker.SimpleRejectAttributeChecker(new ModelNode("scram-sha-512"))))))), new AttributeDefinition[]{JdbcRealmDefinition.PrincipalQueryAttributes.PRINCIPAL_QUERIES})).end();
        builder.rejectChildResource(PathElement.pathElement((String)"certificate-authority-account"));
        builder.rejectChildResource(PathElement.pathElement((String)"mapped-role-mapper"));
        builder.rejectChildResource(PathElement.pathElement((String)"custom-security-event-listener"));
    }

    private static void from3(ChainedTransformationDescriptionBuilder chainedBuilder) {
        ResourceTransformationDescriptionBuilder builder = chainedBuilder.createBuilder(ElytronExtension.ELYTRON_3_0_0, ElytronExtension.ELYTRON_2_0_0);
        builder.discardChildResource(PathElement.pathElement((String)"permission-set"));
        ((AttributeTransformationDescriptionBuilder)builder.addChildResource(PathElement.pathElement((String)"simple-permission-mapper")).getAttributeBuilder().setValueConverter(MAPPING_PERMISSION_SET_CONVERTER, new String[]{"permission-mappings"})).end();
        ((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)builder.addChildResource(PathElement.pathElement((String)"constant-permission-mapper")).getAttributeBuilder().addRename("permission-sets", "permissions")).setValueConverter(CONSTANT_PERMISSION_SET_CONVERTER, new String[]{"permission-sets"})).end();
    }

    private static void from2(ChainedTransformationDescriptionBuilder chainedBuilder) {
        ResourceTransformationDescriptionBuilder builder = chainedBuilder.createBuilder(ElytronExtension.ELYTRON_2_0_0, ElytronExtension.ELYTRON_1_2_0);
        ((AttributeTransformationDescriptionBuilder)builder.addChildResource(PathElement.pathElement((String)"kerberos-security-factory")).getAttributeBuilder().setDiscard((DiscardAttributeChecker)new DiscardAttributeChecker.DiscardAttributeValueChecker(new ModelNode[]{new ModelNode(0)}), new AttributeDefinition[]{KerberosSecurityFactoryDefinition.FAIL_CACHE})).addRejectCheck(RejectAttributeChecker.DEFINED, new AttributeDefinition[]{KerberosSecurityFactoryDefinition.FAIL_CACHE});
    }
}

