/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.metrics;

import io.smallrye.metrics.MetricRegistries;
import io.smallrye.metrics.exporters.Exporter;
import io.smallrye.metrics.exporters.JsonExporter;
import io.smallrye.metrics.exporters.JsonMetadataExporter;
import io.smallrye.metrics.exporters.PrometheusExporter;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import javax.enterprise.context.ApplicationScoped;
import org.eclipse.microprofile.metrics.MetricRegistry;

@ApplicationScoped
public class MetricsRequestHandler {
    private static final Map<String, String> corsHeaders = new HashMap<String, String>();

    /*
     * Enabled aggressive block sorting
     */
    public void handleRequest(String requestPath, String method, Stream<String> acceptHeaders, Responder responder) throws IOException {
        StringBuffer sb;
        Exporter exporter = this.obtainExporter(method, acceptHeaders, responder);
        if (exporter == null) {
            return;
        }
        String scopePath = requestPath.substring(8);
        if (scopePath.startsWith("/")) {
            scopePath = scopePath.substring(1);
        }
        if (scopePath.endsWith("/")) {
            scopePath = scopePath.substring(0, scopePath.length() - 1);
        }
        if (scopePath.isEmpty()) {
            sb = exporter.exportAllScopes();
        } else if (scopePath.contains("/")) {
            String attribute = scopePath.substring(scopePath.indexOf(47) + 1);
            MetricRegistry.Type scope = this.getScopeFromPath(responder, scopePath.substring(0, scopePath.indexOf(47)));
            if (scope == null) {
                responder.respondWith(404, "Scope " + scopePath + " not found", Collections.emptyMap());
                return;
            }
            MetricRegistry registry = MetricRegistries.get(scope);
            Map metricValuesMap = registry.getMetrics();
            if (!metricValuesMap.containsKey(attribute)) {
                responder.respondWith(404, "Metric " + scopePath + " not found", Collections.emptyMap());
                return;
            }
            sb = exporter.exportOneMetric(scope, attribute);
        } else {
            MetricRegistry.Type scope = this.getScopeFromPath(responder, scopePath);
            if (scope == null) {
                responder.respondWith(404, "Scope " + scopePath + " not found", Collections.emptyMap());
                return;
            }
            MetricRegistry reg = MetricRegistries.get(scope);
            if (reg.getMetadata().size() == 0) {
                responder.respondWith(204, "No data in scope " + scopePath, Collections.emptyMap());
                return;
            }
            sb = exporter.exportOneScope(scope);
        }
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", exporter.getContentType());
        headers.put("Access-Control-Max-Age", "1209600");
        headers.putAll(corsHeaders);
        responder.respondWith(200, sb.toString(), headers);
    }

    private MetricRegistry.Type getScopeFromPath(Responder responder, String scopePath) throws IOException {
        MetricRegistry.Type scope;
        try {
            scope = MetricRegistry.Type.valueOf((String)scopePath.toUpperCase());
        }
        catch (IllegalArgumentException iae) {
            responder.respondWith(404, "Bad scope requested: " + scopePath, Collections.emptyMap());
            return null;
        }
        return scope;
    }

    private Exporter obtainExporter(String method, Stream<String> acceptHeaders, Responder responder) throws IOException {
        if (!method.equals("GET") && !method.equals("OPTIONS")) {
            responder.respondWith(405, "Only GET and OPTIONS methods are accepted.", Collections.emptyMap());
            return null;
        }
        if (acceptHeaders != null && acceptHeaders.findFirst().map(e -> e.startsWith("application/json")).orElse(false).booleanValue()) {
            if (method.equals("GET")) {
                return new JsonExporter();
            }
            return new JsonMetadataExporter();
        }
        if (method.equals("GET")) {
            return new PrometheusExporter();
        }
        responder.respondWith(406, "OPTIONS method is only allowed with application/json media type.", Collections.emptyMap());
        return null;
    }

    static {
        corsHeaders.put("Access-Control-Allow-Origin", "*");
        corsHeaders.put("Access-Control-Allow-Headers", "origin, content-type, accept, authorization");
        corsHeaders.put("Access-Control-Allow-Credentials", "true");
        corsHeaders.put("Access-Control-Allow-Methods", "GET, POST, PUT, DELETE, OPTIONS, HEAD");
    }

    public static interface Responder {
        public void respondWith(int var1, String var2, Map<String, String> var3) throws IOException;
    }
}

