/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.infinispan.session.fine;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import org.infinispan.Cache;
import org.infinispan.commons.marshall.NotSerializableException;
import org.infinispan.context.Flag;
import org.wildfly.clustering.ee.Mutator;
import org.wildfly.clustering.ee.infinispan.CacheEntryMutator;
import org.wildfly.clustering.ee.infinispan.CacheProperties;
import org.wildfly.clustering.infinispan.spi.function.ConcurrentMapPutFunction;
import org.wildfly.clustering.infinispan.spi.function.ConcurrentMapRemoveFunction;
import org.wildfly.clustering.infinispan.spi.function.CopyOnWriteMapPutFunction;
import org.wildfly.clustering.infinispan.spi.function.CopyOnWriteMapRemoveFunction;
import org.wildfly.clustering.marshalling.spi.InvalidSerializedFormException;
import org.wildfly.clustering.marshalling.spi.Marshaller;
import org.wildfly.clustering.web.infinispan.logging.InfinispanWebLogger;
import org.wildfly.clustering.web.infinispan.session.SessionAttributes;
import org.wildfly.clustering.web.infinispan.session.fine.SessionAttributeKey;
import org.wildfly.clustering.web.infinispan.session.fine.SessionAttributeNamesKey;
import org.wildfly.clustering.web.session.SessionAttributeImmutability;

public class FineSessionAttributes<V>
implements SessionAttributes {
    private final String id;
    private final Cache<SessionAttributeNamesKey, Map<String, UUID>> namesCache;
    private final Cache<SessionAttributeKey, V> attributeCache;
    private final Map<String, Mutator> mutations = new ConcurrentHashMap<String, Mutator>();
    private final Marshaller<Object, V> marshaller;
    private final CacheProperties properties;
    private volatile Map<String, UUID> names;

    public FineSessionAttributes(String id, Map<String, UUID> names, Cache<SessionAttributeNamesKey, Map<String, UUID>> namesCache, Cache<SessionAttributeKey, V> attributeCache, Marshaller<Object, V> marshaller, CacheProperties properties) {
        this.id = id;
        this.setNames(names);
        this.namesCache = namesCache;
        this.attributeCache = attributeCache;
        this.marshaller = marshaller;
        this.properties = properties;
    }

    public Object removeAttribute(String name) {
        UUID attributeId = this.names.get(name);
        if (attributeId == null) {
            return null;
        }
        this.setNames((Map)this.namesCache.getAdvancedCache().withFlags(new Flag[]{Flag.FORCE_SYNCHRONOUS}).computeIfPresent((Object)this.createKey(), (BiFunction)(this.properties.isTransactional() ? new CopyOnWriteMapRemoveFunction((Object)name) : new ConcurrentMapRemoveFunction((Object)name))));
        Object result = this.read(name, this.attributeCache.getAdvancedCache().withFlags(new Flag[]{Flag.FORCE_SYNCHRONOUS}).remove((Object)this.createKey(attributeId)));
        this.mutations.remove(name);
        return result;
    }

    public Object setAttribute(String name, Object attribute) {
        if (attribute == null) {
            return this.removeAttribute(name);
        }
        if (this.properties.isMarshalling() && !this.marshaller.isMarshallable(attribute)) {
            throw new IllegalArgumentException((Throwable)new NotSerializableException(attribute.getClass().getName()));
        }
        Object value = this.marshaller.write(attribute);
        UUID attributeId = this.names.get(name);
        if (attributeId == null) {
            UUID newAttributeId = UUID.randomUUID();
            this.setNames((Map)this.namesCache.getAdvancedCache().withFlags(new Flag[]{Flag.FORCE_SYNCHRONOUS}).compute((Object)this.createKey(), (BiFunction)(this.properties.isTransactional() ? new CopyOnWriteMapPutFunction((Object)name, (Object)newAttributeId) : new ConcurrentMapPutFunction((Object)name, (Object)newAttributeId))));
            attributeId = this.names.get(name);
        }
        Object result = this.read(name, this.attributeCache.getAdvancedCache().withFlags(new Flag[]{Flag.FORCE_SYNCHRONOUS}).put((Object)this.createKey(attributeId), value));
        this.mutations.remove(name);
        return result;
    }

    public Object getAttribute(String name) {
        UUID attributeId = this.names.get(name);
        if (attributeId == null) {
            return null;
        }
        SessionAttributeKey key = this.createKey(attributeId);
        Object value = this.attributeCache.get((Object)key);
        Object attribute = this.read(name, value);
        if (attribute != null && !SessionAttributeImmutability.INSTANCE.test(attribute)) {
            Mutator mutator = this.mutations.computeIfAbsent(name, k -> new CacheEntryMutator(this.attributeCache, (Object)key, value));
            if (this.properties.isTransactional()) {
                mutator.mutate();
            }
        }
        return attribute;
    }

    public Set<String> getAttributeNames() {
        return this.names.keySet();
    }

    @Override
    public void close() {
        if (!this.properties.isTransactional()) {
            for (Mutator mutator : this.mutations.values()) {
                mutator.mutate();
            }
        }
        this.mutations.clear();
    }

    private void setNames(Map<String, UUID> names) {
        this.names = names != null ? Collections.unmodifiableMap(names) : Collections.emptyMap();
    }

    private SessionAttributeNamesKey createKey() {
        return new SessionAttributeNamesKey(this.id);
    }

    private SessionAttributeKey createKey(UUID attributeId) {
        return new SessionAttributeKey(this.id, attributeId);
    }

    private Object read(String name, V value) {
        try {
            return this.marshaller.read(value);
        }
        catch (InvalidSerializedFormException e) {
            throw InfinispanWebLogger.ROOT_LOGGER.failedToReadSessionAttribute(e, this.id, name);
        }
    }
}

