/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors.impl;

import java.util.List;
import javax.transaction.Transaction;
import org.infinispan.commands.tx.CommitCommand;
import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.commands.tx.RollbackCommand;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.commons.marshall.StreamingMarshaller;
import org.infinispan.container.impl.InternalEntryFactory;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.interceptors.DDAsyncInterceptor;
import org.infinispan.interceptors.impl.TxBatchUpdater;
import org.infinispan.persistence.manager.PersistenceManager;
import org.infinispan.transaction.impl.AbstractCacheTransaction;

public class TransactionalStoreInterceptor
extends DDAsyncInterceptor {
    @Inject
    private PersistenceManager persistenceManager;
    @Inject
    private InternalEntryFactory entryFactory;
    @Inject
    private StreamingMarshaller marshaller;

    @Override
    public Object visitPrepareCommand(TxInvocationContext ctx, PrepareCommand command) throws Throwable {
        if (ctx.isOriginLocal()) {
            Transaction tx = ctx.getTransaction();
            TxBatchUpdater modBuilder = TxBatchUpdater.createTxStoreUpdater(this.persistenceManager, this.entryFactory, this.marshaller, ((AbstractCacheTransaction)ctx.getCacheTransaction()).getAffectedKeys());
            List<WriteCommand> modifications = ((AbstractCacheTransaction)ctx.getCacheTransaction()).getAllModifications();
            for (WriteCommand writeCommand : modifications) {
                writeCommand.acceptVisitor(ctx, modBuilder);
            }
            this.persistenceManager.prepareAllTxStores(tx, modBuilder.getModifications(), PersistenceManager.AccessMode.SHARED);
        }
        return this.invokeNext(ctx, command);
    }

    @Override
    public Object visitCommitCommand(TxInvocationContext ctx, CommitCommand command) throws Throwable {
        if (ctx.isOriginLocal()) {
            this.persistenceManager.commitAllTxStores(ctx.getTransaction(), PersistenceManager.AccessMode.SHARED);
        }
        return this.invokeNext(ctx, command);
    }

    @Override
    public Object visitRollbackCommand(TxInvocationContext ctx, RollbackCommand command) throws Throwable {
        if (ctx.isOriginLocal()) {
            this.persistenceManager.rollbackAllTxStores(ctx.getTransaction(), PersistenceManager.AccessMode.SHARED);
        }
        return this.invokeNext(ctx, command);
    }
}

