/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.remoting.inboundhandler.action;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.distribution.LocalizedCacheTopology;
import org.infinispan.remoting.inboundhandler.action.Action;
import org.infinispan.remoting.inboundhandler.action.ActionState;
import org.infinispan.remoting.inboundhandler.action.ActionStatus;
import org.infinispan.util.concurrent.locks.RemoteLockCommand;

public abstract class BaseLockingAction
implements Action {
    private static final AtomicReferenceFieldUpdater<BaseLockingAction, InternalState> UPDATER = AtomicReferenceFieldUpdater.newUpdater(BaseLockingAction.class, InternalState.class, "internalState");
    private final DistributionManager distributionManager;
    private volatile InternalState internalState;

    public BaseLockingAction(DistributionManager distributionManager) {
        this.distributionManager = distributionManager;
        this.internalState = InternalState.INIT;
    }

    @Override
    public final ActionStatus check(ActionState state) {
        switch (this.internalState) {
            case INIT: {
                return this.init(state);
            }
            case CHECKING: {
                return this.checking(state);
            }
            case MAKE_READY: {
                return ActionStatus.NOT_READY;
            }
            case READY: {
                return ActionStatus.READY;
            }
            case CANCELED: {
                return ActionStatus.CANCELED;
            }
        }
        return ActionStatus.NOT_READY;
    }

    protected abstract ActionStatus checking(ActionState var1);

    protected abstract ActionStatus init(ActionState var1);

    protected final boolean cas(InternalState expectedState, InternalState newState) {
        return UPDATER.compareAndSet(this, expectedState, newState);
    }

    private void filterByLockOwner(Collection<?> keys, Collection<Object> toAdd) {
        LocalizedCacheTopology cacheTopology = this.distributionManager.getCacheTopology();
        for (Object key : keys) {
            if (!cacheTopology.getDistribution(key).isPrimary()) continue;
            toAdd.add(key);
        }
    }

    protected final List<Object> getAndUpdateFilteredKeys(ActionState state) {
        List<Object> filteredKeys = state.getFilteredKeys();
        if (filteredKeys == null) {
            RemoteLockCommand remoteLockCommand = (RemoteLockCommand)state.getCommand();
            Collection<?> rawKeys = remoteLockCommand.getKeysToLock();
            filteredKeys = new ArrayList<Object>(rawKeys.size());
            this.filterByLockOwner(rawKeys, filteredKeys);
            state.updateFilteredKeys(filteredKeys);
        }
        return filteredKeys;
    }

    protected static enum InternalState {
        INIT,
        CHECKING,
        CANCELED,
        MAKE_READY,
        READY;

    }
}

