/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.weld.deployment.processor;

import java.util.function.Supplier;
import org.jboss.as.ee.beanvalidation.BeanValidationAttachments;
import org.jboss.as.ee.weld.WeldDeploymentMarker;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.weld.CdiValidatorFactoryService;
import org.jboss.as.weld.ServiceNames;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;

public class CdiBeanValidationFactoryProcessor
implements DeploymentUnitProcessor {
    public void deploy(DeploymentPhaseContext phaseContext) {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        DeploymentUnit topLevelDeployment = deploymentUnit.getParent() == null ? deploymentUnit : deploymentUnit.getParent();
        ServiceName weldStartService = topLevelDeployment.getServiceName().append(ServiceNames.WELD_START_SERVICE_NAME);
        if (!WeldDeploymentMarker.isPartOfWeldDeployment((DeploymentUnit)deploymentUnit)) {
            return;
        }
        if (!deploymentUnit.hasAttachment(BeanValidationAttachments.VALIDATOR_FACTORY)) {
            return;
        }
        ServiceTarget serviceTarget = phaseContext.getServiceTarget();
        ServiceName serviceName = deploymentUnit.getServiceName().append(CdiValidatorFactoryService.SERVICE_NAME);
        ServiceBuilder sb = serviceTarget.addService(serviceName);
        Supplier beanManagerSupplier = sb.requires(ServiceNames.beanManagerServiceName((DeploymentUnit)deploymentUnit));
        sb.requires(weldStartService);
        sb.setInstance((Service)new CdiValidatorFactoryService(deploymentUnit, beanManagerSupplier));
        sb.install();
    }

    public void undeploy(DeploymentUnit context) {
    }
}

