/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.negotiation.spnego;

import java.io.IOException;
import java.io.InputStream;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.Oid;
import org.jboss.logging.Logger;
import org.jboss.security.negotiation.Constants;
import org.jboss.security.negotiation.MessageFactory;
import org.jboss.security.negotiation.NegotiationMessage;
import org.jboss.security.negotiation.spnego.encoding.NegTokenInitDecoder;
import org.jboss.security.negotiation.spnego.encoding.NegTokenTargDecoder;

public class SPNEGOMessageFactory
extends MessageFactory {
    private static final Logger log = Logger.getLogger(SPNEGOMessageFactory.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean accepts(InputStream in) throws IOException {
        if (!in.markSupported()) {
            throw new IllegalArgumentException("The passed in InputStream needs to support mark/reset.");
        }
        in.mark(1);
        try {
            int dataRead = in.read();
            if (dataRead == 96) {
                int length = NegTokenInitDecoder.readLength(in);
                Oid messageId = new Oid(in);
                boolean bl = Constants.SPNEGO.equals(messageId);
                return bl;
            }
            if (dataRead == 161) {
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (GSSException e) {
            log.debug((Object)"Error determining message Oid", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            in.reset();
        }
    }

    public NegotiationMessage createMessage(InputStream in) throws IOException {
        if (this.accepts(in)) {
            in.mark(1);
            int dataRead = in.read();
            in.reset();
            try {
                if (dataRead == 96) {
                    return NegTokenInitDecoder.decode(in);
                }
                return NegTokenTargDecoder.decode(in);
            }
            catch (GSSException e) {
                IOException ioe = new IOException("Unable to createMessage");
                ioe.initCause(e);
                throw ioe;
            }
        }
        throw new IllegalArgumentException("InputStream does not contain SPNEGO message.");
    }
}

